/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.linuxsampler.lscp.AbstractInstrument;
import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.AudioOutputChannel;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.AudioOutputDriver;
import org.linuxsampler.lscp.BoolListParameter;
import org.linuxsampler.lscp.BoolParameter;
import org.linuxsampler.lscp.BufferFill;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.DbSearchQuery;
import org.linuxsampler.lscp.FloatListParameter;
import org.linuxsampler.lscp.FloatParameter;
import org.linuxsampler.lscp.FxSend;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.IntListParameter;
import org.linuxsampler.lscp.IntParameter;
import org.linuxsampler.lscp.LSException;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.LscpInputStream;
import org.linuxsampler.lscp.LscpOutputStream;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiInputDriver;
import org.linuxsampler.lscp.MidiInstrumentEntry;
import org.linuxsampler.lscp.MidiInstrumentInfo;
import org.linuxsampler.lscp.MidiInstrumentMapInfo;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.Parameter;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;
import org.linuxsampler.lscp.ResultSet;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.SamplerEngine;
import org.linuxsampler.lscp.ScanJobInfo;
import org.linuxsampler.lscp.ServerInfo;
import org.linuxsampler.lscp.StringListParameter;
import org.linuxsampler.lscp.StringParameter;
import org.linuxsampler.lscp.event.BufferFillEvent;
import org.linuxsampler.lscp.event.BufferFillListener;
import org.linuxsampler.lscp.event.ChannelCountEvent;
import org.linuxsampler.lscp.event.ChannelCountListener;
import org.linuxsampler.lscp.event.ChannelInfoEvent;
import org.linuxsampler.lscp.event.ChannelInfoListener;
import org.linuxsampler.lscp.event.ChannelMidiDataEvent;
import org.linuxsampler.lscp.event.ChannelMidiDataListener;
import org.linuxsampler.lscp.event.DeviceMidiDataEvent;
import org.linuxsampler.lscp.event.DeviceMidiDataListener;
import org.linuxsampler.lscp.event.FxSendCountEvent;
import org.linuxsampler.lscp.event.FxSendCountListener;
import org.linuxsampler.lscp.event.FxSendInfoEvent;
import org.linuxsampler.lscp.event.FxSendInfoListener;
import org.linuxsampler.lscp.event.GlobalInfoEvent;
import org.linuxsampler.lscp.event.GlobalInfoListener;
import org.linuxsampler.lscp.event.InstrumentsDbEvent;
import org.linuxsampler.lscp.event.InstrumentsDbListener;
import org.linuxsampler.lscp.event.ItemCountEvent;
import org.linuxsampler.lscp.event.ItemCountListener;
import org.linuxsampler.lscp.event.ItemInfoEvent;
import org.linuxsampler.lscp.event.ItemInfoListener;
import org.linuxsampler.lscp.event.MidiDataEvent;
import org.linuxsampler.lscp.event.MidiInstrumentCountEvent;
import org.linuxsampler.lscp.event.MidiInstrumentCountListener;
import org.linuxsampler.lscp.event.MidiInstrumentInfoEvent;
import org.linuxsampler.lscp.event.MidiInstrumentInfoListener;
import org.linuxsampler.lscp.event.MiscellaneousEvent;
import org.linuxsampler.lscp.event.MiscellaneousListener;
import org.linuxsampler.lscp.event.StreamCountEvent;
import org.linuxsampler.lscp.event.StreamCountListener;
import org.linuxsampler.lscp.event.TotalStreamCountEvent;
import org.linuxsampler.lscp.event.TotalStreamCountListener;
import org.linuxsampler.lscp.event.TotalVoiceCountEvent;
import org.linuxsampler.lscp.event.TotalVoiceCountListener;
import org.linuxsampler.lscp.event.VoiceCountEvent;
import org.linuxsampler.lscp.event.VoiceCountListener;

public class Client {
    private String address;
    private int port;
    private Socket sock = null;
    private int soTimeout = 20000;
    private LscpInputStream in = null;
    private LscpOutputStream out = null;
    private EventThread eventThread;
    private boolean printOnlyMode = false;
    private boolean extendedCharacterEscaping = true;
    private final Vector<ItemCountListener> llAODC = new Vector();
    private final Vector<ItemInfoListener> llAODI = new Vector();
    private final Vector<BufferFillListener> llBF = new Vector();
    private final Vector<ChannelCountListener> llCC = new Vector();
    private final Vector<ChannelInfoListener> llCI = new Vector();
    private final Vector<FxSendCountListener> llFSC = new Vector();
    private final Vector<FxSendInfoListener> llFSI = new Vector();
    private final Vector<MiscellaneousListener> llM = new Vector();
    private final Vector<ItemCountListener> llMIDC = new Vector();
    private final Vector<ItemInfoListener> llMIDI = new Vector();
    private final Vector<StreamCountListener> llSC = new Vector();
    private final Vector<VoiceCountListener> llVC = new Vector();
    private final Vector<TotalStreamCountListener> llTSC = new Vector();
    private final Vector<TotalVoiceCountListener> llTVC = new Vector();
    private final Vector<ItemCountListener> llMIMC = new Vector();
    private final Vector<ItemInfoListener> llMIMI = new Vector();
    private final Vector<MidiInstrumentCountListener> llMIC = new Vector();
    private final Vector<MidiInstrumentInfoListener> llMII = new Vector();
    private final Vector<DeviceMidiDataListener> llDMD = new Vector();
    private final Vector<ChannelMidiDataListener> llCMD = new Vector();
    private final Vector<InstrumentsDbListener> llID = new Vector();
    private final Vector<GlobalInfoListener> llGI = new Vector();

    public Client() {
        this("127.0.0.1");
    }

    public Client(String string) {
        this(string, 8888);
    }

    public Client(String string, int n) {
        this.setServerAddress(string);
        this.setServerPort(n);
        this.eventThread = new EventThread();
    }

    public Client(boolean bl) {
        if (bl) {
            this.setPrintOnlyMode(true);
        }
    }

    public synchronized void setExtendedCharacterEscaping(boolean bl) {
        this.extendedCharacterEscaping = bl;
    }

    public synchronized boolean getExtendedCharacterEscaping() {
        return this.extendedCharacterEscaping;
    }

    public synchronized void setSoTimeout(int n) {
        this.soTimeout = n;
        try {
            if (this.sock != null) {
                this.sock.setSoTimeout(n);
            }
        }
        catch (Exception exception) {
            Client.getLogger().log(Level.INFO, "Unable to set timeout", exception);
        }
    }

    private String toEscapedText(String string) {
        string = Parser.toEscapedString(string);
        return this.conv(string);
    }

    private String toEscapedFsEntry(String string) {
        string = Parser.toEscapedFileName(string);
        return this.conv(string);
    }

    private String conv(String string) {
        return this.getExtendedCharacterEscaping() ? Parser.toExtendedEscapeSequence(string) : string;
    }

    public synchronized boolean getPrintOnlyMode() {
        return this.printOnlyMode;
    }

    public synchronized void setPrintOnlyMode(boolean bl) {
        if (this.printOnlyMode == bl) {
            return;
        }
        if (this.isConnected()) {
            throw new IllegalStateException();
        }
        this.printOnlyMode = bl;
        if (bl) {
            this.out = new LscpOutputStream(System.out);
        }
    }

    public synchronized void setPrintOnlyModeOutputStream(OutputStream outputStream) {
        if (!this.getPrintOnlyMode()) {
            throw new IllegalStateException("Not in print-only mode");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("out must be non-null");
        }
        this.out = new LscpOutputStream(outputStream);
    }

    public static String getClientVersion() {
        return Package.getPackage("org.linuxsampler.lscp").getImplementationVersion();
    }

    public synchronized String getServerAddress() {
        return this.address;
    }

    public synchronized void setServerAddress(String string) {
        this.address = string == null ? "127.0.0.1" : string;
    }

    public synchronized int getServerPort() {
        return this.port;
    }

    public synchronized void setServerPort(int n) {
        this.port = n;
    }

    public synchronized void connect() throws LscpException {
        String string;
        String string2;
        String string3;
        if (this.sock != null) {
            this.disconnect();
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        if (this.eventThread.isAlive()) {
            Client.getLogger().warning("LSCP event thread already running!");
            this.eventThread.terminate();
        }
        if (this.eventThread.getState() != Thread.State.NEW) {
            this.eventThread = new EventThread();
        }
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = new InetSocketAddress(this.address, this.port);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string4 = String.valueOf(this.port);
            throw new LscpException(LscpI18n.getLogMsg("Client.invalidPort!", string4), illegalArgumentException);
        }
        if (inetSocketAddress.isUnresolved()) {
            throw new LscpException(LscpI18n.getLogMsg("Client.unknownHost!", this.address));
        }
        try {
            this.sock = new Socket();
            this.sock.bind(null);
            this.sock.connect(inetSocketAddress, this.soTimeout);
            this.sock.setSoTimeout(this.soTimeout);
            this.sock.setTcpNoDelay(true);
            this.in = new LscpInputStream(this.sock.getInputStream());
            this.out = new LscpOutputStream(this.sock.getOutputStream());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new LscpException(LscpI18n.getLogMsg("Client.conTimeout!"), socketTimeoutException);
        }
        catch (Exception exception) {
            throw new LscpException(LscpI18n.getLogMsg("Client.connectionFailed!"), exception);
        }
        String string5 = Package.getPackage("org.linuxsampler.lscp").getSpecificationVersion();
        try {
            string3 = string5.substring(0, string5.indexOf(46));
            string2 = this.getServerInfo().getProtocolVersion();
            string = string2.substring(0, string2.indexOf(46));
        }
        catch (Exception exception) {
            this.disconnect();
            throw new LscpException(LscpI18n.getLogMsg("Client.connectionFailed!"), exception);
        }
        if (!string.equals(string3)) {
            this.disconnect();
            throw new LscpException(LscpI18n.getLogMsg("Client.incompatibleLscpVersion!", string2));
        }
        string3 = string5.substring(string5.indexOf(46));
        string = string2.substring(string2.indexOf(46));
        if (string.compareToIgnoreCase(string3) < 0) {
            Client.getLogger().info(LscpI18n.getLogMsg("Client.incompatibleLscpMinVersion!", string2));
        }
        if (this.hasSubscriptions()) {
            this.eventThread.start();
        }
        if (!this.llM.isEmpty()) {
            this.subscribe("MISCELLANEOUS");
        }
        if (!this.llAODC.isEmpty()) {
            this.subscribe("AUDIO_OUTPUT_DEVICE_COUNT");
        }
        if (!this.llAODI.isEmpty()) {
            this.subscribe("AUDIO_OUTPUT_DEVICE_INFO");
        }
        if (!this.llMIDC.isEmpty()) {
            this.subscribe("MIDI_INPUT_DEVICE_COUNT");
        }
        if (!this.llMIDI.isEmpty()) {
            this.subscribe("MIDI_INPUT_DEVICE_INFO");
        }
        if (!this.llBF.isEmpty()) {
            this.subscribe("BUFFER_FILL");
        }
        if (!this.llCC.isEmpty()) {
            this.subscribe("CHANNEL_COUNT");
        }
        if (!this.llCI.isEmpty()) {
            this.subscribe("CHANNEL_INFO");
        }
        if (!this.llFSC.isEmpty()) {
            this.subscribe("FX_SEND_COUNT");
        }
        if (!this.llFSI.isEmpty()) {
            this.subscribe("FX_SEND_INFO");
        }
        if (!this.llSC.isEmpty()) {
            this.subscribe("STREAM_COUNT");
        }
        if (!this.llVC.isEmpty()) {
            this.subscribe("VOICE_COUNT");
        }
        if (!this.llTSC.isEmpty()) {
            this.subscribe("TOTAL_STREAM_COUNT");
        }
        if (!this.llTVC.isEmpty()) {
            this.subscribe("TOTAL_VOICE_COUNT");
        }
        if (!this.llMIMC.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_MAP_COUNT");
        }
        if (!this.llMIMI.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_MAP_INFO");
        }
        if (!this.llMIC.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_COUNT");
        }
        if (!this.llMII.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_INFO");
        }
        if (!this.llDMD.isEmpty()) {
            this.subscribe("DEVICE_MIDI");
        }
        if (!this.llCMD.isEmpty()) {
            this.subscribe("CHANNEL_MIDI");
        }
        if (!this.llID.isEmpty()) {
            this.subscribe("DB_INSTRUMENT_DIRECTORY_COUNT");
            this.subscribe("DB_INSTRUMENT_DIRECTORY_INFO");
            this.subscribe("DB_INSTRUMENT_COUNT");
            this.subscribe("DB_INSTRUMENT_INFO");
            this.subscribe("DB_INSTRUMENTS_JOB_INFO");
        }
        if (!this.llGI.isEmpty()) {
            this.subscribe("GLOBAL_INFO");
        }
    }

    public synchronized void disconnect() {
        if (this.getPrintOnlyMode()) {
            return;
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception exception) {
            Client.getLogger().log(Level.FINE, exception.getMessage(), exception);
        }
        this.sock = null;
        if (this.eventThread.getState() != Thread.State.NEW) {
            this.eventThread.terminate();
            this.eventThread = new EventThread();
        }
    }

    public synchronized boolean isConnected() {
        if (this.sock == null) {
            return false;
        }
        return this.sock.isConnected();
    }

    private void verifyConnection() throws IOException {
        if (this.getPrintOnlyMode()) {
            return;
        }
        if (!this.isConnected()) {
            throw new IOException(LscpI18n.getLogMsg("Client.notConnected!"));
        }
    }

    private String getLine() throws IOException, LscpException {
        String string;
        while ((string = this.in.readLine()).startsWith("NOTIFY:")) {
            this.eventThread.scheduleNotification(string.substring("NOTIFY:".length()));
        }
        return string;
    }

    private synchronized void processNotifications() throws IOException, LscpException {
        while (this.in.available() > 0) {
            String string = this.in.readLine();
            if (string.startsWith("NOTIFY:")) {
                this.fireEvent(string.substring("NOTIFY:".length()));
                continue;
            }
            Client.getLogger().severe("Unknown notification format: " + string);
        }
    }

    private ResultSet getEmptyResultSet() throws IOException, LscpException, LSException {
        return Parser.parseEmptyResultSet(this.getLine());
    }

    private ResultSet getSingleLineResultSet() throws IOException, LscpException, LSException {
        ResultSet resultSet = new ResultSet();
        String string = this.getLine();
        if (string.startsWith("WRN")) {
            Parser.parseWarning(string, resultSet);
            Client.getLogger().warning(resultSet.getMessage());
            return resultSet;
        }
        if (string.startsWith("ERR")) {
            Parser.parseError(string, resultSet);
            throw new LSException(resultSet.getCode(), resultSet.getMessage());
        }
        resultSet.setResult(string);
        return resultSet;
    }

    private ResultSet getMultiLineResultSet() throws IOException, LscpException, LSException {
        ResultSet resultSet = new ResultSet();
        String string = this.getLine();
        if (string.startsWith("WRN")) {
            Parser.parseWarning(string, resultSet);
            Client.getLogger().warning(resultSet.getMessage());
            return resultSet;
        }
        if (string.startsWith("ERR")) {
            Parser.parseError(string, resultSet);
            throw new LSException(resultSet.getCode(), resultSet.getMessage());
        }
        while (!string.equals(".")) {
            resultSet.addLine(string);
            string = this.getLine();
        }
        return resultSet;
    }

    private boolean hasSubscriptions() {
        return !this.llAODC.isEmpty() || !this.llAODI.isEmpty() || !this.llBF.isEmpty() || !this.llCC.isEmpty() || !this.llCI.isEmpty() || !this.llFSC.isEmpty() || !this.llFSI.isEmpty() || !this.llM.isEmpty() || !this.llMIDC.isEmpty() || !this.llMIDI.isEmpty() || !this.llSC.isEmpty() || !this.llVC.isEmpty() || !this.llTSC.isEmpty() || !this.llTVC.isEmpty() || !this.llMIMC.isEmpty() || !this.llMIMI.isEmpty() || !this.llMIC.isEmpty() || !this.llMII.isEmpty() || !this.llDMD.isEmpty() || !this.llCMD.isEmpty() || !this.llID.isEmpty() || !this.llGI.isEmpty();
    }

    private synchronized void fireDeviceMidiDataEvent(String string) {
        try {
            String[] stringArray = Parser.parseList(string, ' ');
            if (stringArray.length != 5) {
                Client.getLogger().warning("Unknown DEVICE_MIDI format");
                return;
            }
            int n = Parser.parseInt(stringArray[0]);
            int n2 = Parser.parseInt(stringArray[1]);
            MidiDataEvent.Type type = this.parseMidiDataType(stringArray[2]);
            if (type == null) {
                return;
            }
            int n3 = Parser.parseInt(stringArray[3]);
            int n4 = Parser.parseInt(stringArray[4]);
            DeviceMidiDataEvent deviceMidiDataEvent = new DeviceMidiDataEvent(this, type, n3, n4);
            deviceMidiDataEvent.setDeviceId(n);
            deviceMidiDataEvent.setPortId(n2);
            for (DeviceMidiDataListener deviceMidiDataListener : this.llDMD) {
                deviceMidiDataListener.midiDataArrived(deviceMidiDataEvent);
            }
        }
        catch (LscpException lscpException) {
            Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("CommandFailed!"), lscpException);
        }
    }

    private synchronized void fireChannelMidiDataEvent(String string) {
        try {
            String[] stringArray = Parser.parseList(string, ' ');
            if (stringArray.length != 4) {
                Client.getLogger().warning("Unknown CHANNEL_MIDI format");
                return;
            }
            int n = Parser.parseInt(stringArray[0]);
            MidiDataEvent.Type type = this.parseMidiDataType(stringArray[1]);
            if (type == null) {
                return;
            }
            int n2 = Parser.parseInt(stringArray[2]);
            int n3 = Parser.parseInt(stringArray[3]);
            ChannelMidiDataEvent channelMidiDataEvent = new ChannelMidiDataEvent(this, type, n2, n3);
            channelMidiDataEvent.setChannelId(n);
            for (ChannelMidiDataListener channelMidiDataListener : this.llCMD) {
                channelMidiDataListener.midiDataArrived(channelMidiDataEvent);
            }
        }
        catch (LscpException lscpException) {
            Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("CommandFailed!"), lscpException);
        }
    }

    private MidiDataEvent.Type parseMidiDataType(String string) {
        if ("NOTE_ON".equals(string)) {
            return MidiDataEvent.Type.NOTE_ON;
        }
        if ("NOTE_OFF".equals(string)) {
            return MidiDataEvent.Type.NOTE_OFF;
        }
        Client.getLogger().warning("Unknown MIDI data type: " + string);
        return null;
    }

    private synchronized void fireEvent(String string) {
        block79: {
            block103: {
                block102: {
                    block101: {
                        block100: {
                            block99: {
                                block98: {
                                    block97: {
                                        block96: {
                                            block95: {
                                                block94: {
                                                    block93: {
                                                        block92: {
                                                            block91: {
                                                                block90: {
                                                                    block89: {
                                                                        block88: {
                                                                            block87: {
                                                                                block86: {
                                                                                    block85: {
                                                                                        block84: {
                                                                                            block83: {
                                                                                                block82: {
                                                                                                    block81: {
                                                                                                        block80: {
                                                                                                            block78: {
                                                                                                                if (!string.startsWith("CHANNEL_MIDI:")) break block78;
                                                                                                                string = string.substring("CHANNEL_MIDI:".length());
                                                                                                                this.fireChannelMidiDataEvent(string);
                                                                                                                break block79;
                                                                                                            }
                                                                                                            if (!string.startsWith("DEVICE_MIDI:")) break block80;
                                                                                                            string = string.substring("DEVICE_MIDI:".length());
                                                                                                            this.fireDeviceMidiDataEvent(string);
                                                                                                            break block79;
                                                                                                        }
                                                                                                        if (!string.startsWith("DB_INSTRUMENT_DIRECTORY_COUNT:")) break block81;
                                                                                                        string = string.substring("DB_INSTRUMENT_DIRECTORY_COUNT:".length());
                                                                                                        InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
                                                                                                        for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                            instrumentsDbListener.directoryCountChanged(instrumentsDbEvent);
                                                                                                        }
                                                                                                        break block79;
                                                                                                    }
                                                                                                    if (!string.startsWith("DB_INSTRUMENT_DIRECTORY_INFO:")) break block82;
                                                                                                    if ((string = string.substring("DB_INSTRUMENT_DIRECTORY_INFO:".length())).startsWith("NAME ")) {
                                                                                                        try {
                                                                                                            string = string.substring("NAME ".length());
                                                                                                            String[] stringArray = Parser.parseEscapedStringList(string, ' ');
                                                                                                            if (stringArray.length != 2) {
                                                                                                                throw new LscpException();
                                                                                                            }
                                                                                                            stringArray[1] = Parser.toNonEscapedString(stringArray[1]);
                                                                                                            InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent(this, stringArray[0], stringArray[1]);
                                                                                                            for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                                instrumentsDbListener.directoryNameChanged(instrumentsDbEvent);
                                                                                                            }
                                                                                                        }
                                                                                                        catch (LscpException lscpException) {
                                                                                                            Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("CommandFailed!"), lscpException);
                                                                                                        }
                                                                                                    } else {
                                                                                                        InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
                                                                                                        for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                            instrumentsDbListener.directoryInfoChanged(instrumentsDbEvent);
                                                                                                        }
                                                                                                    }
                                                                                                    break block79;
                                                                                                }
                                                                                                if (!string.startsWith("DB_INSTRUMENT_COUNT:")) break block83;
                                                                                                string = string.substring("DB_INSTRUMENT_COUNT:".length());
                                                                                                InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
                                                                                                for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                    instrumentsDbListener.instrumentCountChanged(instrumentsDbEvent);
                                                                                                }
                                                                                                break block79;
                                                                                            }
                                                                                            if (!string.startsWith("DB_INSTRUMENT_INFO:")) break block84;
                                                                                            if ((string = string.substring("DB_INSTRUMENT_INFO:".length())).startsWith("NAME ")) {
                                                                                                try {
                                                                                                    string = string.substring("NAME ".length());
                                                                                                    String[] stringArray = Parser.parseEscapedStringList(string, ' ');
                                                                                                    if (stringArray.length != 2) {
                                                                                                        throw new LscpException();
                                                                                                    }
                                                                                                    stringArray[1] = Parser.toNonEscapedString(stringArray[1]);
                                                                                                    InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent(this, stringArray[0], stringArray[1]);
                                                                                                    for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                        instrumentsDbListener.instrumentNameChanged(instrumentsDbEvent);
                                                                                                    }
                                                                                                }
                                                                                                catch (LscpException lscpException) {
                                                                                                    Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("CommandFailed!"), lscpException);
                                                                                                }
                                                                                            } else {
                                                                                                InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, string);
                                                                                                for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                    instrumentsDbListener.instrumentInfoChanged(instrumentsDbEvent);
                                                                                                }
                                                                                            }
                                                                                            break block79;
                                                                                        }
                                                                                        if (!string.startsWith("DB_INSTRUMENTS_JOB_INFO:")) break block85;
                                                                                        string = string.substring("DB_INSTRUMENTS_JOB_INFO:".length());
                                                                                        try {
                                                                                            int n = Integer.parseInt(string);
                                                                                            InstrumentsDbEvent instrumentsDbEvent = new InstrumentsDbEvent((Object)this, n);
                                                                                            for (InstrumentsDbListener instrumentsDbListener : this.llID) {
                                                                                                instrumentsDbListener.jobStatusChanged(instrumentsDbEvent);
                                                                                            }
                                                                                        }
                                                                                        catch (NumberFormatException numberFormatException) {
                                                                                            string = "Unknown DB_INSTRUMENTS_JOB_INFO format";
                                                                                            Client.getLogger().log(Level.WARNING, string, numberFormatException);
                                                                                        }
                                                                                        break block79;
                                                                                    }
                                                                                    if (!string.startsWith("CHANNEL_COUNT:")) break block86;
                                                                                    try {
                                                                                        int n = Integer.parseInt(string.substring("CHANNEL_COUNT:".length()));
                                                                                        ChannelCountEvent channelCountEvent = new ChannelCountEvent(this, n);
                                                                                        for (ChannelCountListener channelCountListener : this.llCC) {
                                                                                            channelCountListener.channelCountChanged(channelCountEvent);
                                                                                        }
                                                                                    }
                                                                                    catch (NumberFormatException numberFormatException) {
                                                                                        Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
                                                                                    }
                                                                                    break block79;
                                                                                }
                                                                                if (!string.startsWith("VOICE_COUNT:")) break block87;
                                                                                try {
                                                                                    string = string.substring("VOICE_COUNT:".length());
                                                                                    Integer[] integerArray = Parser.parseIntList(string, ' ');
                                                                                    if (integerArray.length != 2) {
                                                                                        Client.getLogger().warning("Unknown VOICE_COUNT format");
                                                                                        return;
                                                                                    }
                                                                                    VoiceCountEvent voiceCountEvent = new VoiceCountEvent(this, integerArray[0], integerArray[1]);
                                                                                    for (VoiceCountListener voiceCountListener : this.llVC) {
                                                                                        voiceCountListener.voiceCountChanged(voiceCountEvent);
                                                                                    }
                                                                                }
                                                                                catch (Exception exception) {
                                                                                    Client.getLogger().log(Level.WARNING, "Unknown VOICE_COUNT format", exception);
                                                                                }
                                                                                break block79;
                                                                            }
                                                                            if (!string.startsWith("STREAM_COUNT:")) break block88;
                                                                            try {
                                                                                string = string.substring("STREAM_COUNT:".length());
                                                                                Integer[] integerArray = Parser.parseIntList(string, ' ');
                                                                                if (integerArray.length != 2) {
                                                                                    Client.getLogger().warning("Unknown STREAM_COUNT format");
                                                                                    return;
                                                                                }
                                                                                StreamCountEvent streamCountEvent = new StreamCountEvent(this, integerArray[0], integerArray[1]);
                                                                                for (StreamCountListener streamCountListener : this.llSC) {
                                                                                    streamCountListener.streamCountChanged(streamCountEvent);
                                                                                }
                                                                            }
                                                                            catch (Exception exception) {
                                                                                Client.getLogger().log(Level.WARNING, "Unknown STREAM_COUNT format", exception);
                                                                            }
                                                                            break block79;
                                                                        }
                                                                        if (!string.startsWith("BUFFER_FILL:")) break block89;
                                                                        try {
                                                                            string = string.substring("BUFFER_FILL:".length());
                                                                            int n = string.indexOf(32);
                                                                            if (n == -1) {
                                                                                Client.getLogger().warning("Unknown BUFFER_FILL format");
                                                                                return;
                                                                            }
                                                                            int n2 = Integer.parseInt(string.substring(0, n));
                                                                            Vector<BufferFill> vector = this.getChannelBufferFillPercentage(string.substring(n + 1));
                                                                            BufferFillEvent bufferFillEvent = new BufferFillEvent(this, n2, vector);
                                                                            for (BufferFillListener bufferFillListener : this.llBF) {
                                                                                bufferFillListener.bufferFillChanged(bufferFillEvent);
                                                                            }
                                                                        }
                                                                        catch (Exception exception) {
                                                                            Client.getLogger().log(Level.WARNING, "Unknown BUFFER_FILL format", exception);
                                                                        }
                                                                        break block79;
                                                                    }
                                                                    if (!string.startsWith("CHANNEL_INFO:")) break block90;
                                                                    try {
                                                                        int n = Integer.parseInt(string.substring("CHANNEL_INFO:".length()));
                                                                        ChannelInfoEvent channelInfoEvent = new ChannelInfoEvent(this, n);
                                                                        for (ChannelInfoListener channelInfoListener : this.llCI) {
                                                                            channelInfoListener.channelInfoChanged(channelInfoEvent);
                                                                        }
                                                                    }
                                                                    catch (NumberFormatException numberFormatException) {
                                                                        Client.getLogger().log(Level.WARNING, "Unknown CHANNEL_INFO format", numberFormatException);
                                                                    }
                                                                    break block79;
                                                                }
                                                                if (!string.startsWith("TOTAL_STREAM_COUNT:")) break block91;
                                                                try {
                                                                    string = string.substring("TOTAL_STREAM_COUNT:".length());
                                                                    int n = Integer.parseInt(string);
                                                                    TotalStreamCountEvent totalStreamCountEvent = new TotalStreamCountEvent(this, n);
                                                                    for (TotalStreamCountListener totalStreamCountListener : this.llTSC) {
                                                                        totalStreamCountListener.totalStreamCountChanged(totalStreamCountEvent);
                                                                    }
                                                                }
                                                                catch (NumberFormatException numberFormatException) {
                                                                    Client.getLogger().log(Level.WARNING, "Unknown TOTAL_STREAM_COUNT format", numberFormatException);
                                                                }
                                                                break block79;
                                                            }
                                                            if (!string.startsWith("TOTAL_VOICE_COUNT:")) break block92;
                                                            try {
                                                                string = string.substring("TOTAL_VOICE_COUNT:".length());
                                                                int n = Integer.parseInt(string);
                                                                TotalVoiceCountEvent totalVoiceCountEvent = new TotalVoiceCountEvent(this, n);
                                                                for (TotalVoiceCountListener totalVoiceCountListener : this.llTVC) {
                                                                    totalVoiceCountListener.totalVoiceCountChanged(totalVoiceCountEvent);
                                                                }
                                                            }
                                                            catch (NumberFormatException numberFormatException) {
                                                                Client.getLogger().log(Level.WARNING, "Unknown TOTAL_VOICE_COUNT format", numberFormatException);
                                                            }
                                                            break block79;
                                                        }
                                                        if (!string.startsWith("AUDIO_OUTPUT_DEVICE_COUNT:")) break block93;
                                                        try {
                                                            string = string.substring("AUDIO_OUTPUT_DEVICE_COUNT:".length());
                                                            int n = Integer.parseInt(string);
                                                            ItemCountEvent itemCountEvent = new ItemCountEvent(this, n);
                                                            for (ItemCountListener itemCountListener : this.llAODC) {
                                                                itemCountListener.itemCountChanged(itemCountEvent);
                                                            }
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            Client.getLogger().log(Level.WARNING, "Unknown AUDIO_OUTPUT_DEVICE_COUNT format", numberFormatException);
                                                        }
                                                        break block79;
                                                    }
                                                    if (!string.startsWith("AUDIO_OUTPUT_DEVICE_INFO:")) break block94;
                                                    try {
                                                        string = string.substring("AUDIO_OUTPUT_DEVICE_INFO:".length());
                                                        int n = Integer.parseInt(string);
                                                        ItemInfoEvent itemInfoEvent = new ItemInfoEvent(this, n);
                                                        for (ItemInfoListener itemInfoListener : this.llAODI) {
                                                            itemInfoListener.itemInfoChanged(itemInfoEvent);
                                                        }
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        Client.getLogger().log(Level.WARNING, "Unknown AUDIO_OUTPUT_DEVICE_INFO format", numberFormatException);
                                                    }
                                                    break block79;
                                                }
                                                if (!string.startsWith("MIDI_INPUT_DEVICE_COUNT:")) break block95;
                                                try {
                                                    string = string.substring("MIDI_INPUT_DEVICE_COUNT:".length());
                                                    int n = Integer.parseInt(string);
                                                    ItemCountEvent itemCountEvent = new ItemCountEvent(this, n);
                                                    for (ItemCountListener itemCountListener : this.llMIDC) {
                                                        itemCountListener.itemCountChanged(itemCountEvent);
                                                    }
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    Client.getLogger().log(Level.WARNING, "Unknown MIDI_INPUT_DEVICE_COUNT format", numberFormatException);
                                                }
                                                break block79;
                                            }
                                            if (!string.startsWith("MIDI_INPUT_DEVICE_INFO:")) break block96;
                                            try {
                                                string = string.substring("MIDI_INPUT_DEVICE_INFO:".length());
                                                int n = Integer.parseInt(string);
                                                ItemInfoEvent itemInfoEvent = new ItemInfoEvent(this, n);
                                                for (ItemInfoListener itemInfoListener : this.llMIDI) {
                                                    itemInfoListener.itemInfoChanged(itemInfoEvent);
                                                }
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                Client.getLogger().log(Level.WARNING, "Unknown MIDI_INPUT_DEVICE_INFO format", numberFormatException);
                                            }
                                            break block79;
                                        }
                                        if (!string.startsWith("MIDI_INSTRUMENT_MAP_COUNT:")) break block97;
                                        try {
                                            string = string.substring("MIDI_INSTRUMENT_MAP_COUNT:".length());
                                            int n = Integer.parseInt(string);
                                            ItemCountEvent itemCountEvent = new ItemCountEvent(this, n);
                                            for (ItemCountListener itemCountListener : this.llMIMC) {
                                                itemCountListener.itemCountChanged(itemCountEvent);
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            Client.getLogger().log(Level.WARNING, "Unknown MIDI_INSTRUMENT_MAP_COUNT format", numberFormatException);
                                        }
                                        break block79;
                                    }
                                    if (!string.startsWith("MIDI_INSTRUMENT_MAP_INFO:")) break block98;
                                    try {
                                        string = string.substring("MIDI_INSTRUMENT_MAP_INFO:".length());
                                        int n = Integer.parseInt(string);
                                        ItemInfoEvent itemInfoEvent = new ItemInfoEvent(this, n);
                                        for (ItemInfoListener itemInfoListener : this.llMIMI) {
                                            itemInfoListener.itemInfoChanged(itemInfoEvent);
                                        }
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        Client.getLogger().log(Level.WARNING, "Unknown MIDI_INSTRUMENT_MAP_INFO format", numberFormatException);
                                    }
                                    break block79;
                                }
                                if (!string.startsWith("MIDI_INSTRUMENT_COUNT:")) break block99;
                                try {
                                    string = string.substring("MIDI_INSTRUMENT_COUNT:".length());
                                    Integer[] integerArray = Parser.parseIntList(string, ' ');
                                    if (integerArray.length != 2) {
                                        Client.getLogger().warning("Unknown MIDI_INSTRUMENT_COUNT format");
                                        return;
                                    }
                                    MidiInstrumentCountEvent midiInstrumentCountEvent = new MidiInstrumentCountEvent(this, integerArray[0], integerArray[1]);
                                    for (MidiInstrumentCountListener midiInstrumentCountListener : this.llMIC) {
                                        midiInstrumentCountListener.instrumentCountChanged(midiInstrumentCountEvent);
                                    }
                                }
                                catch (Exception exception) {
                                    Client.getLogger().log(Level.WARNING, "Unknown MIDI_INSTRUMENT_COUNT format", exception);
                                }
                                break block79;
                            }
                            if (!string.startsWith("MIDI_INSTRUMENT_INFO:")) break block100;
                            try {
                                string = string.substring("MIDI_INSTRUMENT_INFO:".length());
                                Integer[] integerArray = Parser.parseIntList(string, ' ');
                                if (integerArray.length != 3) {
                                    Client.getLogger().warning("Unknown MIDI_INSTRUMENT_INFO format");
                                    return;
                                }
                                MidiInstrumentInfoEvent midiInstrumentInfoEvent = new MidiInstrumentInfoEvent(this, integerArray[0], integerArray[1], integerArray[2]);
                                for (MidiInstrumentInfoListener midiInstrumentInfoListener : this.llMII) {
                                    midiInstrumentInfoListener.instrumentInfoChanged(midiInstrumentInfoEvent);
                                }
                            }
                            catch (Exception exception) {
                                Client.getLogger().log(Level.WARNING, "Unknown MIDI_INSTRUMENT_INFO format", exception);
                            }
                            break block79;
                        }
                        if (!string.startsWith("FX_SEND_COUNT:")) break block101;
                        try {
                            string = string.substring("FX_SEND_COUNT:".length());
                            Integer[] integerArray = Parser.parseIntList(string, ' ');
                            if (integerArray.length != 2) {
                                Client.getLogger().warning("Unknown FX_SEND_COUNT format");
                                return;
                            }
                            FxSendCountEvent fxSendCountEvent = new FxSendCountEvent(this, integerArray[0], integerArray[1]);
                            for (FxSendCountListener fxSendCountListener : this.llFSC) {
                                fxSendCountListener.fxSendCountChanged(fxSendCountEvent);
                            }
                        }
                        catch (Exception exception) {
                            Client.getLogger().log(Level.WARNING, "Unknown FX_SEND_COUNT format", exception);
                        }
                        break block79;
                    }
                    if (!string.startsWith("FX_SEND_INFO:")) break block102;
                    try {
                        string = string.substring("FX_SEND_INFO:".length());
                        Integer[] integerArray = Parser.parseIntList(string, ' ');
                        if (integerArray.length != 2) {
                            Client.getLogger().warning("Unknown FX_SEND_INFO format");
                            return;
                        }
                        FxSendInfoEvent fxSendInfoEvent = new FxSendInfoEvent(this, integerArray[0], integerArray[1]);
                        for (FxSendInfoListener fxSendInfoListener : this.llFSI) {
                            fxSendInfoListener.fxSendInfoChanged(fxSendInfoEvent);
                        }
                    }
                    catch (Exception exception) {
                        Client.getLogger().log(Level.WARNING, "Unknown FX_SEND_INFO format", exception);
                    }
                    break block79;
                }
                if (!string.startsWith("GLOBAL_INFO:")) break block103;
                this.handleGlobalInfoEvent(string.substring("GLOBAL_INFO:".length()));
                break block79;
            }
            if (!string.startsWith("MISCELLANEOUS:")) break block79;
            string = string.substring("MISCELLANEOUS:".length());
            MiscellaneousEvent miscellaneousEvent = new MiscellaneousEvent(this, string);
            for (MiscellaneousListener miscellaneousListener : this.llM) {
                miscellaneousListener.miscEventOccured(miscellaneousEvent);
            }
        }
    }

    private void handleGlobalInfoEvent(String string) {
        try {
            if (string.startsWith("VOLUME ")) {
                float f = Float.parseFloat(string.substring("VOLUME ".length()));
                GlobalInfoEvent globalInfoEvent = new GlobalInfoEvent(this, f);
                for (GlobalInfoListener globalInfoListener : this.llGI) {
                    globalInfoListener.volumeChanged(globalInfoEvent);
                }
            } else if (string.startsWith("VOICES ")) {
                int n = Integer.parseInt(string.substring("VOICES ".length()));
                GlobalInfoEvent globalInfoEvent = new GlobalInfoEvent(this, n, -1);
                for (GlobalInfoListener globalInfoListener : this.llGI) {
                    globalInfoListener.voiceLimitChanged(globalInfoEvent);
                }
            } else if (string.startsWith("STREAMS ")) {
                int n = Integer.parseInt(string.substring("STREAMS ".length()));
                GlobalInfoEvent globalInfoEvent = new GlobalInfoEvent(this, -1, n);
                for (GlobalInfoListener globalInfoListener : this.llGI) {
                    globalInfoListener.streamLimitChanged(globalInfoEvent);
                }
            } else {
                Client.getLogger().info("Unknown GLOBAL_INFO format: " + string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Client.getLogger().log(Level.WARNING, "Unknown GLOBAL_INFO format", numberFormatException);
        }
    }

    private void subscribe(String string) {
        if (!this.getPrintOnlyMode()) {
            if (!this.isConnected()) {
                return;
            }
            if (!this.eventThread.isAlive()) {
                this.eventThread.start();
            }
        }
        try {
            this.out.writeLine("SUBSCRIBE " + string);
            if (!this.getPrintOnlyMode()) {
                this.getEmptyResultSet();
            }
        }
        catch (Exception exception) {
            Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("Client.subscriptionFailed!", string), exception);
        }
    }

    private void unsubscribe(String string) {
        if (!this.getPrintOnlyMode() && !this.isConnected()) {
            return;
        }
        try {
            this.out.writeLine("UNSUBSCRIBE " + string);
            if (!this.getPrintOnlyMode()) {
                this.getEmptyResultSet();
            }
        }
        catch (Exception exception) {
            Client.getLogger().log(Level.WARNING, LscpI18n.getLogMsg("Client.unsubscriptionFailed!", string), exception);
        }
    }

    public synchronized void addAudioDeviceCountListener(ItemCountListener itemCountListener) {
        if (this.llAODC.isEmpty()) {
            this.subscribe("AUDIO_OUTPUT_DEVICE_COUNT");
        }
        this.llAODC.add(itemCountListener);
    }

    public synchronized void removeAudioDeviceCountListener(ItemCountListener itemCountListener) {
        boolean bl = this.llAODC.remove(itemCountListener);
        if (bl && this.llAODC.isEmpty()) {
            this.unsubscribe("AUDIO_OUTPUT_DEVICE_COUNT");
        }
    }

    public synchronized void addAudioDeviceInfoListener(ItemInfoListener itemInfoListener) {
        if (this.llAODI.isEmpty()) {
            this.subscribe("AUDIO_OUTPUT_DEVICE_INFO");
        }
        this.llAODI.add(itemInfoListener);
    }

    public synchronized void removeAudioDeviceInfoListener(ItemInfoListener itemInfoListener) {
        boolean bl = this.llAODI.remove(itemInfoListener);
        if (bl && this.llAODI.isEmpty()) {
            this.unsubscribe("AUDIO_OUTPUT_DEVICE_INFO");
        }
    }

    public synchronized void addBufferFillListener(BufferFillListener bufferFillListener) {
        if (this.llBF.isEmpty()) {
            this.subscribe("BUFFER_FILL");
        }
        this.llBF.add(bufferFillListener);
    }

    public synchronized void removeBufferFillListener(BufferFillListener bufferFillListener) {
        boolean bl = this.llBF.remove(bufferFillListener);
        if (bl && this.llBF.isEmpty()) {
            this.unsubscribe("BUFFER_FILL");
        }
    }

    public synchronized void addChannelCountListener(ChannelCountListener channelCountListener) {
        if (this.llCC.isEmpty()) {
            this.subscribe("CHANNEL_COUNT");
        }
        this.llCC.add(channelCountListener);
    }

    public synchronized void removeChannelCountListener(ChannelCountListener channelCountListener) {
        boolean bl = this.llCC.remove(channelCountListener);
        if (bl && this.llCC.isEmpty()) {
            this.unsubscribe("CHANNEL_COUNT");
        }
    }

    public synchronized void addChannelInfoListener(ChannelInfoListener channelInfoListener) {
        if (this.llCI.isEmpty()) {
            this.subscribe("CHANNEL_INFO");
        }
        this.llCI.add(channelInfoListener);
    }

    public synchronized void removeChannelInfoListener(ChannelInfoListener channelInfoListener) {
        boolean bl = this.llCI.remove(channelInfoListener);
        if (bl && this.llCI.isEmpty()) {
            this.unsubscribe("CHANNEL_INFO");
        }
    }

    public synchronized void addFxSendCountListener(FxSendCountListener fxSendCountListener) {
        if (this.llFSC.isEmpty()) {
            this.subscribe("FX_SEND_COUNT");
        }
        this.llFSC.add(fxSendCountListener);
    }

    public synchronized void removeFxSendCountListener(FxSendCountListener fxSendCountListener) {
        boolean bl = this.llFSC.remove(fxSendCountListener);
        if (bl && this.llFSC.isEmpty()) {
            this.unsubscribe("FX_SEND_COUNT");
        }
    }

    public synchronized void addFxSendInfoListener(FxSendInfoListener fxSendInfoListener) {
        if (this.llFSI.isEmpty()) {
            this.subscribe("FX_SEND_INFO");
        }
        this.llFSI.add(fxSendInfoListener);
    }

    public synchronized void removeFxSendInfoListener(FxSendInfoListener fxSendInfoListener) {
        boolean bl = this.llFSI.remove(fxSendInfoListener);
        if (bl && this.llFSI.isEmpty()) {
            this.unsubscribe("FX_SEND_INFO");
        }
    }

    public synchronized void addMidiDeviceCountListener(ItemCountListener itemCountListener) {
        if (this.llMIDC.isEmpty()) {
            this.subscribe("MIDI_INPUT_DEVICE_COUNT");
        }
        this.llMIDC.add(itemCountListener);
    }

    public synchronized void removeMidiDeviceCountListener(ItemCountListener itemCountListener) {
        boolean bl = this.llMIDC.remove(itemCountListener);
        if (bl && this.llMIDC.isEmpty()) {
            this.unsubscribe("MIDI_INPUT_DEVICE_COUNT");
        }
    }

    public synchronized void addMidiDeviceInfoListener(ItemInfoListener itemInfoListener) {
        if (this.llMIDI.isEmpty()) {
            this.subscribe("MIDI_INPUT_DEVICE_INFO");
        }
        this.llMIDI.add(itemInfoListener);
    }

    public synchronized void removeMidiDeviceInfoListener(ItemInfoListener itemInfoListener) {
        boolean bl = this.llMIDI.remove(itemInfoListener);
        if (bl && this.llMIDI.isEmpty()) {
            this.unsubscribe("MIDI_INPUT_DEVICE_INFO");
        }
    }

    public synchronized void addMiscellaneousListener(MiscellaneousListener miscellaneousListener) {
        if (this.llM.isEmpty()) {
            this.subscribe("MISCELLANEOUS");
        }
        this.llM.add(miscellaneousListener);
    }

    public synchronized void removeMiscellaneousListener(MiscellaneousListener miscellaneousListener) {
        boolean bl = this.llM.remove(miscellaneousListener);
        if (bl && this.llM.isEmpty()) {
            this.unsubscribe("MISCELLANEOUS");
        }
    }

    public synchronized void addStreamCountListener(StreamCountListener streamCountListener) {
        if (this.llSC.isEmpty()) {
            this.subscribe("STREAM_COUNT");
        }
        this.llSC.add(streamCountListener);
    }

    public synchronized void removeStreamCountListener(StreamCountListener streamCountListener) {
        boolean bl = this.llSC.remove(streamCountListener);
        if (bl && this.llSC.isEmpty()) {
            this.unsubscribe("STREAM_COUNT");
        }
    }

    public synchronized void addVoiceCountListener(VoiceCountListener voiceCountListener) {
        if (this.llVC.isEmpty()) {
            this.subscribe("VOICE_COUNT");
        }
        this.llVC.add(voiceCountListener);
    }

    public synchronized void removeVoiceCountListener(VoiceCountListener voiceCountListener) {
        boolean bl = this.llVC.remove(voiceCountListener);
        if (bl && this.llVC.isEmpty()) {
            this.unsubscribe("VOICE_COUNT");
        }
    }

    public synchronized void addTotalStreamCountListener(TotalStreamCountListener totalStreamCountListener) {
        if (this.llTSC.isEmpty()) {
            this.subscribe("TOTAL_STREAM_COUNT");
        }
        this.llTSC.add(totalStreamCountListener);
    }

    public synchronized void removeTotalStreamCountListener(TotalStreamCountListener totalStreamCountListener) {
        boolean bl = this.llTSC.remove(totalStreamCountListener);
        if (bl && this.llTSC.isEmpty()) {
            this.unsubscribe("TOTAL_STREAM_COUNT");
        }
    }

    public synchronized void addTotalVoiceCountListener(TotalVoiceCountListener totalVoiceCountListener) {
        if (this.llTVC.isEmpty()) {
            this.subscribe("TOTAL_VOICE_COUNT");
        }
        this.llTVC.add(totalVoiceCountListener);
    }

    public synchronized void removeTotalVoiceCountListener(TotalVoiceCountListener totalVoiceCountListener) {
        boolean bl = this.llTVC.remove(totalVoiceCountListener);
        if (bl && this.llTVC.isEmpty()) {
            this.unsubscribe("TOTAL_VOICE_COUNT");
        }
    }

    public synchronized void addMidiInstrumentMapCountListener(ItemCountListener itemCountListener) {
        if (this.llMIMC.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_MAP_COUNT");
        }
        this.llMIMC.add(itemCountListener);
    }

    public synchronized void removeMidiInstrumentMapCountListener(ItemCountListener itemCountListener) {
        boolean bl = this.llMIMC.remove(itemCountListener);
        if (bl && this.llMIMC.isEmpty()) {
            this.unsubscribe("MIDI_INSTRUMENT_MAP_COUNT");
        }
    }

    public synchronized void addMidiInstrumentMapInfoListener(ItemInfoListener itemInfoListener) {
        if (this.llMIMI.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_MAP_INFO");
        }
        this.llMIMI.add(itemInfoListener);
    }

    public synchronized void removeMidiInstrumentMapInfoListener(ItemInfoListener itemInfoListener) {
        boolean bl = this.llMIMI.remove(itemInfoListener);
        if (bl && this.llMIMI.isEmpty()) {
            this.unsubscribe("MIDI_INSTRUMENT_MAP_INFO");
        }
    }

    public synchronized void addMidiInstrumentCountListener(MidiInstrumentCountListener midiInstrumentCountListener) {
        if (this.llMIC.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_COUNT");
        }
        this.llMIC.add(midiInstrumentCountListener);
    }

    public synchronized void removeMidiInstrumentCountListener(MidiInstrumentCountListener midiInstrumentCountListener) {
        boolean bl = this.llMIC.remove(midiInstrumentCountListener);
        if (bl && this.llMIC.isEmpty()) {
            this.unsubscribe("MIDI_INSTRUMENT_COUNT");
        }
    }

    public synchronized void addMidiInstrumentInfoListener(MidiInstrumentInfoListener midiInstrumentInfoListener) {
        if (this.llMII.isEmpty()) {
            this.subscribe("MIDI_INSTRUMENT_INFO");
        }
        this.llMII.add(midiInstrumentInfoListener);
    }

    public synchronized void removeMidiInstrumentInfoListener(MidiInstrumentInfoListener midiInstrumentInfoListener) {
        boolean bl = this.llMII.remove(midiInstrumentInfoListener);
        if (bl && this.llMII.isEmpty()) {
            this.unsubscribe("MIDI_INSTRUMENT_INFO");
        }
    }

    public synchronized void addDeviceMidiDataListener(DeviceMidiDataListener deviceMidiDataListener) {
        if (this.llDMD.isEmpty()) {
            this.subscribe("DEVICE_MIDI");
        }
        this.llDMD.add(deviceMidiDataListener);
    }

    public synchronized void removeDeviceMidiDataListener(DeviceMidiDataListener deviceMidiDataListener) {
        boolean bl = this.llDMD.remove(deviceMidiDataListener);
        if (bl && this.llDMD.isEmpty()) {
            this.unsubscribe("DEVICE_MIDI");
        }
    }

    public synchronized void addChannelMidiDataListener(ChannelMidiDataListener channelMidiDataListener) {
        if (this.llCMD.isEmpty()) {
            this.subscribe("CHANNEL_MIDI");
        }
        this.llCMD.add(channelMidiDataListener);
    }

    public synchronized void removeChannelMidiDataListener(ChannelMidiDataListener channelMidiDataListener) {
        boolean bl = this.llCMD.remove(channelMidiDataListener);
        if (bl && this.llCMD.isEmpty()) {
            this.unsubscribe("CHANNEL_MIDI");
        }
    }

    public synchronized void addInstrumentsDbListener(InstrumentsDbListener instrumentsDbListener) {
        if (this.llID.isEmpty()) {
            this.subscribe("DB_INSTRUMENT_DIRECTORY_COUNT");
            this.subscribe("DB_INSTRUMENT_DIRECTORY_INFO");
            this.subscribe("DB_INSTRUMENT_COUNT");
            this.subscribe("DB_INSTRUMENT_INFO");
            this.subscribe("DB_INSTRUMENTS_JOB_INFO");
        }
        this.llID.add(instrumentsDbListener);
    }

    public synchronized void removeInstrumentsDbListener(InstrumentsDbListener instrumentsDbListener) {
        boolean bl = this.llID.remove(instrumentsDbListener);
        if (bl && this.llID.isEmpty()) {
            this.unsubscribe("DB_INSTRUMENT_DIRECTORY_COUNT");
            this.unsubscribe("DB_INSTRUMENT_DIRECTORY_INFO");
            this.unsubscribe("DB_INSTRUMENT_COUNT");
            this.unsubscribe("DB_INSTRUMENT_INFO");
            this.unsubscribe("DB_INSTRUMENTS_JOB_INFO");
        }
    }

    public synchronized void addGlobalInfoListener(GlobalInfoListener globalInfoListener) {
        if (this.llGI.isEmpty()) {
            this.subscribe("GLOBAL_INFO");
        }
        this.llGI.add(globalInfoListener);
    }

    public synchronized void removeGlobalInfoListener(GlobalInfoListener globalInfoListener) {
        boolean bl = this.llGI.remove(globalInfoListener);
        if (bl && this.llGI.isEmpty()) {
            this.unsubscribe("GLOBAL_INFO");
        }
    }

    public synchronized int getAudioOutputDriverCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET AVAILABLE_AUDIO_OUTPUT_DRIVERS");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized AudioOutputDriver[] getAudioOutputDrivers() throws IOException, LscpException, LSException {
        String[] stringArray = this.getAudioOutputDriverNames();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        AudioOutputDriver[] audioOutputDriverArray = new AudioOutputDriver[stringArray.length];
        for (int i = 0; i < audioOutputDriverArray.length; ++i) {
            audioOutputDriverArray[i] = this.getAudioOutputDriverInfo(stringArray[i], new Parameter[0]);
        }
        return audioOutputDriverArray;
    }

    private synchronized String[] getAudioOutputDriverNames() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST AVAILABLE_AUDIO_OUTPUT_DRIVERS");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseList(this.getSingleLineResultSet().getResult());
    }

    public synchronized AudioOutputDriver getAudioOutputDriverInfo(String string, Parameter ... parameterArray) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET AUDIO_OUTPUT_DRIVER INFO " + string);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        AudioOutputDriver audioOutputDriver = new AudioOutputDriver(resultSet.getMultiLineResult());
        audioOutputDriver.setName(string);
        for (String string2 : audioOutputDriver.getParameterNames()) {
            audioOutputDriver.addParameter(this.getAudioOutputDriverParameterInfo(string, string2, parameterArray));
        }
        return audioOutputDriver;
    }

    public synchronized Parameter getAudioOutputDriverParameterInfo(String string, String string2, Parameter ... parameterArray) throws IOException, LscpException, LSException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ').append(string2);
        for (Parameter parameter : parameterArray) {
            if (parameter == null || parameter.getName() == null || parameter.getValue() == null) continue;
            stringBuffer.append(' ').append(parameter.getName()).append('=').append(parameter.getStringValue());
        }
        this.out.writeLine("GET AUDIO_OUTPUT_DRIVER_PARAMETER INFO " + stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        ParameterType parameterType = Parser.parseType(stringArray);
        boolean bl = Parser.parseMultiplicity(stringArray);
        switch (parameterType) {
            case BOOL: {
                AbstractParameter abstractParameter = !bl ? new BoolParameter(stringArray) : new BoolListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
            case INT: {
                AbstractParameter abstractParameter = !bl ? new IntParameter(stringArray) : new IntListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
            case FLOAT: {
                AbstractParameter abstractParameter = !bl ? new FloatParameter(stringArray) : new FloatListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
            case STRING: {
                AbstractParameter abstractParameter = !bl ? new StringParameter(stringArray) : new StringListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
        }
        throw new LscpException(LscpI18n.getLogMsg("Client.unknownPrmType!"));
    }

    public synchronized int createAudioOutputDevice(String string, Parameter ... parameterArray) throws IOException, LSException, LscpException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer(string);
        for (Parameter parameter : parameterArray) {
            if (parameter == null || parameter.getName() == null || parameter.getValue() == null) continue;
            stringBuffer.append(' ').append(parameter.getName()).append('=').append(parameter.getStringValue());
        }
        this.out.writeLine("CREATE AUDIO_OUTPUT_DEVICE " + stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void destroyAudioOutputDevice(int n) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("DESTROY AUDIO_OUTPUT_DEVICE " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public void enableAudioOutputDevice(int n, boolean bl) throws IOException, LSException, LscpException {
        this.setAudioOutputDeviceParameter(n, new BoolParameter("ACTIVE", bl));
    }

    public synchronized int getAudioOutputDeviceCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET AUDIO_OUTPUT_DEVICES");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized AudioOutputDevice[] getAudioOutputDevices() throws IOException, LscpException, LSException {
        Integer[] integerArray = this.getAudioOutputDeviceIDs();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        AudioOutputDevice[] audioOutputDeviceArray = new AudioOutputDevice[integerArray.length];
        for (int i = 0; i < audioOutputDeviceArray.length; ++i) {
            audioOutputDeviceArray[i] = this.getAudioOutputDeviceInfo(integerArray[i]);
        }
        return audioOutputDeviceArray;
    }

    public synchronized Integer[] getAudioOutputDeviceIDs() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST AUDIO_OUTPUT_DEVICES");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseIntList(this.getSingleLineResultSet().getResult());
    }

    public synchronized AudioOutputDevice getAudioOutputDeviceInfo(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET AUDIO_OUTPUT_DEVICE INFO " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        AudioOutputDevice audioOutputDevice = new AudioOutputDevice();
        audioOutputDevice.setDeviceId(n);
        String string = Parser.getCategoryInfo(stringArray, "DRIVER");
        audioOutputDevice.setDriverName(string);
        for (String string2 : stringArray) {
            AudioOutputChannel[] audioOutputChannelArray;
            int n2;
            if (string2.startsWith("CHANNELS: ")) {
                Parameter parameter = this.getAudioOutputDriverParameterInfo(string, "CHANNELS", new Parameter[0]);
                string2 = string2.substring("CHANNELS: ".length(), string2.length());
                parameter.parseValue(string2);
                audioOutputDevice.setChannelsParameter(parameter);
                n2 = (Integer)parameter.getValue() > 0 ? (Integer)parameter.getValue() : 0;
                audioOutputChannelArray = new AudioOutputChannel[n2];
                for (int i = 0; i < n2; ++i) {
                    audioOutputChannelArray[i] = this.getAudioOutputChannelInfo(n, i);
                }
                audioOutputDevice.setAudioChannels(audioOutputChannelArray);
                continue;
            }
            if (string2.startsWith("SAMPLERATE: ")) {
                Parameter parameter = this.getAudioOutputDriverParameterInfo(string, "SAMPLERATE", new Parameter[0]);
                string2 = string2.substring("SAMPLERATE: ".length(), string2.length());
                parameter.parseValue(string2);
                audioOutputDevice.setSampleRateParameter(parameter);
                continue;
            }
            if (string2.startsWith("ACTIVE: ")) {
                string2 = string2.substring("ACTIVE: ".length(), string2.length());
                audioOutputDevice.setActive(Boolean.parseBoolean(string2));
                continue;
            }
            if (string2.startsWith("DRIVER: ")) continue;
            n2 = string2.indexOf(": ");
            if (n2 == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            audioOutputChannelArray = this.getAudioOutputDriverParameterInfo(string, string2.substring(0, n2), new Parameter[0]);
            string2 = string2.substring(n2 + 2);
            audioOutputChannelArray.parseValue(string2);
            audioOutputDevice.addParameter((Parameter)audioOutputChannelArray);
        }
        return audioOutputDevice;
    }

    public synchronized void setAudioOutputDeviceParameter(int n, Parameter parameter) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = parameter.getName() + '=' + parameter.getStringValue();
        this.out.writeLine("SET AUDIO_OUTPUT_DEVICE_PARAMETER " + n + ' ' + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setAudioOutputChannelCount(int n, int n2) throws IOException, LscpException, LSException {
        this.setAudioOutputDeviceParameter(n, new IntParameter("CHANNELS", n2));
    }

    public synchronized AudioOutputChannel getAudioOutputChannelInfo(int n, int n2) throws IOException, LscpException, LSException {
        String[] stringArray;
        this.verifyConnection();
        this.out.writeLine("GET AUDIO_OUTPUT_CHANNEL INFO " + n + ' ' + n2);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        AudioOutputChannel audioOutputChannel = new AudioOutputChannel();
        for (String string : stringArray = resultSet.getMultiLineResult()) {
            if (string.startsWith("NAME: ")) {
                string = string.substring("NAME: ".length());
                Parameter parameter = this.getAudioOutputChannelParameterInfo(n, n2, "NAME");
                parameter.setValue(Parser.removeQuotation(string));
                audioOutputChannel.setNameParameter(parameter);
                continue;
            }
            if (string.startsWith("IS_MIX_CHANNEL: ")) {
                string = string.substring("IS_MIX_CHANNEL: ".length());
                Parameter parameter = this.getAudioOutputChannelParameterInfo(n, n2, "IS_MIX_CHANNEL");
                parameter.setValue(Boolean.parseBoolean(string));
                audioOutputChannel.setMixChannelParameter(parameter);
                continue;
            }
            if (string.startsWith("MIX_CHANNEL_DESTINATION: ")) {
                string = string.substring("MIX_CHANNEL_DESTINATION: ".length());
                Parameter parameter = this.getAudioOutputChannelParameterInfo(n, n2, "MIX_CHANNEL_DESTINATION");
                parameter.setValue(Parser.parseInt(string));
                audioOutputChannel.setMixChannelDestParameter(parameter);
                continue;
            }
            int n3 = string.indexOf(": ");
            if (n3 == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            Parameter parameter = this.getAudioOutputChannelParameterInfo(n, n2, string.substring(0, n3));
            string = string.substring(n3 + 2);
            parameter.parseValue(string);
            audioOutputChannel.addParameter(parameter);
        }
        return audioOutputChannel;
    }

    public synchronized Parameter getAudioOutputChannelParameterInfo(int n, int n2, String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string2 = n + " " + n2 + " " + string;
        this.out.writeLine("GET AUDIO_OUTPUT_CHANNEL_PARAMETER INFO " + string2);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        ParameterType parameterType = Parser.parseType(stringArray);
        boolean bl = Parser.parseMultiplicity(stringArray);
        switch (parameterType) {
            case BOOL: {
                AbstractParameter abstractParameter = !bl ? new BoolParameter(stringArray) : new BoolListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
            case INT: {
                AbstractParameter abstractParameter = !bl ? new IntParameter(stringArray) : new IntListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
            case FLOAT: {
                AbstractParameter abstractParameter = !bl ? new FloatParameter(stringArray) : new FloatListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
            case STRING: {
                AbstractParameter abstractParameter = !bl ? new StringParameter(stringArray) : new StringListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
        }
        throw new LscpException(LscpI18n.getLogMsg("Client.unknownPrmType!"));
    }

    public synchronized void setAudioOutputChannelParameter(int n, int n2, Parameter parameter) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = n + " " + n2 + " " + parameter.getName() + '=' + parameter.getStringValue();
        this.out.writeLine("SET AUDIO_OUTPUT_CHANNEL_PARAMETER " + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getMidiInputDriverCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET AVAILABLE_MIDI_INPUT_DRIVERS");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized MidiInputDriver[] getMidiInputDrivers() throws IOException, LscpException, LSException {
        String[] stringArray = this.getMidiInputDriverNames();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        MidiInputDriver[] midiInputDriverArray = new MidiInputDriver[stringArray.length];
        for (int i = 0; i < midiInputDriverArray.length; ++i) {
            midiInputDriverArray[i] = this.getMidiInputDriverInfo(stringArray[i], new Parameter[0]);
        }
        return midiInputDriverArray;
    }

    private synchronized String[] getMidiInputDriverNames() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST AVAILABLE_MIDI_INPUT_DRIVERS");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseList(this.getSingleLineResultSet().getResult());
    }

    public synchronized MidiInputDriver getMidiInputDriverInfo(String string, Parameter ... parameterArray) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INPUT_DRIVER INFO " + string);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        MidiInputDriver midiInputDriver = new MidiInputDriver(resultSet.getMultiLineResult());
        midiInputDriver.setName(string);
        for (String string2 : midiInputDriver.getParameterNames()) {
            midiInputDriver.addParameter(this.getMidiInputDriverParameterInfo(string, string2, parameterArray));
        }
        return midiInputDriver;
    }

    public synchronized Parameter getMidiInputDriverParameterInfo(String string, String string2, Parameter ... parameterArray) throws IOException, LscpException, LSException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ').append(string2);
        for (Parameter parameter : parameterArray) {
            if (parameter == null || parameter.getName() == null || parameter.getValue() == null) continue;
            stringBuffer.append(' ').append(parameter.getName()).append('=').append(parameter.getStringValue());
        }
        this.out.writeLine("GET MIDI_INPUT_DRIVER_PARAMETER INFO " + stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        ParameterType parameterType = Parser.parseType(stringArray);
        boolean bl = Parser.parseMultiplicity(stringArray);
        switch (parameterType) {
            case BOOL: {
                AbstractParameter abstractParameter = !bl ? new BoolParameter(stringArray) : new BoolListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
            case INT: {
                AbstractParameter abstractParameter = !bl ? new IntParameter(stringArray) : new IntListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
            case FLOAT: {
                AbstractParameter abstractParameter = !bl ? new FloatParameter(stringArray) : new FloatListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
            case STRING: {
                AbstractParameter abstractParameter = !bl ? new StringParameter(stringArray) : new StringListParameter(stringArray);
                abstractParameter.setName(string2);
                abstractParameter.setValue(abstractParameter.getDefault());
                return abstractParameter;
            }
        }
        throw new LscpException(LscpI18n.getLogMsg("Client.unknownPrmType!"));
    }

    public synchronized int createMidiInputDevice(String string, Parameter ... parameterArray) throws IOException, LSException, LscpException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer(string);
        for (Parameter parameter : parameterArray) {
            if (parameter == null || parameter.getName() == null || parameter.getValue() == null) continue;
            stringBuffer.append(' ').append(parameter.getName()).append('=').append(parameter.getStringValue());
        }
        this.out.writeLine("CREATE MIDI_INPUT_DEVICE " + stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void destroyMidiInputDevice(int n) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("DESTROY MIDI_INPUT_DEVICE " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public void enableMidiInputDevice(int n, boolean bl) throws IOException, LSException, LscpException {
        this.setMidiInputDeviceParameter(n, new BoolParameter("ACTIVE", bl));
    }

    public synchronized int getMidiInputDeviceCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INPUT_DEVICES");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized MidiInputDevice[] getMidiInputDevices() throws IOException, LscpException, LSException {
        Integer[] integerArray = this.getMidiInputDeviceIDs();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        MidiInputDevice[] midiInputDeviceArray = new MidiInputDevice[integerArray.length];
        for (int i = 0; i < midiInputDeviceArray.length; ++i) {
            midiInputDeviceArray[i] = this.getMidiInputDeviceInfo(integerArray[i]);
        }
        return midiInputDeviceArray;
    }

    public synchronized Integer[] getMidiInputDeviceIDs() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST MIDI_INPUT_DEVICES");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseIntList(this.getSingleLineResultSet().getResult());
    }

    public synchronized MidiInputDevice getMidiInputDeviceInfo(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INPUT_DEVICE INFO " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        MidiInputDevice midiInputDevice = new MidiInputDevice();
        midiInputDevice.setDeviceId(n);
        String string = Parser.getCategoryInfo(stringArray, "DRIVER");
        midiInputDevice.setDriverName(string);
        for (String string2 : stringArray) {
            if (string2.startsWith("DRIVER: ")) continue;
            if (string2.startsWith("ACTIVE: ")) {
                string2 = string2.substring("ACTIVE: ".length());
                midiInputDevice.setActive(Boolean.parseBoolean(string2));
                continue;
            }
            if (string2.startsWith("PORTS: ")) {
                string2 = string2.substring("PORTS: ".length());
                Parameter parameter = this.getMidiInputDriverParameterInfo(string, "PORTS", new Parameter[0]);
                parameter.parseValue(string2);
                midiInputDevice.setPortsParameter(parameter);
                int n2 = (Integer)parameter.getValue();
                MidiPort[] midiPortArray = new MidiPort[n2 > 0 ? n2 : 0];
                for (int i = 0; i < midiPortArray.length; ++i) {
                    midiPortArray[i] = this.getMidiInputPortInfo(n, i);
                }
                midiInputDevice.setMidiPorts(midiPortArray);
                continue;
            }
            int n3 = string2.indexOf(": ");
            if (n3 == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            Parameter parameter = this.getMidiInputDriverParameterInfo(string, string2.substring(0, n3), new Parameter[0]);
            string2 = string2.substring(n3 + 2);
            parameter.parseValue(string2);
            midiInputDevice.addParameter(parameter);
        }
        return midiInputDevice;
    }

    public synchronized void setMidiInputDeviceParameter(int n, Parameter parameter) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = parameter.getName() + '=' + parameter.getStringValue();
        this.out.writeLine("SET MIDI_INPUT_DEVICE_PARAMETER " + n + ' ' + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setMidiInputPortCount(int n, int n2) throws IOException, LscpException, LSException {
        this.setMidiInputDeviceParameter(n, new IntParameter("PORTS", n2));
    }

    public synchronized MidiPort getMidiInputPortInfo(int n, int n2) throws IOException, LscpException, LSException {
        String[] stringArray;
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INPUT_PORT INFO " + n + " " + n2);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        MidiPort midiPort = new MidiPort();
        for (String string : stringArray = resultSet.getMultiLineResult()) {
            if (string.startsWith("NAME: ")) {
                string = string.substring("NAME: ".length());
                Parameter parameter = this.getMidiInputPortParameterInfo(n, n2, "NAME");
                parameter.setValue(Parser.removeQuotation(string));
                midiPort.setNameParameter(parameter);
                continue;
            }
            int n3 = string.indexOf(": ");
            if (n3 == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            Parameter parameter = this.getMidiInputPortParameterInfo(n, n2, string.substring(0, n3));
            string = string.substring(n3 + 2);
            parameter.parseValue(string);
            midiPort.addParameter(parameter);
        }
        return midiPort;
    }

    public synchronized Parameter getMidiInputPortParameterInfo(int n, int n2, String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string2 = n + " " + n2 + " " + string;
        this.out.writeLine("GET MIDI_INPUT_PORT_PARAMETER INFO " + string2);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        ParameterType parameterType = Parser.parseType(stringArray);
        boolean bl = Parser.parseMultiplicity(stringArray);
        switch (parameterType) {
            case BOOL: {
                AbstractParameter abstractParameter = !bl ? new BoolParameter(stringArray) : new BoolListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
            case INT: {
                AbstractParameter abstractParameter = !bl ? new IntParameter(stringArray) : new IntListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
            case FLOAT: {
                AbstractParameter abstractParameter = !bl ? new FloatParameter(stringArray) : new FloatListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
            case STRING: {
                AbstractParameter abstractParameter = !bl ? new StringParameter(stringArray) : new StringListParameter(stringArray);
                abstractParameter.setName(string);
                return abstractParameter;
            }
        }
        throw new LscpException(LscpI18n.getLogMsg("Client.unknownPrmType!"));
    }

    public synchronized void setMidiInputPortParameter(int n, int n2, Parameter parameter) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = n + " " + n2 + " " + parameter.getName() + '=' + parameter.getStringValue();
        this.out.writeLine("SET MIDI_INPUT_PORT_PARAMETER " + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int addMidiInstrumentMap(String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("ADD MIDI_INSTRUMENT_MAP '" + this.toEscapedText(string) + "'");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void removeMidiInstrumentMap(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("REMOVE MIDI_INSTRUMENT_MAP " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void removeAllMidiInstrumentMaps() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("REMOVE MIDI_INSTRUMENT_MAP ALL");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getMidiInstrumentMapCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INSTRUMENT_MAPS");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized Integer[] getMidiInstrumentMapIDs() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST MIDI_INSTRUMENT_MAPS");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseIntList(this.getSingleLineResultSet().getResult());
    }

    public synchronized MidiInstrumentMapInfo getMidiInstrumentMapInfo(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INSTRUMENT_MAP INFO " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        String[] stringArray = resultSet.getMultiLineResult();
        String string = "";
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2.startsWith("NAME: ")) {
                string = Parser.toNonEscapedString(string2.substring("NAME: ".length()));
                continue;
            }
            if (string2.startsWith("DEFAULT: ")) {
                bl = Boolean.parseBoolean(string2.substring("DEFAULT: ".length()));
                continue;
            }
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string2));
        }
        return new MidiInstrumentMapInfo(n, string, bl);
    }

    public synchronized MidiInstrumentMapInfo[] getMidiInstrumentMaps() throws IOException, LscpException, LSException {
        Integer[] integerArray = this.getMidiInstrumentMapIDs();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        MidiInstrumentMapInfo[] midiInstrumentMapInfoArray = new MidiInstrumentMapInfo[integerArray.length];
        for (int i = 0; i < midiInstrumentMapInfoArray.length; ++i) {
            midiInstrumentMapInfoArray[i] = this.getMidiInstrumentMapInfo(integerArray[i]);
        }
        return midiInstrumentMapInfoArray;
    }

    public synchronized void setMidiInstrumentMapName(int n, String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        string = this.toEscapedText(string);
        this.out.writeLine("SET MIDI_INSTRUMENT_MAP NAME " + n + " '" + string + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void mapMidiInstrument(int n, MidiInstrumentEntry midiInstrumentEntry, MidiInstrumentInfo midiInstrumentInfo) throws IOException, LSException, LscpException {
        this.mapMidiInstrument(n, midiInstrumentEntry, midiInstrumentInfo, false);
    }

    public synchronized void mapMidiInstrument(int n, MidiInstrumentEntry midiInstrumentEntry, MidiInstrumentInfo midiInstrumentInfo, boolean bl) throws IOException, LSException, LscpException {
        Object object;
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer("MAP MIDI_INSTRUMENT ");
        if (bl) {
            stringBuffer.append("NON_MODAL ");
        }
        stringBuffer.append(n).append(' ');
        stringBuffer.append(midiInstrumentEntry.getMidiBank()).append(' ');
        stringBuffer.append(midiInstrumentEntry.getMidiProgram()).append(' ');
        stringBuffer.append(midiInstrumentInfo.getEngine()).append(" '");
        stringBuffer.append(this.conv(midiInstrumentInfo.getFilePath())).append("' ");
        stringBuffer.append(midiInstrumentInfo.getInstrumentIndex()).append(' ');
        stringBuffer.append(midiInstrumentInfo.getVolume());
        if (!midiInstrumentInfo.getLoadMode().name().equals("DEFAULT")) {
            stringBuffer.append(' ').append(midiInstrumentInfo.getLoadMode().name());
        }
        if (midiInstrumentInfo.getName() != null) {
            object = this.toEscapedText(midiInstrumentInfo.getName());
            stringBuffer.append(" '").append((String)object).append("'");
        }
        this.out.writeLine(stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return;
        }
        object = this.getEmptyResultSet();
    }

    public synchronized void unmapMidiInstrument(int n, MidiInstrumentEntry midiInstrumentEntry) throws IOException, LSException, LscpException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer("UNMAP MIDI_INSTRUMENT ");
        stringBuffer.append(n).append(' ');
        stringBuffer.append(midiInstrumentEntry.getMidiBank()).append(' ');
        stringBuffer.append(midiInstrumentEntry.getMidiProgram());
        this.out.writeLine(stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getMidiInstrumentCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INSTRUMENTS ALL");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized int getMidiInstrumentCount(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET MIDI_INSTRUMENTS " + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized MidiInstrumentInfo[] getMidiInstruments() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST MIDI_INSTRUMENTS ALL");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseArray(this.getSingleLineResultSet().getResult());
        return this.getMidiInstruments(stringArray);
    }

    public synchronized int[][] getMidiInstrumentEntries(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST MIDI_INSTRUMENTS " + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseArray(this.getSingleLineResultSet().getResult());
        int[][] nArray = new int[stringArray.length][3];
        for (int i = 0; i < stringArray.length; ++i) {
            Integer[] integerArray = Parser.parseIntList(stringArray[i]);
            if (integerArray.length != 3) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            nArray[i][0] = integerArray[0];
            nArray[i][1] = integerArray[1];
            nArray[i][2] = integerArray[2];
        }
        return nArray;
    }

    public synchronized MidiInstrumentInfo[] getMidiInstruments(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST MIDI_INSTRUMENTS " + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseArray(this.getSingleLineResultSet().getResult());
        return this.getMidiInstruments(stringArray);
    }

    private MidiInstrumentInfo[] getMidiInstruments(String[] stringArray) throws IOException, LscpException, LSException {
        Vector<MidiInstrumentInfo> vector = new Vector<MidiInstrumentInfo>();
        for (String string : stringArray) {
            Integer[] integerArray = Parser.parseIntList(string);
            if (integerArray.length != 3) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            vector.add(this.getMidiInstrumentInfo(integerArray[0], integerArray[1], integerArray[2]));
        }
        return vector.toArray(new MidiInstrumentInfo[vector.size()]);
    }

    public synchronized MidiInstrumentInfo getMidiInstrumentInfo(int n, int n2, int n3) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.requestMidiInstrumentInfo(n, n2, n3);
        return this.getMidiInstrumentInfoResponse(n, n2, n3);
    }

    private void requestMidiInstrumentInfo(int n, int n2, int n3) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("GET MIDI_INSTRUMENT INFO ");
        stringBuffer.append(n).append(' ');
        stringBuffer.append(n2).append(' ');
        stringBuffer.append(n3);
        this.out.writeLine(stringBuffer.toString());
    }

    private MidiInstrumentInfo getMidiInstrumentInfoResponse(int n, int n2, int n3) throws IOException, LscpException, LSException {
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        MidiInstrumentEntry midiInstrumentEntry = new MidiInstrumentEntry(n2, n3);
        return new MidiInstrumentInfo(n, midiInstrumentEntry, resultSet.getMultiLineResult());
    }

    public synchronized void loadInstrument(String string, int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.loadInstrument(string, n, n2, false);
    }

    public synchronized void loadInstrument(String string, int n, int n2, boolean bl) throws IOException, LscpException, LSException {
        String string2 = bl ? "LOAD INSTRUMENT NON_MODAL " : "LOAD INSTRUMENT ";
        String string3 = '\'' + this.conv(string) + "' " + n + ' ' + n2;
        this.out.writeLine(string2 + string3);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void loadSamplerEngine(String string, int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LOAD ENGINE " + string + ' ' + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getSamplerChannelCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET CHANNELS");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized SamplerChannel[] getSamplerChannels() throws IOException, LscpException, LSException {
        Integer[] integerArray = this.getSamplerChannelIDs();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        SamplerChannel[] samplerChannelArray = new SamplerChannel[integerArray.length];
        for (int i = 0; i < samplerChannelArray.length; ++i) {
            samplerChannelArray[i] = this.getSamplerChannelInfo(integerArray[i]);
        }
        return samplerChannelArray;
    }

    public synchronized Integer[] getSamplerChannelIDs() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST CHANNELS");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseIntList(this.getSingleLineResultSet().getResult());
    }

    public synchronized int addSamplerChannel() throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("ADD CHANNEL");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void removeSamplerChannel(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("REMOVE CHANNEL " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getEngineCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET AVAILABLE_ENGINES");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized SamplerEngine[] getEngines() throws IOException, LscpException, LSException {
        String[] stringArray = this.getEngineNames();
        if (this.getPrintOnlyMode()) {
            return null;
        }
        SamplerEngine[] samplerEngineArray = new SamplerEngine[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            samplerEngineArray[i] = this.getEngineInfo(stringArray[i]);
        }
        return samplerEngineArray;
    }

    private synchronized String[] getEngineNames() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST AVAILABLE_ENGINES");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseStringList(this.getSingleLineResultSet().getResult());
    }

    private synchronized SamplerEngine getEngineInfo(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET ENGINE INFO " + string);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        SamplerEngine samplerEngine = new SamplerEngine(resultSet.getMultiLineResult());
        samplerEngine.setName(string);
        return samplerEngine;
    }

    public synchronized SamplerChannel getSamplerChannelInfo(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET CHANNEL INFO " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        SamplerChannel samplerChannel = new SamplerChannel(resultSet.getMultiLineResult());
        samplerChannel.setChannelId(n);
        if (samplerChannel.getEngine() != null) {
            samplerChannel.setEngine(this.getEngineInfo(samplerChannel.getEngine().getName()));
        }
        return samplerChannel;
    }

    public synchronized int getChannelVoiceCount(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET CHANNEL VOICE_COUNT " + n);
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getSingleLineResultSet();
        return Parser.parseInt(resultSet.getResult());
    }

    public synchronized int getChannelStreamCount(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET CHANNEL STREAM_COUNT " + n);
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getSingleLineResultSet();
        if (resultSet.getResult().equals("NA")) {
            return -1;
        }
        return Parser.parseInt(resultSet.getResult());
    }

    public synchronized Vector<BufferFill> getChannelBufferFillBytes(int n) throws IOException, LscpException, LSException {
        String[] stringArray;
        this.verifyConnection();
        this.out.writeLine("GET CHANNEL BUFFER_FILL BYTES " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getSingleLineResultSet();
        if (resultSet.getResult().equals("NA")) {
            return null;
        }
        Vector<BufferFill> vector = new Vector<BufferFill>();
        for (String string : stringArray = Parser.parseList(resultSet.getResult())) {
            if (string.charAt(0) != '[') {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            int n2 = string.indexOf(93);
            if (n2 == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            BufferFill bufferFill = new BufferFill();
            bufferFill.setStreamId(Parser.parseInt(string.substring(1, n2)));
            bufferFill.setValue(Parser.parseInt(string.substring(n2 + 1)));
            vector.add(bufferFill);
        }
        return vector;
    }

    public synchronized Vector<BufferFill> getChannelBufferFillPercentage(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET CHANNEL BUFFER_FILL PERCENTAGE " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getSingleLineResultSet();
        return this.getChannelBufferFillPercentage(resultSet.getResult());
    }

    private Vector<BufferFill> getChannelBufferFillPercentage(String string) throws LscpException {
        String[] stringArray;
        if (string.equals("NA")) {
            return null;
        }
        Vector<BufferFill> vector = new Vector<BufferFill>();
        for (String string2 : stringArray = Parser.parseList(string)) {
            if (string2.charAt(0) != '[') {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            int n = string2.indexOf(93);
            if (n == -1) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            if (string2.charAt(string2.length() - 1) != '%') {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"));
            }
            BufferFill bufferFill = new BufferFill();
            bufferFill.setStreamId(Parser.parseInt(string2.substring(1, n)));
            bufferFill.setValue(Parser.parseInt(string2.substring(n + 1, string2.length() - 1)));
            vector.add(bufferFill);
        }
        return vector;
    }

    public synchronized void setChannelAudioOutputDevice(int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET CHANNEL AUDIO_OUTPUT_DEVICE " + n + ' ' + n2);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelAudioOutputChannel(int n, int n2, int n3) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = " " + n + ' ' + n2 + ' ' + n3;
        this.out.writeLine("SET CHANNEL AUDIO_OUTPUT_CHANNEL" + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelMidiInputDevice(int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET CHANNEL MIDI_INPUT_DEVICE " + n + ' ' + n2);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelMidiInputPort(int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET CHANNEL MIDI_INPUT_PORT " + n + ' ' + n2);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelMidiInputChannel(int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = String.valueOf(n) + ' ';
        string = string + (n2 == -1 ? "ALL" : String.valueOf(n2));
        this.out.writeLine("SET CHANNEL MIDI_INPUT_CHANNEL " + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelMidiInstrumentMap(int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = n2 == -1 ? " NONE" : (n2 == -2 ? " DEFAULT" : " " + String.valueOf(n2));
        this.out.writeLine("SET CHANNEL MIDI_INSTRUMENT_MAP " + n + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelVolume(int n, float f) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET CHANNEL VOLUME " + n + ' ' + f);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelMute(int n, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET CHANNEL MUTE " + n + ' ' + (bl ? 1 : 0));
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setChannelSolo(int n, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET CHANNEL SOLO " + n + ' ' + (bl ? 1 : 0));
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int createFxSend(int n, int n2) throws IOException, LSException, LscpException {
        return this.createFxSend(n, n2, null);
    }

    public synchronized int createFxSend(int n, int n2, String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        String string2 = String.valueOf(n) + " " + String.valueOf(n2);
        if (string != null) {
            string2 = string2 + " '" + this.toEscapedText(string) + "'";
        }
        this.out.writeLine("CREATE FX_SEND " + string2);
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void destroyFxSend(int n, int n2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        String string = String.valueOf(n) + " " + String.valueOf(n2);
        this.out.writeLine("DESTROY FX_SEND " + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getFxSoundCount(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET FX_SENDS " + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized FxSend[] getFxSends(int n) throws IOException, LscpException, LSException {
        Integer[] integerArray = this.getFxSendIDs(n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        FxSend[] fxSendArray = new FxSend[integerArray.length];
        for (int i = 0; i < fxSendArray.length; ++i) {
            fxSendArray[i] = this.getFxSendInfo(n, integerArray[i]);
        }
        return fxSendArray;
    }

    public synchronized Integer[] getFxSendIDs(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST FX_SENDS " + n);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseIntList(this.getSingleLineResultSet().getResult());
    }

    public synchronized FxSend getFxSendInfo(int n, int n2) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = String.valueOf(n) + " " + String.valueOf(n2);
        this.out.writeLine("GET FX_SEND INFO " + string);
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        FxSend fxSend = new FxSend(resultSet.getMultiLineResult());
        fxSend.setFxSendId(n2);
        return fxSend;
    }

    public synchronized void setFxSendName(int n, int n2, String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string2 = " " + n + " " + n2 + " '" + this.toEscapedText(string) + "'";
        this.out.writeLine("SET FX_SEND NAME" + string2);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setFxSendAudioOutputChannel(int n, int n2, int n3, int n4) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = " " + n + " " + n2 + " " + n3 + " " + n4;
        this.out.writeLine("SET FX_SEND AUDIO_OUTPUT_CHANNEL" + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setFxSendMidiController(int n, int n2, int n3) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = " " + n + " " + n2 + " " + n3;
        this.out.writeLine("SET FX_SEND MIDI_CONTROLLER" + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setFxSendLevel(int n, int n2, float f) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = " " + n + " " + n2 + " " + String.valueOf(f);
        this.out.writeLine("SET FX_SEND LEVEL" + string);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void editChannelInstrument(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("EDIT CHANNEL INSTRUMENT " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void sendChannelMidiData(int n, MidiDataEvent.Type type, int n2, int n3) throws IOException, LscpException, LSException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SEND CHANNEL MIDI_DATA ");
        stringBuffer.append((Object)type).append(" ").append(n).append(" ");
        stringBuffer.append(n2).append(" ").append(n3);
        this.out.writeLine(stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void resetChannel(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("RESET CHANNEL " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void addDbDirectory(String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("ADD DB_INSTRUMENT_DIRECTORY '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void removeDbDirectory(String string) throws IOException, LscpException, LSException {
        this.removeDbDirectory(string, false);
    }

    public synchronized void removeDbDirectory(String string, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string2 = "REMOVE DB_INSTRUMENT_DIRECTORY ";
        if (bl) {
            string2 = string2 + "FORCE ";
        }
        this.out.writeLine(string2 + "'" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void removeDbDirectories(String[] stringArray, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string = "REMOVE DB_INSTRUMENT_DIRECTORY ";
        if (bl) {
            string = string + "FORCE ";
        }
        for (String string2 : stringArray) {
            this.out.writeLine(string + "'" + this.conv(string2) + "'");
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        this.getEmptyResultSets(stringArray.length, "Client.dirDeletionFailed!");
    }

    public synchronized int getDbDirectoryCount(String string) throws IOException, LscpException, LSException {
        return this.getDbDirectoryCount(string, false);
    }

    public synchronized int getDbDirectoryCount(String string, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string2 = bl ? "GET DB_INSTRUMENT_DIRECTORIES RECURSIVE '" : "GET DB_INSTRUMENT_DIRECTORIES '";
        this.out.writeLine(string2 + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        string2 = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string2);
    }

    public synchronized String[] getDbDirectoryNames(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST DB_INSTRUMENT_DIRECTORIES '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseEscapedStringList(this.getSingleLineResultSet().getResult());
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Parser.toNonEscapedString(stringArray[i]);
        }
        return stringArray;
    }

    public synchronized DbDirectoryInfo getDbDirectoryInfo(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET DB_INSTRUMENT_DIRECTORY INFO '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        DbDirectoryInfo dbDirectoryInfo = new DbDirectoryInfo(resultSet.getMultiLineResult());
        if (string.equals("/")) {
            dbDirectoryInfo.setName("/");
        } else {
            string = Parser.removeEndingFileSeparator(string);
        }
        String string2 = Parser.getFileName(string);
        if (string2 != null) {
            dbDirectoryInfo.setName(Parser.toNonEscapedFileName(string2));
        }
        if ((string2 = Parser.getParentDirectory(string)) != null) {
            dbDirectoryInfo.setParentDirectoryPath(string2);
        }
        return dbDirectoryInfo;
    }

    public synchronized DbDirectoryInfo[] getDbDirectories(String string) throws IOException, LscpException, LSException {
        String[] stringArray = this.getDbDirectoryNames(string);
        if (!Parser.hasEndingFileSeparator(string)) {
            string = string + "/";
        }
        DbDirectoryInfo[] dbDirectoryInfoArray = new DbDirectoryInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dbDirectoryInfoArray[i] = this.getDbDirectoryInfo(this.conv(string) + this.toEscapedFsEntry(stringArray[i]));
        }
        return dbDirectoryInfoArray;
    }

    public synchronized void renameDbDirectory(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        string2 = this.toEscapedText(string2);
        this.out.writeLine("SET DB_INSTRUMENT_DIRECTORY NAME '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void moveDbDirectory(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("MOVE DB_INSTRUMENT_DIRECTORY '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void moveDbDirectories(String[] stringArray, String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        for (String string2 : stringArray) {
            this.out.writeLine("MOVE DB_INSTRUMENT_DIRECTORY '" + this.conv(string2) + "' '" + this.conv(string) + "'");
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        this.getEmptyResultSets(stringArray.length, "Client.dirMovingFailed!");
    }

    public synchronized void copyDbDirectory(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("COPY DB_INSTRUMENT_DIRECTORY '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void copyDbDirectories(String[] stringArray, String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        for (String string2 : stringArray) {
            this.out.writeLine("COPY DB_INSTRUMENT_DIRECTORY '" + this.conv(string2) + "' '" + this.conv(string) + "'");
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        this.getEmptyResultSets(stringArray.length, "Client.dirCopyingFailed!");
    }

    public synchronized void setDbDirectoryDescription(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        String string3 = "SET DB_INSTRUMENT_DIRECTORY DESCRIPTION '";
        this.out.writeLine(string3 + this.conv(string) + "' '" + this.toEscapedText(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void addDbInstrument(String string, String string2, int n) throws IOException, LSException, LscpException {
        this.addDbInstrument(string, string2, n, false);
    }

    public synchronized int addDbInstrument(String string, String string2, int n, boolean bl) throws IOException, LSException, LscpException {
        this.verifyConnection();
        String string3 = "ADD DB_INSTRUMENTS";
        if (bl) {
            string3 = string3 + " NON_MODAL";
        }
        string3 = string3 + " '" + this.conv(string) + "' '" + this.conv(string2) + "' ";
        this.out.writeLine(string3 + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void addDbInstruments(String string, String string2) throws IOException, LSException, LscpException {
        this.addDbInstruments(string, string2, false);
    }

    public synchronized int addDbInstruments(String string, String string2, boolean bl) throws IOException, LSException, LscpException {
        this.verifyConnection();
        String string3 = "ADD DB_INSTRUMENTS";
        if (bl) {
            string3 = string3 + " NON_MODAL";
        }
        this.out.writeLine(string3 + " '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void addDbInstruments(ScanMode scanMode, String string, String string2) throws IOException, LSException, LscpException {
        this.addDbInstruments(scanMode, string, string2, false);
    }

    public synchronized int addDbInstruments(ScanMode scanMode, String string, String string2, boolean bl) throws IOException, LSException, LscpException {
        return this.addDbInstruments(scanMode, string, string2, bl, false);
    }

    public synchronized int addDbInstruments(ScanMode scanMode, String string, String string2, boolean bl, boolean bl2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer("ADD DB_INSTRUMENTS");
        if (bl) {
            stringBuffer.append(" NON_MODAL");
        }
        switch (scanMode) {
            case RECURSIVE: {
                stringBuffer.append(" RECURSIVE");
                break;
            }
            case NON_RECURSIVE: {
                stringBuffer.append(" NON_RECURSIVE");
                break;
            }
            case FLAT: {
                stringBuffer.append(" FLAT");
            }
        }
        if (bl2) {
            stringBuffer.append(" FILE_AS_DIR");
        }
        stringBuffer.append(" '").append(this.conv(string)).append("' '");
        stringBuffer.append(this.conv(string2)).append("'");
        this.out.writeLine(stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        ResultSet resultSet = this.getEmptyResultSet();
        return resultSet.getIndex();
    }

    public synchronized void removeDbInstrument(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("REMOVE DB_INSTRUMENT '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void removeDbInstruments(String[] stringArray) throws IOException, LscpException, LSException {
        this.verifyConnection();
        for (String string : stringArray) {
            this.out.writeLine("REMOVE DB_INSTRUMENT '" + this.conv(string) + "'");
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        this.getEmptyResultSets(stringArray.length, "Client.instrDeletionFailed!");
    }

    public synchronized int getDbInstrumentCount(String string) throws IOException, LscpException, LSException {
        return this.getDbInstrumentCount(string, false);
    }

    public synchronized int getDbInstrumentCount(String string, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        String string2 = bl ? "GET DB_INSTRUMENTS RECURSIVE '" : "GET DB_INSTRUMENTS '";
        this.out.writeLine(string2 + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        string2 = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string2);
    }

    public synchronized String[] getDbInstrumentNames(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("LIST DB_INSTRUMENTS '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseEscapedStringList(this.getSingleLineResultSet().getResult());
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Parser.toNonEscapedString(stringArray[i]);
        }
        return stringArray;
    }

    public synchronized DbInstrumentInfo getDbInstrumentInfo(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET DB_INSTRUMENT INFO '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        DbInstrumentInfo dbInstrumentInfo = new DbInstrumentInfo(resultSet.getMultiLineResult());
        String string2 = Parser.getParentDirectory(string);
        if (string2 != null) {
            dbInstrumentInfo.setDirectoryPath(string2);
        }
        if ((string2 = Parser.getFileName(string)) != null) {
            dbInstrumentInfo.setName(Parser.toNonEscapedFileName(string2));
        }
        return dbInstrumentInfo;
    }

    public synchronized DbInstrumentInfo[] getDbInstruments(String string) throws IOException, LscpException, LSException {
        String[] stringArray = this.getDbInstrumentNames(string);
        if (!Parser.hasEndingFileSeparator(string)) {
            string = string + "/";
        }
        DbInstrumentInfo[] dbInstrumentInfoArray = new DbInstrumentInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dbInstrumentInfoArray[i] = this.getDbInstrumentInfo(this.conv(string) + this.toEscapedFsEntry(stringArray[i]));
        }
        return dbInstrumentInfoArray;
    }

    public synchronized void renameDbInstrument(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        string2 = this.toEscapedText(string2);
        this.out.writeLine("SET DB_INSTRUMENT NAME '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void moveDbInstrument(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("MOVE DB_INSTRUMENT '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void moveDbInstruments(String[] stringArray, String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        for (String string2 : stringArray) {
            this.out.writeLine("MOVE DB_INSTRUMENT '" + this.conv(string2) + "' '" + this.conv(string) + "'");
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        this.getEmptyResultSets(stringArray.length, "Client.instrMovingFailed!");
    }

    public synchronized void copyDbInstrument(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("COPY DB_INSTRUMENT '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void copyDbInstruments(String[] stringArray, String string) throws IOException, LSException, LscpException {
        this.verifyConnection();
        for (String string2 : stringArray) {
            this.out.writeLine("COPY DB_INSTRUMENT '" + this.conv(string2) + "' '" + this.conv(string) + "'");
        }
        if (this.getPrintOnlyMode()) {
            return;
        }
        this.getEmptyResultSets(stringArray.length, "Client.instrCopyingFailed!");
    }

    public synchronized void setDbInstrumentDescription(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        string2 = this.toEscapedText(string2);
        this.out.writeLine("SET DB_INSTRUMENT DESCRIPTION '" + this.conv(string) + "' '" + string2 + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void setDbInstrumentFilePath(String string, String string2) throws IOException, LSException, LscpException {
        this.verifyConnection();
        this.out.writeLine("SET DB_INSTRUMENT FILE_PATH '" + this.conv(string) + "' '" + this.conv(string2) + "'");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized DbDirectoryInfo[] findDbDirectories(String string, DbSearchQuery dbSearchQuery) throws IOException, LscpException, LSException {
        return this.findDbDirectories(string, dbSearchQuery, false);
    }

    public synchronized DbDirectoryInfo[] findDbDirectories(String string, DbSearchQuery dbSearchQuery, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FIND DB_INSTRUMENT_DIRECTORIES");
        if (bl) {
            stringBuffer.append(" NON_RECURSIVE");
        }
        stringBuffer.append(" '").append(this.conv(string)).append("'");
        if (dbSearchQuery.name != null && dbSearchQuery.name.length() > 0) {
            stringBuffer.append(" NAME='").append(this.toEscapedText(dbSearchQuery.name)).append("'");
        }
        String string2 = dbSearchQuery.getCreatedAfter();
        String string3 = dbSearchQuery.getCreatedBefore();
        if (string2 != null || string3 != null) {
            stringBuffer.append(" CREATED='");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("..");
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            stringBuffer.append("'");
        }
        string2 = dbSearchQuery.getModifiedAfter();
        string3 = dbSearchQuery.getModifiedBefore();
        if (string2 != null || string3 != null) {
            stringBuffer.append(" MODIFIED='");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("..");
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            stringBuffer.append("'");
        }
        if (dbSearchQuery.description != null && dbSearchQuery.description.length() > 0) {
            stringBuffer.append(" DESCRIPTION='");
            stringBuffer.append(this.toEscapedText(dbSearchQuery.description)).append("'");
        }
        this.out.writeLine(stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseEscapedStringList(this.getSingleLineResultSet().getResult());
        DbDirectoryInfo[] dbDirectoryInfoArray = new DbDirectoryInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dbDirectoryInfoArray[i] = this.getDbDirectoryInfo(stringArray[i]);
        }
        return dbDirectoryInfoArray;
    }

    public synchronized DbInstrumentInfo[] findDbInstruments(String string, DbSearchQuery dbSearchQuery) throws IOException, LscpException, LSException {
        return this.findDbInstruments(string, dbSearchQuery, false);
    }

    public synchronized DbInstrumentInfo[] findDbInstruments(String string, DbSearchQuery dbSearchQuery, boolean bl) throws IOException, LscpException, LSException {
        this.verifyConnection();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FIND DB_INSTRUMENTS");
        if (bl) {
            stringBuffer.append(" NON_RECURSIVE");
        }
        stringBuffer.append(" '").append(this.conv(string)).append("'");
        if (dbSearchQuery.name != null && dbSearchQuery.name.length() > 0) {
            stringBuffer.append(" NAME='").append(this.toEscapedText(dbSearchQuery.name)).append("'");
        }
        if (dbSearchQuery.formatFamilies.size() > 0) {
            stringBuffer.append(" FORMAT_FAMILIES='").append(dbSearchQuery.formatFamilies.get(0));
            for (int i = 1; i < dbSearchQuery.formatFamilies.size(); ++i) {
                stringBuffer.append(',').append(dbSearchQuery.formatFamilies.get(i));
            }
            stringBuffer.append("'");
        }
        if (dbSearchQuery.minSize != -1L || dbSearchQuery.maxSize != -1L) {
            stringBuffer.append(" SIZE='");
            if (dbSearchQuery.minSize != -1L) {
                stringBuffer.append(dbSearchQuery.minSize);
            }
            stringBuffer.append("..");
            if (dbSearchQuery.maxSize != -1L) {
                stringBuffer.append(dbSearchQuery.maxSize);
            }
            stringBuffer.append("'");
        }
        String string2 = dbSearchQuery.getCreatedAfter();
        String string3 = dbSearchQuery.getCreatedBefore();
        if (string2 != null || string3 != null) {
            stringBuffer.append(" CREATED='");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("..");
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            stringBuffer.append("'");
        }
        string2 = dbSearchQuery.getModifiedAfter();
        string3 = dbSearchQuery.getModifiedBefore();
        if (string2 != null || string3 != null) {
            stringBuffer.append(" MODIFIED='");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("..");
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            stringBuffer.append("'");
        }
        if (dbSearchQuery.description != null && dbSearchQuery.description.length() > 0) {
            stringBuffer.append(" DESCRIPTION='");
            stringBuffer.append(this.toEscapedText(dbSearchQuery.description)).append("'");
        }
        if (dbSearchQuery.instrumentType != DbSearchQuery.InstrumentType.BOTH) {
            stringBuffer.append(" IS_DRUM=");
            if (dbSearchQuery.instrumentType == DbSearchQuery.InstrumentType.DRUM) {
                stringBuffer.append("'true'");
            } else {
                stringBuffer.append("'false'");
            }
        }
        if (dbSearchQuery.product != null && dbSearchQuery.product.length() > 0) {
            stringBuffer.append(" PRODUCT='").append(this.toEscapedText(dbSearchQuery.product)).append("'");
        }
        if (dbSearchQuery.artists != null && dbSearchQuery.artists.length() > 0) {
            stringBuffer.append(" ARTISTS='").append(this.toEscapedText(dbSearchQuery.artists)).append("'");
        }
        if (dbSearchQuery.keywords != null && dbSearchQuery.keywords.length() > 0) {
            stringBuffer.append(" KEYWORDS='");
            stringBuffer.append(this.toEscapedText(dbSearchQuery.keywords)).append("'");
        }
        this.out.writeLine(stringBuffer.toString());
        if (this.getPrintOnlyMode()) {
            return null;
        }
        String[] stringArray = Parser.parseEscapedStringList(this.getSingleLineResultSet().getResult());
        DbInstrumentInfo[] dbInstrumentInfoArray = new DbInstrumentInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dbInstrumentInfoArray[i] = this.getDbInstrumentInfo(stringArray[i]);
        }
        return dbInstrumentInfoArray;
    }

    public synchronized String[] findLostDbInstrumentFiles() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("FIND LOST DB_INSTRUMENT_FILES");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        return Parser.parseEscapedStringList(this.getSingleLineResultSet().getResult());
    }

    public synchronized ScanJobInfo getDbInstrumentsJobInfo(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET DB_INSTRUMENTS_JOB INFO " + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        ScanJobInfo scanJobInfo = new ScanJobInfo(resultSet.getMultiLineResult());
        return scanJobInfo;
    }

    public synchronized void formatInstrumentsDb() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("FORMAT INSTRUMENTS_DB");
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized void resetSampler() throws IOException, LscpException {
        this.verifyConnection();
        this.out.writeLine("RESET");
        if (this.getPrintOnlyMode()) {
            return;
        }
        try {
            ResultSet resultSet = this.getEmptyResultSet();
        }
        catch (LSException lSException) {
            Client.getLogger().warning(lSException.getMessage());
        }
    }

    public synchronized int getTotalStreamCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET TOTAL_STREAM_COUNT");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized int getTotalVoiceCount() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET TOTAL_VOICE_COUNT");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized int getTotalVoiceCountMax() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET TOTAL_VOICE_COUNT_MAX");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized ServerInfo getServerInfo() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET SERVER INFO");
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        return new ServerInfo(resultSet.getMultiLineResult());
    }

    public synchronized float getVolume() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET VOLUME");
        if (this.getPrintOnlyMode()) {
            return -1.0f;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseFloat(string);
    }

    public synchronized void setVolume(float f) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET VOLUME " + f);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getGlobalVoiceLimit() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET VOICES");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized void setGlobalVoiceLimit(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET VOICES " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getGlobalStreamLimit() throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET STREAMS");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string);
    }

    public synchronized void setGlobalStreamLimit(int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("SET STREAMS " + n);
        if (this.getPrintOnlyMode()) {
            return;
        }
        ResultSet resultSet = this.getEmptyResultSet();
    }

    public synchronized int getFileInstrumentCount(String string) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET FILE INSTRUMENTS '" + this.conv(string) + "'");
        if (this.getPrintOnlyMode()) {
            return -1;
        }
        String string2 = this.getSingleLineResultSet().getResult();
        return Parser.parseInt(string2);
    }

    public synchronized Instrument getFileInstrumentInfo(String string, int n) throws IOException, LscpException, LSException {
        this.verifyConnection();
        this.out.writeLine("GET FILE INSTRUMENT INFO '" + this.conv(string) + "' " + String.valueOf(n));
        if (this.getPrintOnlyMode()) {
            return null;
        }
        ResultSet resultSet = this.getMultiLineResultSet();
        FileInstrument fileInstrument = new FileInstrument(resultSet.getMultiLineResult()){};
        return fileInstrument;
    }

    public synchronized Instrument[] getFileInstruments(String string) throws IOException, LscpException, LSException {
        int n = this.getFileInstrumentCount(string);
        if (n < 0) {
            return null;
        }
        Instrument[] instrumentArray = new FileInstrument[n];
        for (int i = 0; i < instrumentArray.length; ++i) {
            instrumentArray[i] = this.getFileInstrumentInfo(string, i);
        }
        return instrumentArray;
    }

    private void getEmptyResultSets(int n, String string) throws LSException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            try {
                this.getEmptyResultSet();
                continue;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                Client.getLogger().log(Level.FINE, socketTimeoutException.getMessage(), socketTimeoutException);
                stringBuffer.append(socketTimeoutException.getMessage()).append("\n");
                break;
            }
            catch (Exception exception) {
                Client.getLogger().log(Level.FINE, exception.getMessage(), exception);
                stringBuffer.append(exception.getMessage()).append("\n");
            }
        }
        if ((string2 = stringBuffer.toString()).length() > 0) {
            String string3 = LscpI18n.getLogMsg(string);
            throw new LSException(0, string3, string2);
        }
    }

    protected static Logger getLogger() {
        return Logger.getLogger("org.linuxsampler.lscp");
    }

    private static class FileInstrument
    extends AbstractInstrument {
        FileInstrument(String[] stringArray) throws LscpException {
            super(stringArray);
        }

        @Override
        public String getEngine() {
            return this.getFormatFamily();
        }

        @Override
        public boolean parse(String string) throws LscpException {
            if (string.startsWith("PRODUCT: ") || string.startsWith("ARTISTS: ")) {
                return true;
            }
            return super.parse(string);
        }
    }

    public static enum ScanMode {
        RECURSIVE,
        NON_RECURSIVE,
        FLAT;

    }

    class EventThread
    extends Thread {
        private Vector<String> queue;
        private boolean terminate;

        EventThread() {
            super("LSCP-Event-Thread");
            this.queue = new Vector();
            this.terminate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.mustTerminate()) {
                try {
                    this.processQueue();
                    Client.this.processNotifications();
                }
                catch (Exception exception) {
                    Client.getLogger().log(Level.FINE, exception.getMessage(), exception);
                }
                try {
                    EventThread eventThread = this;
                    synchronized (eventThread) {
                        this.wait(100L);
                    }
                }
                catch (Exception exception) {
                    Client.getLogger().log(Level.FINE, exception.getMessage(), exception);
                }
            }
        }

        private synchronized boolean mustTerminate() {
            return this.terminate;
        }

        public synchronized void terminate() {
            this.terminate = true;
            this.notifyAll();
        }

        public synchronized void scheduleNotification(String string) {
            this.queue.add(string);
        }

        private void processQueue() {
            String[] stringArray;
            for (String string : stringArray = this.popAllNotifications()) {
                Client.this.fireEvent(string);
            }
        }

        private synchronized String[] popAllNotifications() {
            String[] stringArray = this.queue.toArray(new String[this.queue.size()]);
            this.queue.removeAllElements();
            return stringArray;
        }
    }
}

