/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query.internal;

import java.util.Arrays;
import org.keycloak.storage.ldap.idm.query.internal.NamedParameterCondition;

public class SubstringCondition
extends NamedParameterCondition {
    private final String start;
    private final String[] middle;
    private final String end;

    public SubstringCondition(String name, String start, String[] middle, String end) {
        super(name);
        this.start = start;
        this.middle = middle;
        this.end = end;
    }

    @Override
    public void applyCondition(StringBuilder filter) {
        filter.append("(").append(this.getParameterName()).append("=");
        if (this.start != null && !this.start.isEmpty()) {
            filter.append(this.escapeValue(this.start));
        }
        filter.append("*");
        if (this.middle != null && this.middle.length > 0) {
            Arrays.stream(this.middle).forEach(s -> filter.append(this.escapeValue(s)).append("*"));
        }
        if (this.end != null && !this.end.isEmpty()) {
            filter.append(this.escapeValue(this.end));
        }
        filter.append(")");
    }

    public String toString() {
        return "PresentCondition{paramName=" + this.getParameterName() + ", start=" + this.start + ", middle=" + String.valueOf(this.middle == null ? "null" : Arrays.asList(this.middle)) + ", end=" + this.end + "}";
    }
}

