/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.vertx;

import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AbstractParameterProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.vertx.VertxConstants;
import io.smallrye.openapi.vertx.VertxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class VertxParameterProcessor
extends AbstractParameterProcessor {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile(":[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)");

    private VertxParameterProcessor(AnnotationScannerContext scannerContext, String contextPath, Function<AnnotationInstance, Parameter> reader, ClassInfo resourceClass, MethodInfo resourceMethod) {
        super(scannerContext, contextPath, reader, resourceClass, resourceMethod);
    }

    public static ResourceParameters process(AnnotationScannerContext context, String contextPath, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, Parameter> reader) {
        VertxParameterProcessor processor = new VertxParameterProcessor(context, contextPath, reader, resourceClass, resourceMethod);
        return processor.process();
    }

    protected Pattern getTemplateParameterPattern() {
        return TEMPLATE_PARAM_PATTERN;
    }

    protected FrameworkParameter getMatrixParameter() {
        return null;
    }

    protected void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (this.isReadableParameterAnnotation(name)) {
            this.readParameterAnnotation(annotation, overriddenParametersOnly);
        } else if (VertxConstants.PARAM.equals((Object)name)) {
            MethodInfo resourceMethod = annotation.target().asMethodParameter().method();
            String parameterName = VertxParameterProcessor.paramName((AnnotationInstance)annotation);
            String path = (String)this.scannerContext.annotations().getAnnotationValue((AnnotationTarget)resourceMethod, Collections.singletonList(VertxConstants.ROUTE), "path", (Object)resourceMethod.name());
            if (path.contains(":" + parameterName)) {
                FrameworkParameter vertxParameter = VertxParameter.PATH_PARAM.parameter;
                this.readAnnotatedType(vertxParameter, annotation, beanParamAnnotation, overriddenParametersOnly);
            } else {
                FrameworkParameter vertxParameter = VertxParameter.QUERY_PARAM.parameter;
                this.readAnnotatedType(vertxParameter, annotation, beanParamAnnotation, overriddenParametersOnly);
            }
        } else if (VertxConstants.HEADER_PARAM.equals((Object)name)) {
            FrameworkParameter vertxParameter = VertxParameter.HEADER_PARAM.parameter;
            this.readAnnotatedType(vertxParameter, annotation, beanParamAnnotation, overriddenParametersOnly);
        }
    }

    private void readAnnotatedType(FrameworkParameter frameworkParam, AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        AnnotationTarget target = annotation.target();
        Type targetType = this.getType(target);
        if (frameworkParam.style == Parameter.Style.FORM) {
            this.formParams.put(VertxParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
            this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
        } else if (frameworkParam.style == Parameter.Style.MATRIX) {
            List pathSegments = beanParamAnnotation != null ? this.lastPathSegmentsOf(beanParamAnnotation.target()) : this.lastPathSegmentsOf(target);
            boolean isPathSegmentsEmpty = pathSegments == null || pathSegments.isEmpty();
            String pathSegment = !isPathSegmentsEmpty ? (String)pathSegments.get(0) : null;
            this.matrixParams.computeIfAbsent(pathSegment, k -> new HashMap()).put(VertxParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
        } else if (frameworkParam.location != null) {
            this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
        } else if (target != null) {
            this.setMediaType(frameworkParam);
            targetType = TypeUtil.unwrapType((Type)targetType);
            if (targetType != null) {
                ClassInfo beanParam = this.index.getClassByName(targetType.name());
                this.readParameters(beanParam, annotation, overriddenParametersOnly);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> pathsOf(AnnotationTarget target) {
        String pathValue = null;
        if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
            pathValue = (String)this.scannerContext.annotations().getAnnotationValue(target, Collections.singletonList(VertxConstants.ROUTE_BASE), "path");
        } else if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
            pathValue = (String)this.scannerContext.annotations().getAnnotationValue(target, Collections.singletonList(VertxConstants.ROUTE), "path", (Object)target.asMethod().name());
        }
        if (pathValue == null) {
            return List.of("");
        }
        if (pathValue.startsWith("/")) {
            pathValue = pathValue.substring(1);
        }
        if (pathValue.endsWith("/")) {
            pathValue = pathValue.substring(0, pathValue.length() - 1);
        }
        if (pathValue.contains(":")) {
            List<String> parts = Arrays.asList(pathValue.split("/"));
            ArrayList<void> partsConverted = new ArrayList<void>();
            for (String string : parts) {
                void var6_6;
                if (string.startsWith(":")) {
                    String string2 = "{" + string.substring(1) + "}";
                }
                partsConverted.add(var6_6);
            }
            pathValue = String.join((CharSequence)"/", partsConverted.toArray(new String[0]));
        }
        return List.of(pathValue);
    }

    protected boolean isSubResourceLocator(MethodInfo method) {
        return false;
    }

    protected boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(arg_0 -> ((DotName)VertxConstants.ROUTE).equals(arg_0));
    }

    protected boolean isParameter(DotName annotationName) {
        if (VertxParameter.isParameter(annotationName)) {
            return true;
        }
        if (Names.PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return Names.PARAMETERS.equals((Object)annotationName);
    }
}

