/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import org.hibernate.cache.internal.BasicCacheKeyImplementation;
import org.hibernate.cache.internal.CacheKeyImplementation;
import org.hibernate.cache.internal.NaturalIdCacheKey;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class DefaultCacheKeysFactory
implements CacheKeysFactory {
    public static final String SHORT_NAME = "default";
    public static final DefaultCacheKeysFactory INSTANCE = new DefaultCacheKeysFactory();

    public static Object staticCreateCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        Type keyType = persister.getKeyType();
        Serializable disassembledKey = keyType.disassemble(id, factory);
        boolean idIsArray = disassembledKey.getClass().isArray();
        return tenantIdentifier == null && !idIsArray ? new BasicCacheKeyImplementation(id, disassembledKey, keyType, persister.getRole()) : new CacheKeyImplementation(id, disassembledKey, keyType, persister.getRole(), tenantIdentifier);
    }

    public static Object staticCreateEntityKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        Type keyType = persister.getIdentifierType();
        Serializable disassembledKey = keyType.disassemble(id, factory);
        boolean idIsArray = disassembledKey.getClass().isArray();
        return tenantIdentifier == null && !idIsArray ? new BasicCacheKeyImplementation(id, disassembledKey, keyType, persister.getRootEntityName()) : new CacheKeyImplementation(id, disassembledKey, keyType, persister.getRootEntityName(), tenantIdentifier);
    }

    public static Object staticCreateNaturalIdKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return NaturalIdCacheKey.from(naturalIdValues, persister, session);
    }

    public static Object staticGetEntityId(Object cacheKeyObject) {
        if (cacheKeyObject instanceof BasicCacheKeyImplementation) {
            BasicCacheKeyImplementation basicCacheKey = (BasicCacheKeyImplementation)cacheKeyObject;
            return basicCacheKey.id;
        }
        if (cacheKeyObject instanceof CacheKeyImplementation) {
            CacheKeyImplementation cacheKey = (CacheKeyImplementation)cacheKeyObject;
            return cacheKey.getId();
        }
        throw new IllegalArgumentException("Not an instance of CacheKeyImplementation" + String.valueOf(cacheKeyObject));
    }

    public static Object staticGetCollectionId(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetEntityId(cacheKey);
    }

    public static Object staticGetNaturalIdValues(Object cacheKey) {
        return ((NaturalIdCacheKey)cacheKey).getNaturalIdValues();
    }

    @Override
    public Object createCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.staticCreateCollectionKey(id, persister, factory, tenantIdentifier);
    }

    @Override
    public Object createEntityKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.staticCreateEntityKey(id, persister, factory, tenantIdentifier);
    }

    @Override
    public Object createNaturalIdKey(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return DefaultCacheKeysFactory.staticCreateNaturalIdKey(naturalIdValues, persister, session);
    }

    @Override
    public Object getEntityId(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetEntityId(cacheKey);
    }

    @Override
    public Object getCollectionId(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetCollectionId(cacheKey);
    }

    @Override
    public Object getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetNaturalIdValues(cacheKey);
    }
}

