/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.suggest.scorer.pinyin;

import com.hankcs.hanlp.algorithm.EditDistance;
import com.hankcs.hanlp.algorithm.LongestCommonSubstring;
import com.hankcs.hanlp.collection.dartsclone.Pair;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinUtil;
import com.hankcs.hanlp.dictionary.py.String2PinyinConverter;
import com.hankcs.hanlp.suggest.scorer.ISentenceKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PinyinKey
implements Comparable<PinyinKey>,
ISentenceKey<PinyinKey> {
    Pinyin[] pinyinArray;
    int[] pyOrdinalArray;
    char[] firstCharArray;

    public PinyinKey(String sentence) {
        Pair<List<Pinyin>, List<Boolean>> pair = String2PinyinConverter.convert2Pair(sentence, true);
        this.pinyinArray = PinyinUtil.convertList2Array(pair.getKey());
        List<Boolean> booleanList = pair.getValue();
        int pinyinSize = 0;
        for (Boolean bl : booleanList) {
            if (!bl.booleanValue()) continue;
            ++pinyinSize;
        }
        int firstCharSize = 0;
        for (Pinyin pinyin : this.pinyinArray) {
            if (pinyin == Pinyin.none5) continue;
            ++firstCharSize;
        }
        this.pyOrdinalArray = new int[pinyinSize];
        this.firstCharArray = new char[firstCharSize];
        pinyinSize = 0;
        firstCharSize = 0;
        Iterator<Boolean> iterator = booleanList.iterator();
        for (int i = 0; i < this.pinyinArray.length; ++i) {
            if (iterator.next().booleanValue()) {
                this.pyOrdinalArray[pinyinSize++] = this.pinyinArray[i].ordinal();
            }
            if (this.pinyinArray[i] == Pinyin.none5) continue;
            this.firstCharArray[firstCharSize++] = this.pinyinArray[i].getFirstChar();
        }
    }

    @Override
    public int compareTo(PinyinKey o) {
        int len1 = this.pyOrdinalArray.length;
        int len2 = o.pyOrdinalArray.length;
        int lim = Math.min(len1, len2);
        int[] v1 = this.pyOrdinalArray;
        int[] v2 = o.pyOrdinalArray;
        for (int k = 0; k < lim; ++k) {
            int c1 = v1[k];
            int c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public Double similarity(PinyinKey other) {
        int firstCharArrayLength = this.firstCharArray.length + 1;
        return 1.0 / (double)(EditDistance.compute(this.pyOrdinalArray, other.pyOrdinalArray) + 1) + (double)LongestCommonSubstring.compute(this.firstCharArray, other.firstCharArray) / (double)firstCharArrayLength;
    }

    public int size() {
        int length = 0;
        for (Pinyin pinyin : this.pinyinArray) {
            if (pinyin == Pinyin.none5) continue;
            ++length;
        }
        return length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PinyinKey{");
        sb.append("pinyinArray=").append(Arrays.toString((Object[])this.pinyinArray));
        sb.append(", pyOrdinalArray=").append(Arrays.toString(this.pyOrdinalArray));
        sb.append(", firstCharArray=").append(Arrays.toString(this.firstCharArray));
        sb.append('}');
        return sb.toString();
    }

    public char[] getFirstCharArray() {
        return this.firstCharArray;
    }
}

