/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.annotation;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.CdiAnnotationAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.InterceptorBindingMembersAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.QualifierVerifier;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.openide.util.NbBundle;

public class QualifierAnalyzer
extends InterceptorBindingMembersAnalyzer {
    @Override
    public void analyze(TypeElement element, AtomicBoolean cancel, CdiAnalysisResult result) {
        if (AnnotationUtil.hasAnnotation((Element)element, result.getInfo(), "jakarta.inject.Qualifier", "javax.inject.Qualifier")) {
            result.requireCdiEnabled(element);
            QualifierTargetAnalyzer analyzer = new QualifierTargetAnalyzer(element, result);
            if (!analyzer.hasRuntimeRetention()) {
                result.addError(element, NbBundle.getMessage(QualifierTargetAnalyzer.class, (String)"ERR_IncorrectRuntimeRetention"));
            }
            if (!analyzer.hasTarget()) {
                result.addError(element, NbBundle.getMessage(QualifierTargetAnalyzer.class, (String)"ERR_IncorrectQualifierTarget"));
            }
            if (cancel.get()) {
                return;
            }
            this.checkMembers(element, result, NbBundle.getMessage(QualifierAnalyzer.class, (String)"WARN_ArrayAnnotationValuedQualifierMember"));
        }
    }

    private static class QualifierTargetAnalyzer
    extends CdiAnnotationAnalyzer {
        QualifierTargetAnalyzer(TypeElement element, CdiAnalysisResult result) {
            super(element, result);
        }

        @Override
        protected String getCdiMetaAnnotation() {
            return "Qualifier";
        }

        @Override
        protected TargetVerifier getTargetVerifier() {
            return QualifierVerifier.getInstance(true);
        }
    }
}

