/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.web.beans.impl.model.AbstractAssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.MemberBindingFilter;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.ParameterInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

abstract class EventInjectionPointLogic
extends ParameterInjectionPointLogic {
    public static final String EVENT_INTERFACE = "javax.enterprise.event.Event";
    public static final String EVENT_INTERFACE_JAKARTA = "jakarta.enterprise.event.Event";

    EventInjectionPointLogic(WebBeansModelImplementation model) {
        super(model);
    }

    @Override
    public List<ExecutableElement> getObservers(VariableElement element, DeclaredType parentType) {
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            return null;
        }
        TypeMirror type = this.getParameterType(element, parent, EVENT_INTERFACE_JAKARTA);
        if (type == null) {
            type = this.getParameterType(element, parent, EVENT_INTERFACE);
        }
        if (type == null || type.getKind() == TypeKind.ERROR) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationMirror> qualifierAnnotations = new LinkedList<AnnotationMirror>();
        try {
            this.hasAnyQualifier(element, true, true, qualifierAnnotations);
        }
        catch (FieldInjectionPointLogic.InjectionPointDefinitionError e) {
            return null;
        }
        boolean hasAny = qualifierAnnotations.size() == 0;
        List<ObserverTriple> methodObservesParameters = this.findObservesParameters();
        HashMap<Element, TypeMirror> parameterTypesMap = new HashMap<Element, TypeMirror>();
        for (ObserverTriple triple : methodObservesParameters) {
            ExecutableElement method = (ExecutableElement)triple.getFirst();
            VariableElement parameter = (VariableElement)triple.getSecond();
            int index = (Integer)triple.getThird();
            TypeElement typeElement = this.getCompilationController().getElementUtilities().enclosingTypeElement((Element)method);
            TypeMirror typeMirror = typeElement.asType();
            if (!(typeMirror instanceof DeclaredType)) continue;
            ExecutableType methodType = (ExecutableType)this.getCompilationController().getTypes().asMemberOf((DeclaredType)typeMirror, method);
            List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
            TypeMirror parameterType = parameterTypes.get(index);
            parameterTypesMap.put(parameter, parameterType);
        }
        if (!hasAny) {
            Set<Element> elements = parameterTypesMap.keySet();
            this.filterByQualifiers(qualifierAnnotations, elements);
            this.filterBindingsByMembers(qualifierAnnotations, elements, Element.class);
        }
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>(parameterTypesMap.size());
        this.filterParametersByType(parameterTypesMap, type);
        for (Element parameter : parameterTypesMap.keySet()) {
            Element method = parameter.getEnclosingElement();
            if (method.getKind() != ElementKind.METHOD) continue;
            result.add((ExecutableElement)method);
        }
        return result;
    }

    @Override
    public VariableElement getObserverParameter(ExecutableElement element) {
        Triple<VariableElement, Integer, Void> result = this.doGetObserverParameter(element);
        if (result == null) {
            return null;
        }
        return result.getFirst();
    }

    @Override
    public List<VariableElement> getEventInjectionPoints(ExecutableElement element, DeclaredType parentType) {
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            return null;
        }
        TypeMirror type = this.getCompilationController().getTypes().asMemberOf(parent, element);
        Triple<VariableElement, Integer, Void> parameterInfo = this.doGetObserverParameter(element);
        VariableElement parameter = parameterInfo.getFirst();
        int index = parameterInfo.getSecond();
        if (parameter == null) {
            return Collections.emptyList();
        }
        List<VariableElement> eventInjectionPoints = this.getEventInjectionPoints();
        this.filterByQualifiers(eventInjectionPoints, parameter);
        List<? extends TypeMirror> parameterTypes = ((ExecutableType)type).getParameterTypes();
        TypeMirror parameterType = parameterTypes.get(index);
        this.filterEventInjectionsByType(eventInjectionPoints, parameterType);
        return eventInjectionPoints;
    }

    private List<VariableElement> getEventInjectionPoints() {
        final LinkedList<VariableElement> eventInjection = new LinkedList<VariableElement>();
        try {
            this.getModel().getHelper().getAnnotationScanner().findAnnotations("javax.inject.Inject", EnumSet.of(ElementKind.FIELD), new AnnotationHandler(){
                final /* synthetic */ EventInjectionPointLogic this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    Name name;
                    Element typeElement = this.this$0.getCompilationController().getTypes().asElement(element.asType());
                    if (typeElement instanceof TypeElement && element instanceof VariableElement && EventInjectionPointLogic.EVENT_INTERFACE.contentEquals(name = ((TypeElement)typeElement).getQualifiedName())) {
                        eventInjection.add((VariableElement)element);
                    }
                }
            });
            this.getModel().getHelper().getAnnotationScanner().findAnnotations("jakarta.inject.Inject", EnumSet.of(ElementKind.FIELD), new AnnotationHandler(){
                final /* synthetic */ EventInjectionPointLogic this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    Name name;
                    Element typeElement = this.this$0.getCompilationController().getTypes().asElement(element.asType());
                    if (typeElement instanceof TypeElement && element instanceof VariableElement && EventInjectionPointLogic.EVENT_INTERFACE_JAKARTA.contentEquals(name = ((TypeElement)typeElement).getQualifiedName())) {
                        eventInjection.add((VariableElement)element);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.warning("Finding annotation @Inject was interrupted");
        }
        return eventInjection;
    }

    private void filterByQualifiers(List<? extends AnnotationMirror> qualifierAnnotations, Set<Element> elements) {
        Set<String> requiredQualifiers = EventInjectionPointLogic.getAnnotationFqns(qualifierAnnotations);
        Iterator<Element> iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            List<? extends AnnotationMirror> annotationMirrors = this.getCompilationController().getElements().getAllAnnotationMirrors(element);
            Set<String> availableAnnotations = EventInjectionPointLogic.getAnnotationFqns(annotationMirrors);
            if (availableAnnotations.containsAll(requiredQualifiers)) continue;
            iterator.remove();
        }
    }

    private void filterByQualifiers(List<VariableElement> injectionPoints, VariableElement parameter) {
        List<? extends AnnotationMirror> annotationMirrors = this.getCompilationController().getElements().getAllAnnotationMirrors(parameter);
        Set<String> parameterAnnotations = EventInjectionPointLogic.getAnnotationFqns(annotationMirrors);
        Iterator<VariableElement> iterator = injectionPoints.iterator();
        while (iterator.hasNext()) {
            VariableElement eventInjection = iterator.next();
            LinkedList<AnnotationMirror> eventQualifiers = new LinkedList<AnnotationMirror>();
            try {
                this.hasAnyQualifier(eventInjection, true, true, eventQualifiers);
            }
            catch (FieldInjectionPointLogic.InjectionPointDefinitionError e) {
                iterator.remove();
                continue;
            }
            boolean hasAny = eventQualifiers.size() == 0;
            if (hasAny) continue;
            Set<String> requiredQualifiers = EventInjectionPointLogic.getAnnotationFqns(eventQualifiers);
            if (!parameterAnnotations.containsAll(requiredQualifiers)) {
                iterator.remove();
                continue;
            }
            if (this.checkQualifierMembers(eventQualifiers, annotationMirrors)) continue;
            iterator.remove();
        }
    }

    private boolean checkQualifierMembers(List<AnnotationMirror> eventQualifiers, List<? extends AnnotationMirror> observerAnnotations) {
        for (AnnotationMirror annotation : eventQualifiers) {
            Set<ExecutableElement> qualifierMembers;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
            if (this.checkMember(elementValues, qualifierMembers = MemberBindingFilter.collectBindingMembers(annotation, this.getModel()), observerAnnotations)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMember(Map<? extends ExecutableElement, ? extends AnnotationValue> memberValues, Set<ExecutableElement> qualifierMembers, List<? extends AnnotationMirror> observerAnnotations) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : memberValues.entrySet()) {
            ExecutableElement execElement = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!qualifierMembers.contains(execElement)) continue;
            Element annotationElement = execElement.getEnclosingElement();
            if (!(annotationElement instanceof TypeElement)) {
                return false;
            }
            String annotationName = ((TypeElement)annotationElement).getQualifiedName().toString();
            AnnotationMirror annotationMirror = (AnnotationMirror)this.getModel().getHelper().getAnnotationsByType(observerAnnotations).get(annotationName);
            if (annotationMirror == null) {
                return false;
            }
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            AnnotationValue valueForType = elementValues.get(execElement);
            if (MemberCheckerFilter.equals(value, valueForType)) continue;
            return false;
        }
        return true;
    }

    private Triple<VariableElement, Integer, Void> doGetObserverParameter(ExecutableElement element) {
        List<? extends VariableElement> parameters = element.getParameters();
        int index = 0;
        for (VariableElement variableElement : parameters) {
            List<? extends AnnotationMirror> allAnnotationMirrors = this.getCompilationController().getElements().getAllAnnotationMirrors(variableElement);
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                TypeElement annotation = (TypeElement)annotationType.asElement();
                if (annotation == null || !"javax.enterprise.event.Observes".contentEquals(annotation.getQualifiedName()) && !"jakarta.enterprise.event.Observes".contentEquals(annotation.getQualifiedName())) continue;
                return new Triple<VariableElement, Integer, Object>(variableElement, index, null);
            }
            ++index;
        }
        return null;
    }

    private void filterParametersByType(Map<Element, TypeMirror> parameterTypesMap, TypeMirror type) {
        AbstractAssignabilityChecker checker = AbstractAssignabilityChecker.get(AbstractAssignabilityChecker.AssignabilityType.EVENT);
        Iterator<Map.Entry<Element, TypeMirror>> iterator = parameterTypesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Element, TypeMirror> entry = iterator.next();
            TypeMirror typeMirror = entry.getValue();
            boolean assignable = this.isAssignable(type, typeMirror, checker);
            if (assignable) continue;
            iterator.remove();
        }
    }

    private void filterEventInjectionsByType(List<VariableElement> eventInjectionPoints, TypeMirror parameterType) {
        AbstractAssignabilityChecker checker = AbstractAssignabilityChecker.get(AbstractAssignabilityChecker.AssignabilityType.EVENT);
        Iterator<VariableElement> iterator = eventInjectionPoints.iterator();
        while (iterator.hasNext()) {
            boolean assignable;
            VariableElement injection = iterator.next();
            TypeMirror type = this.getParameterType(injection, null, EVENT_INTERFACE_JAKARTA);
            if (type == null) {
                type = this.getParameterType(injection, null, EVENT_INTERFACE);
            }
            if (assignable = this.isAssignable(type, parameterType, checker)) continue;
            iterator.remove();
        }
    }

    private boolean isAssignable(TypeMirror subject, TypeMirror toType, AbstractAssignabilityChecker checker) {
        boolean isGeneric;
        if (subject == null) {
            return false;
        }
        boolean assignable = false;
        Element typeElement = this.getCompilationController().getTypes().asElement(toType);
        boolean bl = isGeneric = typeElement instanceof TypeElement && ((TypeElement)typeElement).getTypeParameters().size() != 0;
        if (!isGeneric && this.getCompilationController().getTypes().isAssignable(subject, toType)) {
            return true;
        }
        if (subject instanceof ReferenceType && toType instanceof ReferenceType) {
            checker.init((ReferenceType)toType, (ReferenceType)subject, this.getModel());
            assignable = checker.check();
        }
        return assignable;
    }

    private List<ObserverTriple> findObservesParameters() {
        LinkedList<ObserverTriple> result = new LinkedList<ObserverTriple>();
        CompilationController compilationController = this.getModel().getHelper().getCompilationController();
        TypeElement observesType = compilationController.getElements().getTypeElement("jakarta.enterprise.event.Observes");
        if (observesType == null) {
            observesType = compilationController.getElements().getTypeElement("javax.enterprise.event.Observes");
        }
        if (observesType == null) {
            return result;
        }
        ElementHandle observesHandle = ElementHandle.create((Element)observesType);
        Set elementHandles = compilationController.getClasspathInfo().getClassIndex().getElements(observesHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        for (ElementHandle elementHandle : elementHandles) {
            TypeElement resolvedType = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
            List<? extends Element> enclosedElements = resolvedType.getEnclosedElements();
            List<ExecutableElement> methods = ElementFilter.methodsIn(enclosedElements);
            for (ExecutableElement method : methods) {
                List<? extends VariableElement> parameters = method.getParameters();
                int index = 0;
                for (VariableElement variableElement : parameters) {
                    List<? extends AnnotationMirror> annotationMirrors = compilationController.getElements().getAllAnnotationMirrors(variableElement);
                    if (this.getModel().getHelper().hasAnnotation(annotationMirrors, "javax.enterprise.event.Observes") || this.getModel().getHelper().hasAnnotation(annotationMirrors, "jakarta.enterprise.event.Observes")) {
                        result.add(new ObserverTriple(method, variableElement, index));
                    }
                    ++index;
                }
            }
        }
        return result;
    }

    static Set<String> getAnnotationFqns(Collection<? extends AnnotationMirror> annotations) {
        HashSet<String> annotationFqns = new HashSet<String>();
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Element annotationElement = annotationType.asElement();
            TypeElement annotation = (TypeElement)annotationElement;
            if (annotation == null) continue;
            annotationFqns.add(annotation.getQualifiedName().toString());
        }
        return annotationFqns;
    }

    private class ObserverTriple
    extends Triple<ExecutableElement, VariableElement, Integer> {
        ObserverTriple(ExecutableElement method, VariableElement parameter, Integer index) {
            super(method, parameter, index);
        }
    }

    static class Triple<T, R, S> {
        private T myFirst;
        private R mySecond;
        private S myThird;

        Triple(T t, R r, S s) {
            this.myFirst = t;
            this.mySecond = r;
            this.myThird = s;
        }

        T getFirst() {
            return this.myFirst;
        }

        R getSecond() {
            return this.mySecond;
        }

        S getThird() {
            return this.myThird;
        }
    }
}

