/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.android.AndroidPlatform;
import org.netbeans.modules.cordova.platforms.android.Bundle;
import org.netbeans.modules.cordova.platforms.spi.BuildPerformer;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class AndroidActionProvider
implements ActionProvider {
    private final Project p;
    private static final Logger LOGGER = Logger.getLogger(AndroidActionProvider.class.getName());

    public AndroidActionProvider(Project p) {
        this.p = p;
    }

    public String[] getSupportedActions() {
        return new String[]{"build", "clean", "run", "run.single", "rebuild"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        String javacFileName;
        final BuildPerformer build = (BuildPerformer)Lookup.getDefault().lookup(BuildPerformer.class);
        String checkAndroid = AndroidActionProvider.checkAndroid();
        if (checkAndroid != null) {
            NotifyDescriptor not = new NotifyDescriptor((Object)checkAndroid, Bundle.ERR_Title(), 2, 0, null, null);
            Object value = DialogDisplayer.getDefault().notify(not);
            if (NotifyDescriptor.CANCEL_OPTION != value) {
                OptionsDisplayer.getDefault().open("Html5/MobilePlatforms");
            }
            return;
        }
        String jdkHome = System.getProperty("jdk.home");
        NotifyDescriptor.Message notJDK = new NotifyDescriptor.Message((Object)Bundle.ERR_NO_JDK(), 0);
        if (jdkHome == null || jdkHome.isEmpty()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notJDK);
            return;
        }
        Object jdkHomeFO = FileUtil.toFileObject((File)new File(jdkHome, "bin"));
        FileObject javacFO = jdkHomeFO.getFileObject(javacFileName = Utilities.isWindows() ? "javac.exe" : "javac");
        if (javacFO == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notJDK);
            return;
        }
        if ("build".equals(command) || "clean".equals(command) || "rebuild".equals(command)) {
            try {
                switch (command) {
                    case "build": {
                        build.perform("build-android", this.p);
                        break;
                    }
                    case "clean": {
                        build.perform("clean-android", this.p);
                        break;
                    }
                    case "rebuild": {
                        build.perform("rebuild-android", this.p);
                    }
                }
            }
            catch (UnsupportedOperationException ex) {
                NotifyDescriptor.Message not = new NotifyDescriptor.Message((Object)Bundle.ERR_NO_Cordova(), 0);
                Object value = DialogDisplayer.getDefault().notify((NotifyDescriptor)not);
                return;
            }
        } else if ("run".equals(command) || "run.single".equals(command)) {
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){
                final /* synthetic */ AndroidActionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    String checkDevices = AndroidActionProvider.checkDevices(this.this$0.p);
                    while (checkDevices != null) {
                        Object[] objectArray;
                        String string = Bundle.ERR_Title();
                        if (checkDevices.equals(Bundle.ERR_RunAndroidEmulator())) {
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = DialogDescriptor.OK_OPTION;
                            objectArray2[1] = DialogDescriptor.CANCEL_OPTION;
                            objectArray = objectArray2;
                            objectArray2[2] = Bundle.LBL_AvdManager();
                        } else {
                            objectArray = null;
                        }
                        NotifyDescriptor not = new NotifyDescriptor((Object)checkDevices, string, -1, 0, objectArray, null);
                        Object value = DialogDisplayer.getDefault().notify(not);
                        if (NotifyDescriptor.CANCEL_OPTION == value || checkDevices.equals(Bundle.ERR_AdbNotFound())) {
                            return;
                        }
                        if (Bundle.LBL_AvdManager().equals(value)) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    AndroidPlatform.getDefault().manageDevices();
                                }
                            });
                            return;
                        }
                        checkDevices = AndroidActionProvider.checkDevices(this.this$0.p);
                    }
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                build.perform("sim-android", this.this$1.this$0.p);
                            }
                            catch (UnsupportedOperationException ex) {
                                NotifyDescriptor not = new NotifyDescriptor((Object)Bundle.ERR_NO_Cordova(), Bundle.ERR_Title(), 2, 0, null, null);
                                Object value = DialogDisplayer.getDefault().notify(not);
                                if (NotifyDescriptor.CANCEL_OPTION != value) {
                                    OptionsDisplayer.getDefault().open("Html5/MobilePlatforms");
                                }
                                return;
                            }
                            catch (IllegalStateException ex) {
                                StatusDisplayer.getDefault().setStatusText(ex.getMessage());
                            }
                        }
                    });
                }
            }, (String)Bundle.LBL_CheckingDevice(), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
        }
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return true;
    }

    static String checkDevices(Project p) {
        if (!AndroidPlatform.getDefault().adbCommandExists()) {
            return Bundle.ERR_AdbNotFound();
        }
        ProjectBrowserProvider provider = (ProjectBrowserProvider)p.getLookup().lookup(ProjectBrowserProvider.class);
        WebBrowser activeConfiguration = provider.getActiveBrowser();
        try {
            if (activeConfiguration.getId().endsWith("_1")) {
                for (Device dev : AndroidPlatform.getDefault().getConnectedDevices()) {
                    if (dev.isEmulator()) continue;
                    return null;
                }
                return Bundle.ERR_ConnectAndroidDevice();
            }
            for (Device dev : AndroidPlatform.getDefault().getConnectedDevices()) {
                if (!dev.isEmulator()) continue;
                return null;
            }
            return Bundle.ERR_RunAndroidEmulator();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Bundle.ERR_Unknown();
        }
    }

    static String checkAndroid() {
        if (!AndroidPlatform.getDefault().isReady()) {
            return Bundle.ERR_AndroidNotConfigured();
        }
        return null;
    }
}

