/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ThreadInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.management.openmbean.CompositeData;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.openide.util.Lookup;

public class LoadedSnapshot {
    private static final Logger LOGGER = Logger.getLogger(LoadedSnapshot.class.getName());
    public static final int SNAPSHOT_TYPE_UNKNOWN = 0;
    public static final int SNAPSHOT_TYPE_CPU = 1;
    public static final int SNAPSHOT_TYPE_CODEFRAGMENT = 2;
    public static final int SNAPSHOT_TYPE_MEMORY_ALLOCATIONS = 4;
    public static final int SNAPSHOT_TYPE_MEMORY_LIVENESS = 8;
    public static final int SNAPSHOT_TYPE_MEMORY_SAMPLED = 16;
    public static final int SNAPSHOT_TYPE_CPU_JDBC = 32;
    public static final int SNAPSHOT_TYPE_MEMORY = 28;
    public static final String PROFILER_FILE_MAGIC_STRING = "nBpRoFiLeR";
    private static final byte SNAPSHOT_FILE_VERSION_MAJOR = 1;
    private static final byte SNAPSHOT_FILE_VERSION_MINOR = 2;
    private File file;
    private ProfilingSettings settings;
    private Lookup.Provider project = null;
    private ResultsSnapshot snapshot;
    private String userComments = "";
    private boolean saved = false;

    public LoadedSnapshot(ResultsSnapshot snapshot, ProfilingSettings settings, File file, Lookup.Provider project) {
        if (snapshot == null) {
            throw new IllegalArgumentException();
        }
        if (settings == null) {
            throw new IllegalArgumentException();
        }
        this.snapshot = snapshot;
        this.settings = settings;
        this.file = file;
        this.project = project;
    }

    private LoadedSnapshot() {
    }

    public void setFile(File file) {
        this.file = file;
        this.saved = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SnapshotResultsWindow.hasSnapshotWindow(LoadedSnapshot.this)) {
                    SnapshotResultsWindow.get(LoadedSnapshot.this).refreshTabName();
                }
            }
        });
    }

    public File getFile() {
        return this.file;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setUserComments(String userComments) {
        if (!this.userComments.equals(userComments)) {
            this.userComments = userComments;
            this.setSaved(false);
        }
    }

    public String getUserComments() {
        return this.userComments;
    }

    public ProfilingSettings getSettings() {
        return this.settings;
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public int getType() {
        if (this.snapshot instanceof CPUResultsSnapshot) {
            return 1;
        }
        if (this.snapshot instanceof CodeRegionResultsSnapshot) {
            return 2;
        }
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            return 8;
        }
        if (this.snapshot instanceof AllocMemoryResultsSnapshot) {
            return 4;
        }
        if (this.snapshot instanceof SampledMemoryResultsSnapshot) {
            return 16;
        }
        if (this.snapshot instanceof JdbcResultsSnapshot) {
            return 32;
        }
        throw new IllegalStateException(Bundle.LoadedSnapshot_IllegalSnapshotDataMsg());
    }

    public static LoadedSnapshot loadSnapshot(DataInputStream dis) throws IOException {
        dis.mark(100);
        try {
            LoadedSnapshot ls = new LoadedSnapshot();
            if (ls.load(dis)) {
                return ls;
            }
            return null;
        }
        catch (IOException ex) {
            if (Bundle.LoadedSnapshot_InvalidSnapshotFileMsg().equals(ex.getMessage())) {
                dis.reset();
                return LoadedSnapshot.loadSnapshotFromStackTraces(dis);
            }
            throw ex;
        }
    }

    private static LoadedSnapshot loadSnapshotFromStackTraces(DataInputStream dis) throws IOException {
        CPUResultsSnapshot snapshot;
        SamplesInputStream is = new SamplesInputStream(dis);
        StackTraceSnapshotBuilder builder = new StackTraceSnapshotBuilder();
        ThreadsSample sample = is.readSample();
        long startTime = sample.getTime() / 1000000L;
        while (sample != null) {
            builder.addStacktrace(sample.getTinfos(), sample.getTime());
            sample = is.readSample();
        }
        is.close();
        is = null;
        try {
            snapshot = builder.createSnapshot(startTime);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException ex) {
            throw new IOException(ex);
        }
        return new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
    }

    public void setProject(Lookup.Provider project) {
        this.project = project;
    }

    static void writeToStream(CPUResultsSnapshot snapshot, DataOutputStream dos) throws IOException {
        LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
        loadedSnapshot.save(dos);
    }

    public void save(DataOutputStream dos) throws IOException, OutOfMemoryError {
        Properties props = new Properties();
        this.settings.store((Map)props);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("save properties: --------------------------------------------------------------");
            LOGGER.finest(this.settings.debug());
            LOGGER.finest("-------------------------------------------------------------------------------");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000000);
        DataOutputStream snapshotDataStream = new DataOutputStream(baos);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream(10000);
        DataOutputStream settingsDataStream = new DataOutputStream(baos2);
        try {
            this.snapshot.writeToStream(snapshotDataStream);
            snapshotDataStream.flush();
            props.store(settingsDataStream, "");
            settingsDataStream.flush();
            byte[] snapshotBytes = baos.toByteArray();
            byte[] compressedBytes = new byte[snapshotBytes.length];
            Deflater d = new Deflater();
            d.setInput(snapshotBytes);
            d.finish();
            int compressedLen = d.deflate(compressedBytes);
            int uncompressedLen = snapshotBytes.length;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("save version:1.2");
                LOGGER.finest("save type:" + this.getType());
                LOGGER.finest("length of uncompressed snapshot data:" + uncompressedLen);
                LOGGER.finest("save length of snapshot data:" + compressedLen);
                LOGGER.finest("length of settings data:" + baos2.size());
            }
            dos.writeBytes(PROFILER_FILE_MAGIC_STRING);
            dos.writeByte(1);
            dos.writeByte(2);
            dos.writeInt(this.getType());
            dos.writeInt(compressedLen);
            dos.writeInt(uncompressedLen);
            dos.write(compressedBytes, 0, compressedLen);
            dos.writeInt(baos2.size());
            dos.write(baos2.toByteArray());
            dos.writeUTF(this.userComments);
        }
        catch (OutOfMemoryError e) {
            baos = null;
            snapshotDataStream = null;
            baos2 = null;
            settingsDataStream = null;
            throw e;
        }
        finally {
            if (snapshotDataStream != null) {
                snapshotDataStream.close();
            }
            if (settingsDataStream != null) {
                settingsDataStream.close();
            }
        }
    }

    public String toString() {
        String snapshotString = "snapshot = " + this.snapshot.toString();
        String fileString = "file = " + (this.file == null ? "null" : this.file.toString());
        String projectString = "project = " + (this.project == null ? "null" : ProjectUtilities.getDisplayName((Lookup.Provider)this.project));
        return "Loaded Results Snapshot, " + snapshotString + ", " + projectString + ", " + fileString;
    }

    private static String getCorruptedMessage(IOException e) {
        String message = e.getMessage();
        if (message == null) {
            if (e instanceof EOFException) {
                return Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_SnapshotFileShortMsg());
            }
            return Bundle.LoadedSnapshot_SnapshotFileCorrupted();
        }
        return Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(message);
    }

    private boolean load(DataInputStream dis) throws IOException {
        try {
            Properties props = new Properties();
            this.settings = new ProfilingSettings();
            byte[] magicArray = new byte[PROFILER_FILE_MAGIC_STRING.length()];
            int len = dis.read(magicArray);
            if (len != PROFILER_FILE_MAGIC_STRING.length() || !PROFILER_FILE_MAGIC_STRING.equals(new String(magicArray))) {
                throw new IOException(Bundle.LoadedSnapshot_InvalidSnapshotFileMsg());
            }
            byte majorVersion = dis.readByte();
            byte minorVersion = dis.readByte();
            if (majorVersion > 1) {
                throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_UnsupportedSnapshotVersionMsg()));
            }
            int type = dis.readInt();
            if (type == -1) {
                throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_WrongSnapshotTypeMsg()));
            }
            int compressedDataLen = dis.readInt();
            int uncompressedDataLen = dis.readInt();
            InflaterInputStream zipStream = new InflaterInputStream(new SubInputStream(dis, compressedDataLen));
            switch (type) {
                case 1: {
                    this.snapshot = new CPUResultsSnapshot();
                    break;
                }
                case 2: {
                    this.snapshot = new CodeRegionResultsSnapshot();
                    break;
                }
                case 4: {
                    this.snapshot = new AllocMemoryResultsSnapshot();
                    break;
                }
                case 8: {
                    this.snapshot = new LivenessMemoryResultsSnapshot();
                    break;
                }
                case 16: {
                    this.snapshot = new SampledMemoryResultsSnapshot();
                    break;
                }
                case 32: {
                    this.snapshot = new JdbcResultsSnapshot();
                    break;
                }
                default: {
                    throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_UnrecognizedSnapshotTypeMsg()));
                }
            }
            BufferedInputStream bufBais = new BufferedInputStream(zipStream);
            DataInputStream dataDis = new DataInputStream(bufBais);
            try {
                this.snapshot.readFromStream(dataDis);
            }
            catch (IOException e) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(e));
            }
            int settingsLen = dis.readInt();
            byte[] settingsBytes = new byte[settingsLen];
            int readLen2 = dis.read(settingsBytes);
            if (settingsLen != readLen2) {
                throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_CannotReadSettingsDataMsg()));
            }
            if (minorVersion >= 2) {
                this.userComments = dis.readUTF();
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load version:" + majorVersion + "." + minorVersion);
                LOGGER.finest("load type:" + type);
                LOGGER.finest("load length of snapshot data:" + compressedDataLen);
                LOGGER.finest("uncompressed length of snapshot data:" + uncompressedDataLen);
                LOGGER.finest("load length of settings data:" + settingsLen);
            }
            ByteArrayInputStream bais2 = new ByteArrayInputStream(settingsBytes);
            try (DataInputStream settingsDis = new DataInputStream(bais2);){
                props.load(settingsDis);
            }
            this.settings.load((Map)props);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load properties: --------------------------------------------------------------");
                LOGGER.finest(this.settings.debug());
                LOGGER.finest("-------------------------------------------------------------------------------");
            }
        }
        catch (OutOfMemoryError e) {
            ProfilerDialogs.displayError((String)Bundle.LoadedSnapshot_OutOfMemoryLoadingMsg());
            return false;
        }
        return true;
    }

    static class SamplesInputStream {
        static final String ID = "NPSS";
        static final int MAX_SUPPORTED_VERSION = 2;
        int version;
        int samples;
        long lastTimestamp;
        ObjectInputStream in;
        Map<Long, ThreadInfo> threads;

        SamplesInputStream(File file) throws IOException {
            this(new FileInputStream(file));
        }

        SamplesInputStream(InputStream is) throws IOException {
            this.readHeader(is);
            this.in = new ObjectInputStream(new GZIPInputStream(is));
            if (this.version > 1) {
                this.samples = this.in.readInt();
                this.lastTimestamp = this.in.readLong();
            }
            this.threads = new HashMap<Long, ThreadInfo>(128);
        }

        int getSamples() {
            return this.samples;
        }

        long getLastTimestamp() {
            return this.lastTimestamp;
        }

        ThreadsSample readSample() throws IOException {
            int i;
            long time;
            try {
                time = this.in.readLong();
            }
            catch (EOFException ex) {
                return null;
            }
            HashMap<Long, ThreadInfo> newThreads = new HashMap<Long, ThreadInfo>(this.threads.size());
            int sameThreads = this.in.readInt();
            for (i = 0; i < sameThreads; ++i) {
                Long tid = this.in.readLong();
                ThreadInfo oldThread = this.threads.get(tid);
                assert (oldThread != null);
                newThreads.put(tid, oldThread);
            }
            ThreadInfo[] infos = new ThreadInfo[this.in.readInt()];
            for (i = 0; i < infos.length; ++i) {
                CompositeData infoData;
                try {
                    infoData = (CompositeData)this.in.readObject();
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                ThreadInfo thread = ThreadInfo.from(infoData);
                newThreads.put(thread.getThreadId(), thread);
            }
            this.threads = newThreads;
            return new ThreadsSample(time, this.threads.values());
        }

        void close() throws IOException {
            this.in.close();
        }

        private void readHeader(InputStream is) throws IOException {
            byte[] idarr = new byte[ID.length()];
            is.read(idarr);
            String id = new String(idarr);
            if (!ID.equals(id)) {
                throw new IOException("Invalid header " + id){

                    @Override
                    public String getLocalizedMessage() {
                        return Bundle.MSG_NotNPSSSnapshot();
                    }
                };
            }
            this.version = is.read();
            if (this.version > 2) {
                throw new IOException("NPSS file version " + this.version + " is not supported"){

                    @Override
                    public String getLocalizedMessage() {
                        return Bundle.MSG_UnsupportedSnapshotVersion();
                    }
                };
            }
        }
    }

    static final class ThreadsSample {
        private final long time;
        private final ThreadInfo[] tinfos;

        ThreadsSample(long t, Collection<ThreadInfo> tis) {
            this.time = t;
            this.tinfos = tis.toArray(new ThreadInfo[0]);
        }

        long getTime() {
            return this.time;
        }

        ThreadInfo[] getTinfos() {
            return this.tinfos;
        }
    }

    private static class SubInputStream
    extends FilterInputStream {
        private int limit;

        private SubInputStream(InputStream is, int l) {
            super(is);
            this.limit = l;
        }

        @Override
        public int available() throws IOException {
            int avail = super.available();
            return Math.min(avail, this.limit);
        }

        @Override
        public int read() throws IOException {
            if (this.limit == 0) {
                return -1;
            }
            --this.limit;
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.limit == 0) {
                return -1;
            }
            int realLen = Math.min(len, this.limit);
            int readBytes = super.read(b, off, realLen);
            this.limit -= readBytes;
            return readBytes;
        }

        @Override
        public long skip(long n) throws IOException {
            long skip = Math.min(n, (long)this.limit);
            long skipped = super.skip(skip);
            this.limit = (int)((long)this.limit - skipped);
            return skipped;
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

