/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.JPDAMethodChooserFactory;
import org.netbeans.modules.debugger.jpda.actions.StepIntoNextMethod;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;

public class StepIntoActionProvider
extends JPDADebuggerActionProvider {
    public static final String SS_STEP_OUT = "SS_ACTION_STEPOUT";
    public static final String ACTION_SMART_STEP_INTO = "smartStepInto";
    private final StepIntoNextMethod stepInto;
    private JPDAMethodChooserFactory mcf;
    static final Map<ContextProvider, Reference<StepIntoActionProvider>> instanceByContext = new WeakHashMap<ContextProvider, Reference<StepIntoActionProvider>>();

    public StepIntoActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.stepInto = new StepIntoNextMethod(contextProvider);
        this.setProviderToDisableOnLazyAction(this);
        instanceByContext.put(contextProvider, new WeakReference<StepIntoActionProvider>(this));
        this.mcf = (JPDAMethodChooserFactory)contextProvider.lookupFirst(null, JPDAMethodChooserFactory.class);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO));
    }

    public void doAction(Object action) {
        this.runAction(action, true, null, null, null);
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(action, new Runnable(){
            final /* synthetic */ StepIntoActionProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.runAction(action, true, null, null, null);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    void runAction(Object action, boolean doResume, Lock lock, Boolean steppingFromFilteredLocation, Boolean steppingFromCompoundFilteredLocation) {
        if (ActionsManager.ACTION_STEP_INTO.equals(action) && this.doMethodSelection()) {
            return;
        }
        this.stepInto.runAction(action, doResume, lock, steppingFromFilteredLocation, steppingFromCompoundFilteredLocation);
    }

    @Override
    protected void checkEnabled(int debuggerState) {
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            this.setEnabled(i.next(), debuggerState == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    public boolean doMethodSelection() {
        if (this.mcf == null) {
            return false;
        }
        if (this.mcf.cancelUI()) {
            return true;
        }
        String[] methodPtr = new String[1];
        String[] urlPtr = new String[1];
        int[] linePtr = new int[1];
        boolean retrieved = this.retievePosition(methodPtr, urlPtr, linePtr);
        if (!retrieved) {
            return false;
        }
        int methodLine = linePtr[0];
        String url = urlPtr[0];
        if (methodLine < 0 || url == null || !url.endsWith(".java")) {
            return false;
        }
        JPDAThreadImpl ct = (JPDAThreadImpl)this.debugger.getCurrentThread();
        ThreadReference threadReference = ct.getThreadReference();
        ReferenceType clazz = null;
        try {
            if (ThreadReferenceWrapper.frameCount(threadReference) < 1) {
                return false;
            }
            clazz = LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        if (clazz != null) {
            if (this.debugger.getState() == 4) {
                return false;
            }
            return this.mcf.initChooserUI(this.debugger, url, clazz, methodLine);
        }
        return false;
    }

    private boolean retievePosition(String[] methodPtr, String[] urlPtr, int[] linePtr) {
        String url;
        CallStackFrame[] topFramePtr;
        JPDAThread t = this.debugger.getCurrentThread();
        try {
            topFramePtr = t.getCallStack(0, 1);
        }
        catch (AbsentInformationException ex) {
            return false;
        }
        if (topFramePtr.length < 1) {
            return false;
        }
        CallStackFrame csf = topFramePtr[0];
        String stratum = this.debugger.getSession().getCurrentLanguage();
        int lineNumber = csf.getLineNumber(stratum);
        if (lineNumber < 1) {
            return false;
        }
        linePtr[0] = lineNumber;
        try {
            url = this.debugger.getEngineContext().getURL(csf, stratum);
        }
        catch (InternalExceptionWrapper ex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return false;
        }
        if (url == null) {
            return false;
        }
        urlPtr[0] = url;
        methodPtr[0] = t.getMethodName();
        return true;
    }
}

