/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.api;

import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.visual.RuleEditorPanel;
import org.netbeans.modules.css.visual.api.DeclarationInfo;
import org.netbeans.modules.css.visual.api.ViewMode;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public final class RuleEditorController {
    private static final Logger LOG = Logger.getLogger("rule.editor");
    private RuleEditorPanel peer;

    public static RuleEditorController createInstance() {
        return new RuleEditorController();
    }

    private RuleEditorController() {
    }

    private RuleEditorController(RuleEditorPanel peer) {
        this.peer = peer;
    }

    public JComponent getRuleEditorComponent() {
        return this.getRuleEditorPanel();
    }

    synchronized RuleEditorPanel getRuleEditorPanel() {
        if (this.peer == null) {
            this.peer = new RuleEditorPanel();
        }
        return this.peer;
    }

    public void setModel(final Model cssSourceModel) {
        LOG.log(Level.FINER, "setModel({0}) called by {1}", new Object[]{cssSourceModel, Thread.currentThread().getStackTrace()[2].toString()});
        Parameters.notNull((CharSequence)"cssSourceModel", (Object)cssSourceModel);
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ RuleEditorController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getRuleEditorPanel().setModel(cssSourceModel);
            }
        });
    }

    public void setRule(final Rule rule) {
        LOG.log(Level.FINER, "setRule({0}) called by {1}", new Object[]{rule, Thread.currentThread().getStackTrace()[2].toString()});
        Parameters.notNull((CharSequence)"rule", (Object)rule);
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ RuleEditorController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getRuleEditorPanel().setRule(rule);
            }
        });
    }

    public void setNoRuleState() {
        LOG.log(Level.FINER, "setNoRuleState() called by {0}", new Object[]{Thread.currentThread().getStackTrace()[2].toString()});
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RuleEditorController.this.getRuleEditorPanel().setNoRuleState();
            }
        });
    }

    public void setDeclarationInfo(final PropertyDeclaration declaration, final DeclarationInfo declarationInfo) {
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ RuleEditorController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getRuleEditorPanel().setDeclarationInfo(declaration, declarationInfo);
            }
        });
    }

    public void setMessage(final String message) {
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ RuleEditorController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getRuleEditorPanel().setMessage(message);
            }
        });
    }

    public void setViewMode(ViewMode viewMode) {
        this.getRuleEditorPanel().setViewMode(viewMode);
    }

    public void addRuleEditorListener(PropertyChangeListener listener) {
        this.getRuleEditorPanel().addRuleEditorListener(listener);
    }

    public void removeRuleEditorListener(PropertyChangeListener listener) {
        this.getRuleEditorPanel().removeRuleEditorListener(listener);
    }

    public static enum PropertyNames {
        MODEL_SET,
        RULE_SET;

    }
}

