/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDedicatedVmHostsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String availabilityDomain;
    private LifecycleState lifecycleState;
    private String displayName;
    private String instanceShapeName;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Float remainingMemoryInGBsGreaterThanOrEqualTo;
    private Float remainingOcpusGreaterThanOrEqualTo;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInstanceShapeName() {
        return this.instanceShapeName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Float getRemainingMemoryInGBsGreaterThanOrEqualTo() {
        return this.remainingMemoryInGBsGreaterThanOrEqualTo;
    }

    public Float getRemainingOcpusGreaterThanOrEqualTo() {
        return this.remainingOcpusGreaterThanOrEqualTo;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).availabilityDomain(this.availabilityDomain).lifecycleState(this.lifecycleState).displayName(this.displayName).instanceShapeName(this.instanceShapeName).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortBy(this.sortBy).sortOrder(this.sortOrder).remainingMemoryInGBsGreaterThanOrEqualTo(this.remainingMemoryInGBsGreaterThanOrEqualTo).remainingOcpusGreaterThanOrEqualTo(this.remainingOcpusGreaterThanOrEqualTo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",instanceShapeName=").append(String.valueOf(this.instanceShapeName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",remainingMemoryInGBsGreaterThanOrEqualTo=").append(String.valueOf(this.remainingMemoryInGBsGreaterThanOrEqualTo));
        sb.append(",remainingOcpusGreaterThanOrEqualTo=").append(String.valueOf(this.remainingOcpusGreaterThanOrEqualTo));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDedicatedVmHostsRequest)) {
            return false;
        }
        ListDedicatedVmHostsRequest other = (ListDedicatedVmHostsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.instanceShapeName, other.instanceShapeName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.remainingMemoryInGBsGreaterThanOrEqualTo, other.remainingMemoryInGBsGreaterThanOrEqualTo) && Objects.equals(this.remainingOcpusGreaterThanOrEqualTo, other.remainingOcpusGreaterThanOrEqualTo);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.instanceShapeName == null ? 43 : this.instanceShapeName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.remainingMemoryInGBsGreaterThanOrEqualTo == null ? 43 : this.remainingMemoryInGBsGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.remainingOcpusGreaterThanOrEqualTo == null ? 43 : this.remainingOcpusGreaterThanOrEqualTo.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDedicatedVmHostsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String availabilityDomain = null;
        private LifecycleState lifecycleState = null;
        private String displayName = null;
        private String instanceShapeName = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Float remainingMemoryInGBsGreaterThanOrEqualTo = null;
        private Float remainingOcpusGreaterThanOrEqualTo = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder instanceShapeName(String instanceShapeName) {
            this.instanceShapeName = instanceShapeName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder remainingMemoryInGBsGreaterThanOrEqualTo(Float remainingMemoryInGBsGreaterThanOrEqualTo) {
            this.remainingMemoryInGBsGreaterThanOrEqualTo = remainingMemoryInGBsGreaterThanOrEqualTo;
            return this;
        }

        public Builder remainingOcpusGreaterThanOrEqualTo(Float remainingOcpusGreaterThanOrEqualTo) {
            this.remainingOcpusGreaterThanOrEqualTo = remainingOcpusGreaterThanOrEqualTo;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDedicatedVmHostsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.instanceShapeName(o.getInstanceShapeName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.remainingMemoryInGBsGreaterThanOrEqualTo(o.getRemainingMemoryInGBsGreaterThanOrEqualTo());
            this.remainingOcpusGreaterThanOrEqualTo(o.getRemainingOcpusGreaterThanOrEqualTo());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDedicatedVmHostsRequest build() {
            ListDedicatedVmHostsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDedicatedVmHostsRequest buildWithoutInvocationCallback() {
            ListDedicatedVmHostsRequest request = new ListDedicatedVmHostsRequest();
            request.compartmentId = this.compartmentId;
            request.availabilityDomain = this.availabilityDomain;
            request.lifecycleState = this.lifecycleState;
            request.displayName = this.displayName;
            request.instanceShapeName = this.instanceShapeName;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.remainingMemoryInGBsGreaterThanOrEqualTo = this.remainingMemoryInGBsGreaterThanOrEqualTo;
            request.remainingOcpusGreaterThanOrEqualTo = this.remainingOcpusGreaterThanOrEqualTo;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

