/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.codetemplate;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.twig.editor.completion.TwigCompletionContextFinder;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TwigCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private static final Logger LOGGER = Logger.getLogger(TwigCodeTemplateFilter.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(TwigCodeTemplateFilter.class);
    private volatile boolean accept = true;
    private final Future<Future<Void>> future;
    private final int offset;

    public TwigCodeTemplateFilter(final JTextComponent component, int offset) {
        this.offset = offset;
        this.future = RP.submit((Callable)new Callable<Future<Void>>(){
            final /* synthetic */ TwigCodeTemplateFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Future<Void> call() throws Exception {
                try {
                    return this.this$0.parseDocument(component.getDocument());
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
        });
    }

    private Future<Void> parseDocument(Document document) throws ParseException {
        return ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)document)), (UserTask)this);
    }

    public boolean accept(CodeTemplate template) {
        try {
            this.future.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return this.accept;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        assert (resultIterator != null);
        Parser.Result parserResult = resultIterator.getParserResult();
        if (parserResult instanceof TwigParserResult) {
            TwigCompletionContextFinder.CompletionContext completionContext = TwigCompletionContextFinder.find((TwigParserResult)parserResult, this.offset);
            this.accept = TwigCompletionContextFinder.CompletionContext.BLOCK.equals((Object)completionContext);
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new TwigCodeTemplateFilter(component, offset);
        }
    }
}

