/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.base.Filters;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ClassMemberFilters
extends Filters<ElementNode.Description> {
    private ClassMemberPanelUI ui;
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INNER_CLASSES = "show_inner_classes";
    private static final String SHOW_INHERITED = "show_inherited";

    ClassMemberFilters(ClassMemberPanelUI ui) {
        this.ui = ui;
    }

    @Override
    public Collection<ElementNode.Description> filter(Collection<? extends ElementNode.Description> original) {
        FiltersManager fm = this.getFiltersManager();
        boolean non_public = fm.isSelected(SHOW_NON_PUBLIC);
        boolean inner = fm.isSelected(SHOW_INNER_CLASSES);
        boolean statik = fm.isSelected(SHOW_STATIC);
        boolean fields = fm.isSelected(SHOW_FIELDS);
        boolean inherited = fm.isSelected(SHOW_INHERITED);
        ArrayList<ElementNode.Description> result = new ArrayList<ElementNode.Description>(original.size());
        for (ElementNode.Description description : original) {
            if (!inherited && description.isInherited || !non_public && !description.modifiers.contains((Object)Modifier.PUBLIC) && !description.isTopLevel || !statik && description.modifiers.contains((Object)Modifier.STATIC) || !fields && description.kind == ElementKind.FIELD || !inner && ClassMemberFilters.isInnerClass(description)) continue;
            result.add(description);
        }
        result.sort(this.isNaturalSort() ? ElementNode.Description.POSITION_COMPARATOR : ElementNode.Description.ALPHA_COMPARATOR);
        return result;
    }

    @Override
    public void sortUpdated() {
        this.ui.sort();
    }

    @Override
    protected void fqnUpdated() {
        this.ui.refresh();
    }

    @Override
    protected final FiltersManager createFilters() {
        FiltersDescription desc = new FiltersDescription();
        desc.addFilter(SHOW_INHERITED, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInherited"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInheritedTip"), false, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideInherited.png", (boolean)false), null);
        desc.addFilter(SHOW_FIELDS, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFields"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFieldsTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideFields.png", (boolean)false), null);
        desc.addFilter(SHOW_STATIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStatic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStaticTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideStatic.png", (boolean)false), null);
        desc.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublicTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideNonPublic.png", (boolean)false), null);
        desc.addFilter(SHOW_INNER_CLASSES, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInnerClasses"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInnerClassesTip"), true, ElementIcons.getElementIcon((ElementKind)ElementKind.CLASS, Collections.emptySet()), null);
        return FiltersDescription.createManager(desc);
    }

    private static boolean isInnerClass(@NonNull ElementNode.Description desc) {
        return (desc.kind.isClass() || desc.kind.isInterface()) && !desc.isTopLevel;
    }
}

