/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api;

import org.netbeans.modules.html.editor.lib.dtd.DTD;
import org.netbeans.modules.html.editor.lib.dtd.Registry;
import org.openide.util.NbBundle;

public enum HtmlVersion {
    HTML32(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_32"), "-//W3C//DTD HTML 3.2 Final//EN", null),
    HTML40_STRICT(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_40_STRICT"), "-//W3C//DTD HTML 4.0//EN", "http://www.w3.org/TR/REC-html40/strict.dtd"),
    HTML40_TRANSATIONAL(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_40_TRAN"), "-//W3C//DTD HTML 4.0 Transitional//EN", "http://www.w3.org/TR/REC-html40/loose.dtd"),
    HTML40_FRAMESET(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_40_FRAM"), "-//W3C//DTD HTML 4.0 Frameset//EN", "http://www.w3.org/TR/REC-html40/frameset.dtd"),
    HTML41_STRICT(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_401_STRICT"), "-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd"),
    HTML41_TRANSATIONAL(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_401_TRAN"), "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd"),
    HTML41_FRAMESET(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_401_FRAM"), "-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd"),
    HTML5(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_5"), null, null),
    XHTML5(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_X5"), null, null, null, "http://www.w3.org/1999/xhtml", true),
    XHTML10_STICT(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_X10_STRICT"), "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", null, "http://www.w3.org/1999/xhtml", true),
    XHTML10_TRANSATIONAL(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_X10_TRAN"), "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", null, "http://www.w3.org/1999/xhtml", true),
    XHTML10_FRAMESET(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_X10_FRAM"), "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", null, "http://www.w3.org/1999/xhtml", true),
    XHTML11(NbBundle.getMessage(HtmlVersion.class, (String)"MSG_HTML_VERSION_X11"), "-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/1999/xhtml", true);

    private static final String DOCTYPE_PREFIX = "<!DOCTYPE html PUBLIC \"";
    private static final String HTML5_DOCTYPE = "<!DOCTYPE html>";
    private static final String XHTML5_DOCTYPE = "<!DOCTYPE html>";
    private static final HtmlVersion DEFAULT_HTML_VERSION;
    private static final HtmlVersion DEFAULT_XHTML_VERSION;
    public static HtmlVersion DEFAULT_VERSION_UNIT_TESTS_OVERRIDE;
    private final String displayName;
    private final String publicID;
    private final String systemID;
    private final String fallbackPublicID;
    private final String defaultNamespace;
    private boolean isXhtml;

    public static HtmlVersion find(String publicId, String namespace) {
        if (publicId == null) {
            return XHTML5.getDefaultNamespace().equals(namespace) ? XHTML5 : HTML5;
        }
        for (HtmlVersion version : HtmlVersion.values()) {
            if (!publicId.equals(version.getPublicID())) continue;
            return version;
        }
        return null;
    }

    public static HtmlVersion getDefaultVersion() {
        return DEFAULT_VERSION_UNIT_TESTS_OVERRIDE != null ? DEFAULT_VERSION_UNIT_TESTS_OVERRIDE : DEFAULT_HTML_VERSION;
    }

    public static HtmlVersion getDefaultXhtmlVersion() {
        return DEFAULT_VERSION_UNIT_TESTS_OVERRIDE != null ? DEFAULT_VERSION_UNIT_TESTS_OVERRIDE : DEFAULT_XHTML_VERSION;
    }

    private HtmlVersion(String displayName, String publicID, String systemID) {
        this(displayName, publicID, systemID, null, null, false);
    }

    private HtmlVersion(String displayName, String publicID, String systemID, String fallbackPublicID, String defaultNamespace, boolean isXhtml) {
        this.publicID = publicID;
        this.systemID = systemID;
        this.defaultNamespace = defaultNamespace;
        this.isXhtml = isXhtml;
        this.fallbackPublicID = fallbackPublicID;
        this.displayName = displayName;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getSystemId() {
        return this.systemID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String getDoctypeDeclaration() {
        switch (this.ordinal()) {
            case 8: {
                return "<!DOCTYPE html>";
            }
            case 7: {
                return "<!DOCTYPE html>";
            }
        }
        StringBuilder b = new StringBuilder();
        b.append(DOCTYPE_PREFIX);
        b.append(this.getPublicID());
        b.append('\"');
        if (this.getSystemId() != null) {
            b.append(" \"");
            b.append(this.getSystemId());
            b.append('\"');
        }
        b.append('>');
        return b.toString();
    }

    public boolean isXhtml() {
        return this.isXhtml;
    }

    public DTD getDTD() {
        String publicid = this.fallbackPublicID != null ? this.fallbackPublicID : this.publicID;
        return Registry.getDTD(publicid, null);
    }

    static {
        DEFAULT_HTML_VERSION = HTML5;
        DEFAULT_XHTML_VERSION = XHTML5;
        DEFAULT_VERSION_UNIT_TESTS_OVERRIDE = null;
    }
}

