/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.InputService;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.QuickPickStep;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class DelegateMethodGenerator
extends CodeActionsProvider {
    private static final String GENERATE_DELEGATE_METHOD = "nbls.java.generate.delegate";
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String TYPE = "type";
    private static final String FIELDS = "fields";
    private static final String METHODS = "methods";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        TypeElement cls;
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = DelegateMethodGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || !typeElement.getKind().isClass()) {
            return Collections.emptyList();
        }
        Elements elements = info.getElements();
        Trees trees = info.getTrees();
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (Scope scope = trees.getScope(tp); scope != null && (cls = scope.getEnclosingClass()) != null; scope = scope.getEnclosingScope()) {
            DeclaredType type = (DeclaredType)cls.asType();
            for (VariableElement field : ElementFilter.fieldsIn(elements.getAllMembers(cls))) {
                TypeMirror fieldType = field.asType();
                if ("<error>".contentEquals(field.getSimpleName()) || fieldType.getKind().isPrimitive() || fieldType.getKind() == TypeKind.ARRAY || fieldType.getKind() == TypeKind.DECLARED && ((DeclaredType)fieldType).asElement() == cls || !trees.isAccessible(scope, field, type)) continue;
                QuickPickItem item = new QuickPickItem(DelegateMethodGenerator.createLabel((CompilationInfo)info, field));
                item.setUserData(new CodeActionsProvider.ElementData(field));
                fields.add(item);
            }
        }
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        fields.sort((f1, f2) -> f1.getLabel().compareTo(f2.getLabel()));
        String uri = Utils.toUri(info.getFileObject());
        QuickPickItem typeItem = new QuickPickItem(DelegateMethodGenerator.createLabel((CompilationInfo)info, typeElement));
        typeItem.setUserData(new CodeActionsProvider.ElementData(typeElement));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(URI, uri);
        data.put(OFFSET, offset);
        data.put(TYPE, typeItem);
        data.put(FIELDS, fields);
        return Collections.singletonList(this.createCodeAction(client, Bundle.DN_GenerateDelegateMethod(), "source.generate", null, "nbls.generate.code", Utils.encodeCommand(GENERATE_DELEGATE_METHOD, client.getNbCodeCapabilities()), data));
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(GENERATE_DELEGATE_METHOD);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        JsonObject data = (JsonObject)arguments.get(0);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            String uri = data.getAsJsonPrimitive(URI).getAsString();
            int offset = data.getAsJsonPrimitive(OFFSET).getAsInt();
            QuickPickItem type = (QuickPickItem)this.gson.fromJson(this.gson.toJson(data.get(TYPE)), QuickPickItem.class);
            List<QuickPickItem> fields = Arrays.asList((QuickPickItem[])this.gson.fromJson(data.get(FIELDS), QuickPickItem[].class));
            InputService.Registry inputServiceRegistry = (InputService.Registry)Lookup.getDefault().lookup(InputService.Registry.class);
            if (inputServiceRegistry != null) {
                int totalSteps = fields.size() > 1 ? 2 : 1;
                String inputId = inputServiceRegistry.registerInput(params -> {
                    CompletableFuture<Either> f = new CompletableFuture<Either>();
                    if (params.getStep() < totalSteps) {
                        Either<List<QuickPickItem>, String> fieldData = params.getData().get(FIELDS);
                        if (fieldData != null) {
                            List selectedFields = (List)fieldData.getLeft();
                            for (QuickPickItem field : fields) {
                                field.setPicked(selectedFields.contains(field));
                            }
                        }
                        f.complete(Either.forLeft((Object)new QuickPickStep(totalSteps, FIELDS, Bundle.DN_SelectDelegateMethodField(), fields)));
                    } else if (params.getStep() == totalSteps) {
                        Either<List<QuickPickItem>, String> fieldData = params.getData().get(FIELDS);
                        Either<List<QuickPickItem>, String> methodData = params.getData().get(METHODS);
                        QuickPickItem selectedField = (QuickPickItem)(fieldData != null ? (List)fieldData.getLeft() : fields).get(0);
                        ArrayList<QuickPickItem> methods = new ArrayList<QuickPickItem>();
                        try {
                            FileObject file = Utils.fromUri(uri);
                            JavaSource js = JavaSource.forFileObject((FileObject)file);
                            if (js == null) {
                                throw new IOException("Cannot get JavaSource for: " + uri);
                            }
                            js.runUserActionTask(info -> {
                                info.toPhase(JavaSource.Phase.RESOLVED);
                                final TypeElement origin = (TypeElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(type.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)info);
                                VariableElement field = (VariableElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(selectedField.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)info);
                                if (origin != null && field != null) {
                                    final ElementUtilities eu = info.getElementUtilities();
                                    final Trees trees = info.getTrees();
                                    final Scope scope = info.getTreeUtilities().scopeFor(offset);
                                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){
                                        final /* synthetic */ DelegateMethodGenerator this$0;
                                        {
                                            this.this$0 = this$0;
                                        }

                                        public boolean accept(Element e, TypeMirror type) {
                                            if (e.getKind() == ElementKind.METHOD && trees.isAccessible(scope, e, (DeclaredType)type)) {
                                                Element impl = eu.getImplementationOf((ExecutableElement)e, origin);
                                                return impl == null || !impl.getModifiers().contains((Object)Modifier.FINAL) && impl.getEnclosingElement() != origin;
                                            }
                                            return false;
                                        }
                                    };
                                    List selectedMethods = methodData != null ? (List)methodData.getLeft() : null;
                                    for (ExecutableElement method : ElementFilter.methodsIn(eu.getMembers(field.asType(), acceptor))) {
                                        QuickPickItem item = new QuickPickItem(String.format("%s.%s", field.getSimpleName().toString(), DelegateMethodGenerator.createLabel((CompilationInfo)info, method)));
                                        item.setUserData(new CodeActionsProvider.ElementData(method));
                                        if (selectedMethods != null && selectedMethods.contains(item)) {
                                            item.setPicked(true);
                                        }
                                        methods.add(item);
                                    }
                                } else {
                                    throw new IOException("Cannot resolve selected field: " + selectedField.getLabel());
                                }
                            }, true);
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            f.completeExceptionally(ex);
                        }
                        methods.sort((m1, m2) -> m1.getLabel().compareTo(m2.getLabel()));
                        f.complete(Either.forLeft((Object)new QuickPickStep(totalSteps, METHODS, null, Bundle.DN_SelectDelegateMethods(), true, methods)));
                    } else {
                        f.complete(null);
                    }
                    return f;
                });
                client.showMultiStepInput(new ShowMutliStepInputParams(inputId, Bundle.DN_GenerateDelegateMethod())).thenAccept(result -> {
                    Either selectedFields = (Either)result.get(FIELDS);
                    QuickPickItem selectedField = (QuickPickItem)(selectedFields != null ? (List)selectedFields.getLeft() : fields).get(0);
                    Either selectedMethods = (Either)result.get(METHODS);
                    try {
                        future.complete(selectedField != null && selectedMethods != null ? this.generate(uri, offset, selectedField, (List)selectedMethods.getLeft()) : null);
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        future.completeExceptionally(ex);
                    }
                });
            }
        }
        catch (JsonSyntaxException | IllegalArgumentException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private WorkspaceEdit generate(String uri, int offset, QuickPickItem selectedField, List<QuickPickItem> selectedMethods) throws IOException, IllegalArgumentException {
        FileObject file = Utils.fromUri(uri);
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            throw new IOException("Cannot get JavaSource for: " + uri);
        }
        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = wc.getTreeUtilities().pathFor(offset);
            tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                VariableElement field = (VariableElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(selectedField.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)wc);
                List methods = selectedMethods.stream().map(item -> {
                    CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                    return (ExecutableElement)data.resolve((CompilationInfo)wc);
                }).collect(Collectors.toList());
                org.netbeans.modules.java.editor.codegen.DelegateMethodGenerator.generateDelegatingMethods((WorkingCopy)wc, (TreePath)tp, (VariableElement)field, methods, (int)-1);
            }
        }));
        return edits.isEmpty() ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits));
    }
}

