/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.modules.java.hints.suggestions.ExpectedTypeResolver;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class TooStrongCast {
    /*
     * WARNING - void declaration
     */
    public static ErrorDescription broadTypeCast(HintContext ctx) {
        TreePath mitPath;
        ExpectedTypeResolver exp = new ExpectedTypeResolver(ctx.getPath(), ctx.getInfo());
        List<? extends TypeMirror> types = exp.scan(ctx.getPath(), null);
        TreePath parentExec = exp.getParentExecutable();
        int argIndex = -1;
        boolean varargs = false;
        CompilationInfo info = ctx.getInfo();
        ExecutableElement exec = null;
        TypeCastTree tct = (TypeCastTree)ctx.getPath().getLeaf();
        TreePath realExpressionPath = new TreePath(ctx.getPath(), tct.getExpression());
        TypeMirror casteeType = info.getTrees().getTypeMirror(realExpressionPath);
        if (parentExec != null) {
            exec = (ExecutableElement)info.getTrees().getElement(parentExec);
            if (exec == null) {
                return null;
            }
            argIndex = exp.getArgumentIndex();
            boolean bl = varargs = exec.isVarArgs() && argIndex == exec.getParameters().size() - 1;
            if (TooStrongCast.isPolymorphicSignature(info, parentExec)) {
                casteeType = info.getElements().getTypeElement("java.lang.Object").asType();
            }
        }
        if (types == null) {
            return null;
        }
        if (!Utilities.isValidValueType(casteeType)) {
            return null;
        }
        ExpressionTree castExp = tct.getExpression();
        while (castExp != null && castExp.getKind() == Tree.Kind.PARENTHESIZED) {
            castExp = ((ParenthesizedTree)castExp).getExpression();
        }
        if (castExp == null) {
            return null;
        }
        if (castExp.getKind() == Tree.Kind.METHOD_INVOCATION && TooStrongCast.isPolymorphicSignature(info, mitPath = new TreePath(ctx.getPath(), castExp))) {
            casteeType = info.getElements().getTypeElement("java.lang.Object").asType();
        }
        String lst = null;
        ArrayList<TypeMirror> filteredTypes = new ArrayList<TypeMirror>(types.size());
        TypeMirror castType = info.getTrees().getTypeMirror(new TreePath(ctx.getPath(), tct.getType()));
        if (!Utilities.isValidValueType(castType)) {
            return null;
        }
        TypeMirror castErasure = info.getTypes().erasure(castType);
        CharSequence currentTypeName = info.getTypeUtilities().getTypeName(castType, new TypeUtilities.TypeNameOptions[0]);
        for (TypeMirror typeMirror : types) {
            void var18_19;
            if (!Utilities.isValidValueType(typeMirror)) continue;
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                Type.TypeVar tvar = (Type.TypeVar)typeMirror;
                if (tvar.isExtendsBound()) {
                    Type type = tvar.getLowerBound();
                } else if (tvar.isSuperBound()) {
                    Type type = tvar.getUpperBound();
                }
            }
            TypeMirror tmErasure = info.getTypes().erasure((TypeMirror)var18_19);
            if (info.getTypes().isAssignable(casteeType, (TypeMirror)var18_19) && !exp.isNotRedundant()) {
                if (Utilities.loosesPrecision(casteeType, castType) || casteeType.getKind().isPrimitive() && castType.getKind().isPrimitive() && !var18_19.getKind().isPrimitive()) continue;
                boolean report = true;
                if (exec != null) {
                    TypeMirror varType;
                    if (varargs && (varType = exec.getParameters().get(argIndex).asType()).getKind() == TypeKind.ARRAY && info.getTypes().isAssignable(casteeType, varType)) {
                        TypeMirror itemType = ((ArrayType)varType).getComponentType();
                        if (info.getTypes().isAssignable(casteeType, itemType)) {
                            report = false;
                        }
                    }
                    if (report && TooStrongCast.checkAmbiguous(info, parentExec, exp.getArgumentIndex(), null, realExpressionPath)) {
                        report = false;
                    }
                }
                if (report) {
                    return TooStrongCast.reportUselessCast(ctx, tct, currentTypeName, info, exp, castType);
                }
            }
            if (!info.getTypeUtilities().isCastable(casteeType, (TypeMirror)var18_19) || !info.getTypeUtilities().isCastable((TypeMirror)var18_19, castType)) continue;
            if (exp.isNotRedundant() ? info.getTypes().isSameType(tmErasure, castErasure) : info.getTypes().isAssignable(tmErasure, castErasure)) {
                return null;
            }
            if (casteeType.getKind().isPrimitive() && Utilities.isPrimitiveWrapperType(castType) && info.getTypes().isSameType(casteeType, info.getTypes().unboxedType(castType))) continue;
            if (exec != null) {
                TypeMirror varType;
                if (varargs && (varType = exec.getParameters().get(argIndex).asType()).getKind() == TypeKind.ARRAY && info.getTypes().isAssignable((TypeMirror)var18_19, varType)) {
                    TypeMirror itemType = ((ArrayType)varType).getComponentType();
                    if (info.getTypes().isAssignable((TypeMirror)var18_19, itemType)) continue;
                }
                if (TooStrongCast.checkAmbiguous(info, parentExec, exp.getArgumentIndex(), (TypeMirror)var18_19, realExpressionPath)) continue;
            }
            filteredTypes.add(Utilities.resolveTypeForDeclaration(info, (TypeMirror)var18_19));
        }
        if (filteredTypes.isEmpty()) {
            return null;
        }
        int index = 0;
        Fix[] fixArray = new Fix[filteredTypes.size()];
        for (TypeMirror tm : filteredTypes) {
            CharSequence tname = info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]);
            lst = index == 0 ? Bundle.TEXT_TooStrongCastListFirst(tname) : (index == types.size() - 1 ? Bundle.TEXT_TooStrongCastListLast(lst, tname) : Bundle.TEXT_TooStrongCastListMiddle(lst, tname));
            fixArray[index] = new ReplaceTypeCast(info, ctx.getPath(), tm).toEditorFix();
            ++index;
        }
        String msg = Bundle.TEXT_TooStrongCast(currentTypeName, lst);
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)msg, (Fix[])fixArray);
    }

    private static boolean isPolymorphicSignature(CompilationInfo info, TreePath path) {
        TypeElement polymorphicEl = info.getElements().getTypeElement("java.lang.invoke.MethodHandle.PolymorphicSignature");
        if (polymorphicEl == null) {
            return false;
        }
        TypeMirror polyType = polymorphicEl.asType();
        Element target = info.getTrees().getElement(path);
        if (target == null || target.getKind() != ElementKind.METHOD) {
            return false;
        }
        if (target.getEnclosingElement() == null || !target.getEnclosingElement().getKind().isClass()) {
            return false;
        }
        ExecutableElement ee = (ExecutableElement)target;
        TypeElement parent = (TypeElement)target.getEnclosingElement();
        if (!parent.getQualifiedName().toString().startsWith("java.lang.invoke.")) {
            return false;
        }
        for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
            if (!info.getTypes().isSameType(polyType, annotationMirror.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    private static ErrorDescription reportUselessCast(HintContext ctx, TypeCastTree tct, CharSequence currentTypeName, CompilationInfo info, ExpectedTypeResolver exp, TypeMirror castType) {
        TreePath binParent;
        if (!Utilities.isValidType(castType)) {
            return null;
        }
        if (castType.getKind().isPrimitive() && (binParent = TooStrongCast.findBinaryParent(ctx.getPath().getParentPath())) != null) {
            HashMap<Tree, TypeMirror> exclusions = (HashMap<Tree, TypeMirror>)ctx.getInfo().getCachedValue(RemoveCast.class);
            if (exclusions == null) {
                exclusions = new HashMap<Tree, TypeMirror>();
                ctx.getInfo().putCachedValue(RemoveCast.class, exclusions, CompilationInfo.CacheClearPolicy.ON_TASK_END);
            } else {
                TypeMirror x = (TypeMirror)exclusions.get(binParent.getLeaf());
                if (x != null && ctx.getInfo().getTypes().isSameType(x, castType)) {
                    return null;
                }
            }
            exclusions.put(binParent.getLeaf(), castType);
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)tct.getType(), (String)Bundle.TEXT_UnnecessaryCast(currentTypeName), (Fix[])new Fix[]{new RemoveCast(info, ctx.getPath(), exp.getTheExpression(), currentTypeName).toEditorFix()});
    }

    private static TreePath findBinaryParent(TreePath path) {
        block4: while (path != null) {
            Tree l = path.getLeaf();
            Tree.Kind k = l.getKind();
            if (k.asInterface().isAssignableFrom(StatementTree.class)) {
                return null;
            }
            switch (k) {
                case PLUS: 
                case MINUS: 
                case MULTIPLY: 
                case DIVIDE: 
                case REMAINDER: 
                case CONDITIONAL_EXPRESSION: {
                    break block4;
                }
                case PARENTHESIZED: {
                    break;
                }
                default: {
                    return null;
                }
            }
            path = path.getParentPath();
        }
        return path;
    }

    private static boolean checkAmbiguous(CompilationInfo info, TreePath parentExec, int argIndex, TypeMirror casteeType, TreePath realArgTree) {
        List<? extends ExpressionTree> arguments;
        Tree leaf;
        CharSequence altType = info.getTypeUtilities().getTypeName(casteeType, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN});
        String prefix = null;
        if (casteeType != null && casteeType.getKind() != TypeKind.NULL && casteeType.getKind() != TypeKind.INTERSECTION) {
            prefix = "(" + String.valueOf(altType) + ")";
        }
        if ((leaf = parentExec.getLeaf()) instanceof MethodInvocationTree) {
            MethodInvocationTree mi = (MethodInvocationTree)leaf;
            arguments = mi.getArguments();
        } else {
            arguments = ((NewClassTree)leaf).getArguments();
        }
        Tree argTree = arguments.get(argIndex);
        TreePath argPath = new TreePath(parentExec, argTree);
        return !Utilities.checkAlternativeInvocation(info, parentExec, argPath, realArgTree, prefix);
    }

    private static class ReplaceTypeCast
    extends JavaFix {
        private TypeMirrorHandle<TypeMirror> handle;
        private String typeName;

        public ReplaceTypeCast(CompilationInfo info, TreePath tp, TypeMirror castToType) {
            super(info, tp);
            this.handle = TypeMirrorHandle.create((TypeMirror)castToType);
            this.typeName = info.getTypeUtilities().getTypeName(castToType, new TypeUtilities.TypeNameOptions[0]).toString();
        }

        protected String getText() {
            return Bundle.FIX_ChangeCastTo(this.typeName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath castPath = ctx.getPath();
            if (castPath.getLeaf().getKind() != Tree.Kind.TYPE_CAST) {
                return;
            }
            TypeCastTree tct = (TypeCastTree)castPath.getLeaf();
            TypeMirror targetType = this.handle.resolve((CompilationInfo)ctx.getWorkingCopy());
            Tree tt = ctx.getWorkingCopy().getTreeMaker().Type(targetType);
            ctx.getWorkingCopy().rewrite(tct.getType(), tt);
        }
    }

    private static class RemoveCast
    extends JavaFix {
        private final TreePathHandle upto;
        private final CharSequence typeName;

        public RemoveCast(CompilationInfo info, TreePath tp, TreePath upTo, CharSequence typeName) {
            super(info, tp);
            this.upto = TreePathHandle.create((TreePath)upTo, (CompilationInfo)info);
            this.typeName = typeName;
        }

        protected String getText() {
            return Bundle.FIX_RemoveUnneededCast(this.typeName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath castPath = ctx.getPath();
            if (castPath.getLeaf().getKind() != Tree.Kind.TYPE_CAST) {
                return;
            }
            TypeCastTree tct = (TypeCastTree)castPath.getLeaf();
            ExpressionTree inside = tct.getExpression();
            TreePath upper = this.upto.resolve((CompilationInfo)ctx.getWorkingCopy());
            Tree outside = upper != null ? upper.getLeaf() : tct;
            ctx.getWorkingCopy().rewrite(outside, (Tree)inside);
        }
    }
}

