/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.impl;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.modules.j2ee.sun.validation.Validatee;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;
import org.netbeans.modules.j2ee.sun.validation.util.Utils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;

public class ValidateeImpl
implements Validatee {
    private BaseBean baseBean = null;
    private Utils utils = null;

    public ValidateeImpl(Object baseBean) {
        this.baseBean = (BaseBean)baseBean;
        this.utils = new Utils();
    }

    @Override
    public ArrayList getElementNames() {
        ArrayList<String> elements = new ArrayList<String>();
        BaseProperty[] baseProperty = this.baseBean.listProperties();
        int size = baseProperty.length;
        for (int i = 0; i < size; ++i) {
            elements.add(baseProperty[i].getName());
        }
        return elements;
    }

    @Override
    public ArrayList getElementDtdNames() {
        ArrayList<String> elements = new ArrayList<String>();
        BaseProperty[] baseProperty = this.baseBean.listProperties();
        int size = baseProperty.length;
        for (int i = 0; i < size; ++i) {
            elements.add(baseProperty[i].getDtdName());
        }
        return elements;
    }

    @Override
    public boolean isIndexed(String elementName) {
        BaseProperty baseProperty = this.baseBean.getProperty(elementName);
        boolean returnValue = false;
        if (null != baseProperty) {
            returnValue = baseProperty.isIndexed();
        } else {
            String format = BundleReader.getValue("Error_does_not_exists");
            Object[] arguments = new Object[]{"Property", elementName};
            String message = MessageFormat.format(format, arguments);
            assert (false) : message;
        }
        return returnValue;
    }

    @Override
    public int getElementCardinal(String elementName) {
        BaseProperty baseProperty = this.baseBean.getProperty(elementName);
        int returnValue = -1;
        if (null != baseProperty) {
            returnValue = baseProperty.getInstanceType();
        } else {
            String format = BundleReader.getValue("Error_does_not_exists");
            Object[] arguments = new Object[]{"Property", elementName};
            String message = MessageFormat.format(format, arguments);
            assert (false) : message;
        }
        return returnValue;
    }

    @Override
    public int getCardinal() {
        String name = this.baseBean.name();
        BaseBean parent = this.baseBean.parent();
        BaseProperty baseProperty = parent.getProperty(name);
        return baseProperty.getInstanceType();
    }

    @Override
    public boolean isBeanElement(String elementName) {
        BaseProperty baseProperty = this.baseBean.getProperty(elementName);
        boolean returnValue = false;
        if (null != baseProperty) {
            returnValue = baseProperty.isBean();
        } else {
            String format = BundleReader.getValue("Error_does_not_exists");
            Object[] arguments = new Object[]{"Property", elementName};
            String message = MessageFormat.format(format, arguments);
            assert (false) : message;
        }
        return returnValue;
    }

    @Override
    public String getXPath() {
        BaseBean bean = this.baseBean;
        BaseBean parentBean = null;
        String xpath = bean.dtdName();
        boolean root = this.isRootElement(bean);
        parentBean = bean.parent();
        while (!root) {
            xpath = parentBean.dtdName() + "/" + xpath;
            bean = parentBean;
            parentBean = bean.parent();
            root = this.isRootElement(bean);
        }
        xpath = "/" + xpath;
        return xpath;
    }

    @Override
    public String getIndexedXPath() {
        BaseBean bean = this.baseBean;
        BaseBean parentBean = null;
        String xpath = bean.dtdName();
        int index = this.getIndex(this.baseBean);
        if (index != -1) {
            xpath = this.utils.getIndexedName(xpath, index);
        }
        boolean root = this.isRootElement(bean);
        parentBean = bean.parent();
        String name = null;
        while (!root) {
            name = parentBean.dtdName();
            index = this.getIndex(parentBean);
            if (index != -1) {
                name = this.utils.getIndexedName(name, index);
            }
            xpath = name + "/" + xpath;
            bean = parentBean;
            parentBean = bean.parent();
            root = this.isRootElement(bean);
        }
        xpath = "/" + xpath;
        return xpath;
    }

    boolean isRootElement(BaseBean bean) {
        BaseBean parent = bean.parent();
        boolean root = parent.name().equals(bean.name());
        return root;
    }

    int getIndex(BaseBean baseBean) {
        int index = -1;
        boolean root = this.isRootElement(baseBean);
        if (!root) {
            String name = baseBean.name();
            BaseBean parent = baseBean.parent();
            if (parent != null) {
                index = parent.indexOf(name, (Object)baseBean);
            }
        }
        return index;
    }

    @Override
    public Object getElement(String elementName, int index) {
        return this.utils.getElement(elementName, index, this.baseBean);
    }

    @Override
    public Object getElement(String elementName) {
        return this.utils.getElement(elementName, this.baseBean);
    }

    @Override
    public Object[] getElements(String elementName) {
        return this.utils.getElements(elementName, this.baseBean);
    }

    @Override
    public Method getMethod(String methodName) {
        return this.utils.getMethod(this.utils.getClass(this.baseBean), methodName);
    }

    @Override
    public Object invoke(Method method) {
        return this.utils.invoke(this.baseBean, method);
    }
}

