/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.ProjectSelector;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class WizardPanel1UI
extends ValidityAwarePanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "PPointsWizardPanel1UI.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("PPointsWizardPanel1UI.HelpCtx");
    private static final Icon MONITOR_ICON = Icons.getIcon((String)"ProfilerIcons.Monitoring");
    private static final Icon CPU_ICON = Icons.getIcon((String)"ProfilerIcons.Cpu");
    private static final Icon MEMORY_ICON = Icons.getIcon((String)"ProfilerIcons.Memory");
    private AbstractTableModel ppointTypeTableModel;
    private Dimension initialMinSize;
    private ProjectSelector ppointProjectSelector;
    private ProfilerTable ppointTypeTable;
    private JLabel ppointDescriptionCaptionLabel;
    private JLabel ppointEffectiveCPULabel;
    private JLabel ppointEffectiveCaptionLabel;
    private JLabel ppointEffectiveMemoryLabel;
    private JLabel ppointEffectiveMonitorLabel;
    private JLabel ppointProjectLabel;
    private JLabel ppointTypeCaptionLabel;
    private JTextArea ppointDescriptionArea;
    private ProfilingPointFactory[] ppFactories = new ProfilingPointFactory[0];
    private boolean hasDefaultScope = false;

    public WizardPanel1UI() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public Dimension getMinSize() {
        return this.initialMinSize;
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            this.ppointTypeTable.clearSelection();
        } else {
            this.ppointTypeTable.setRowSelectionInterval(index, index);
        }
    }

    public int getSelectedIndex() {
        return this.ppointTypeTable.getSelectedRow();
    }

    public void setSelectedProject(Lookup.Provider project) {
        this.ppointProjectSelector.setProject(project);
    }

    public Lookup.Provider getSelectedProject() {
        return this.ppointProjectSelector.getProject();
    }

    public boolean hasDefaultScope() {
        return this.hasDefaultScope;
    }

    public void init(ProfilingPointFactory[] ppFactories) {
        this.ppFactories = ppFactories;
        this.initProjectsCombo();
        this.ppointTypeTableModel.fireTableDataChanged();
        this.ppointTypeTable.getColumnModel().getColumn(0).setMaxWidth(Math.max(ProfilingPointFactory.SCOPE_CODE_ICON.getIconWidth(), ProfilingPointFactory.SCOPE_GLOBAL_ICON.getIconWidth()) + 25);
        this.refresh();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.ppointTypeCaptionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.ppointTypeCaptionLabel, (String)Bundle.WizardPanel1UI_PpTypeString());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.ppointTypeCaptionLabel, constraints);
        this.ppointTypeTableModel = new PPointTypeTableModel();
        this.ppointTypeTable = new ProfilerTable((TableModel)this.ppointTypeTableModel, false, false, null);
        this.ppointTypeTable.getAccessibleContext().setAccessibleName(Bundle.WizardPanel1UI_ProjectsListAccessName());
        this.ppointTypeCaptionLabel.setLabelFor((Component)this.ppointTypeTable);
        this.ppointTypeTable.setMainColumn(1);
        this.ppointTypeTable.setFitWidthColumn(1);
        this.ppointTypeTable.setTableHeader(null);
        this.ppointTypeTable.setRowSelectionAllowed(true);
        this.ppointTypeTable.setSelectionMode(0);
        this.ppointTypeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WizardPanel1UI.this.refresh();
            }
        });
        this.ppointTypeTable.setDefaultRenderer(Integer.class, Utils.getScopeRenderer());
        this.ppointTypeTable.setDefaultRenderer(String.class, Utils.getPresenterRenderer());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 15, 12, 10);
        this.add((Component)new ProfilerTableContainer(this.ppointTypeTable, true, null), constraints);
        this.ppointProjectLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.ppointProjectLabel, (String)Bundle.WizardPanel1UI_PpProjectString());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.ppointProjectLabel, constraints);
        this.ppointProjectSelector = new ProjectSelector(Bundle.WizardPanel1UI_SelectProject()){

            protected void selectionChanged() {
                WizardPanel1UI.this.refresh();
            }
        };
        this.ppointProjectLabel.getAccessibleContext().setAccessibleName(Bundle.WizardPanel1UI_ProjectsListAccessName());
        this.ppointProjectLabel.setLabelFor((Component)((Object)this.ppointProjectSelector));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 15, 12, 10);
        this.add((Component)((Object)this.ppointProjectSelector), constraints);
        this.ppointDescriptionCaptionLabel = new JLabel(Bundle.WizardPanel1UI_DescriptionLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 10);
        this.add((Component)this.ppointDescriptionCaptionLabel, constraints);
        this.ppointDescriptionArea = new JTextArea();
        this.ppointDescriptionArea.setOpaque(false);
        this.ppointDescriptionArea.setWrapStyleWord(true);
        this.ppointDescriptionArea.setLineWrap(true);
        this.ppointDescriptionArea.setEnabled(false);
        this.ppointDescriptionArea.setFont(UIManager.getFont("Label.font"));
        this.ppointDescriptionArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        int rows = this.ppointDescriptionArea.getRows();
        this.ppointDescriptionArea.setRows(4);
        final int height = this.ppointDescriptionArea.getPreferredSize().height;
        this.ppointDescriptionArea.setRows(rows);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 15, 12, 10);
        JScrollPane ppointDescriptionAreaScroll = new JScrollPane(this, this.ppointDescriptionArea, 20, 31){
            final /* synthetic */ WizardPanel1UI this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, height);
            }
        };
        ppointDescriptionAreaScroll.setBorder(BorderFactory.createEmptyBorder());
        ppointDescriptionAreaScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        ppointDescriptionAreaScroll.setOpaque(false);
        ppointDescriptionAreaScroll.getViewport().setOpaque(false);
        this.add((Component)ppointDescriptionAreaScroll, constraints);
        int maxHeight = this.ppointDescriptionCaptionLabel.getPreferredSize().height;
        maxHeight = Math.max(maxHeight, MONITOR_ICON.getIconHeight());
        maxHeight = Math.max(maxHeight, CPU_ICON.getIconHeight());
        final int mheight = maxHeight = Math.max(maxHeight, MEMORY_ICON.getIconHeight());
        JPanel effectiveModesContainer = new JPanel(new GridBagLayout());
        this.ppointEffectiveCaptionLabel = new JLabel(this, Bundle.WizardPanel1UI_SupportedModesLabelText()){
            final /* synthetic */ WizardPanel1UI this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, mheight);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, mheight);
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 10);
        effectiveModesContainer.add((Component)this.ppointEffectiveCaptionLabel, constraints);
        this.ppointEffectiveMonitorLabel = new JLabel(Bundle.WizardPanel1UI_MonitorModeString(), MONITOR_ICON, 2);
        this.ppointEffectiveMonitorLabel.setVisible(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 10);
        effectiveModesContainer.add((Component)this.ppointEffectiveMonitorLabel, constraints);
        this.ppointEffectiveCPULabel = new JLabel(Bundle.WizardPanel1UI_CpuModeString(), CPU_ICON, 2);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 10);
        effectiveModesContainer.add((Component)this.ppointEffectiveCPULabel, constraints);
        this.ppointEffectiveMemoryLabel = new JLabel(Bundle.WizardPanel1UI_MemoryModeString(), MEMORY_ICON, 2);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 10);
        effectiveModesContainer.add((Component)this.ppointEffectiveMemoryLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)effectiveModesContainer, constraints);
        this.initialMinSize = this.getMinimumSize();
    }

    private void initProjectsCombo() {
        ProfilingPointsManager manager = ProfilingPointsManager.getDefault();
        Lookup.Provider defaultScope = null;
        for (Lookup.Provider providedScope : manager.getProvidedScopes()) {
            if (providedScope == null || !manager.isDefaultScope(providedScope)) continue;
            defaultScope = providedScope;
            break;
        }
        this.hasDefaultScope = defaultScope != null;
        this.setSelectedProject(this.hasDefaultScope ? defaultScope : Utils.getCurrentProject());
    }

    private void refresh() {
        boolean isValid;
        int selectedIndex = this.ppointTypeTable.getSelectedRow();
        if (selectedIndex != -1) {
            ProfilingPointFactory ppFactory = this.ppFactories[selectedIndex];
            this.ppointDescriptionArea.setText(ppFactory.getDescription());
            this.ppointEffectiveMonitorLabel.setVisible(ppFactory.supportsMonitor());
            this.ppointEffectiveCPULabel.setVisible(ppFactory.supportsCPU());
            this.ppointEffectiveMemoryLabel.setVisible(ppFactory.supportsMemory());
        } else {
            this.ppointDescriptionArea.setText("");
            this.ppointEffectiveMonitorLabel.setVisible(false);
            this.ppointEffectiveCPULabel.setVisible(false);
            this.ppointEffectiveMemoryLabel.setVisible(false);
        }
        boolean ppointTypeSelected = selectedIndex != -1;
        boolean ppointProjectSelected = this.ppointProjectSelector.getProject() != null;
        boolean bl = isValid = ppointTypeSelected && ppointProjectSelected;
        if (isValid) {
            if (!this.areSettingsValid()) {
                this.fireValidityChanged(true);
            }
        } else if (this.areSettingsValid()) {
            this.fireValidityChanged(false);
        }
    }

    private class PPointTypeTableModel
    extends AbstractTableModel {
        private PPointTypeTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return WizardPanel1UI.this.ppFactories.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return WizardPanel1UI.this.ppFactories[rowIndex];
        }
    }
}

