/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.state;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.data.DataException;
import org.netbeans.modules.glassfish.tooling.logging.Logger;

public enum StatusJobState {
    NO_CHECK,
    UNKNOWN,
    UNKNOWN_PORT,
    OFFLINE,
    OFFLINE_PORT,
    STARTUP,
    STARTUP_PORT,
    ONLINE,
    SHUTDOWN,
    SHUTDOWN_PORT;

    private static final Logger LOGGER;
    public static final int length;
    private static final String NO_CHECK_STR = "NO_CHECK";
    private static final String UNKNOWN_STR = "UNKNOWN";
    private static final String UNKNOWN_PORT_STR = "UNKNOWN_PORT";
    private static final String OFFLINE_STR = "OFFLINE";
    private static final String OFFLINE_PORT_STR = "OFFLINE_PORT";
    private static final String STARTUP_STR = "STARTUP";
    private static final String STARTUP_PORT_STR = "STARTUP_PORT";
    private static final String ONLINE_STR = "ONLINE";
    private static final String SHUTDOWN_STR = "SHUTDOWN";
    private static final String SHUTDOWN_PORT_STR = "SHUTDOWN_PORT";
    private static final Map<String, StatusJobState> stringValuesMap;
    private static final GlassFishStatus[] toGlassFishStatus;

    public static StatusJobState toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public String toString() {
        String METHOD = "toString";
        switch (this.ordinal()) {
            case 0: {
                return NO_CHECK_STR;
            }
            case 1: {
                return UNKNOWN_STR;
            }
            case 2: {
                return UNKNOWN_PORT_STR;
            }
            case 3: {
                return OFFLINE_STR;
            }
            case 4: {
                return OFFLINE_PORT_STR;
            }
            case 5: {
                return STARTUP_STR;
            }
            case 6: {
                return STARTUP_PORT_STR;
            }
            case 7: {
                return ONLINE_STR;
            }
            case 8: {
                return SHUTDOWN_STR;
            }
            case 9: {
                return SHUTDOWN_PORT_STR;
            }
        }
        throw new DataException(LOGGER.excMsg("toString", "invalidVersion"));
    }

    GlassFishStatus toGlassFishStatus() {
        return toGlassFishStatus[this.ordinal()];
    }

    static {
        LOGGER = new Logger(StatusJobState.class);
        length = StatusJobState.values().length;
        stringValuesMap = new HashMap<String, StatusJobState>(length);
        for (StatusJobState state : StatusJobState.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
        toGlassFishStatus = new GlassFishStatus[]{GlassFishStatus.UNKNOWN, GlassFishStatus.UNKNOWN, GlassFishStatus.UNKNOWN, GlassFishStatus.OFFLINE, GlassFishStatus.OFFLINE, GlassFishStatus.STARTUP, GlassFishStatus.STARTUP, GlassFishStatus.ONLINE, GlassFishStatus.SHUTDOWN, GlassFishStatus.SHUTDOWN};
    }
}

