/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ConflictResolvedAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "resolve";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 16448;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        final File[] files = ctx.getFiles();
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, this, nodes, ctx){
            final /* synthetic */ ConflictResolvedAction this$0;
            {
                this.this$0 = this$0;
                super(action, nodes, ctx2);
            }

            @Override
            public void perform() {
                SvnClient client = null;
                try {
                    client = Subversion.getInstance().getClient(ctx, (SvnProgressSupport)this);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
                if (client == null) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (this.isCanceled()) {
                        return;
                    }
                    File file = files[i];
                    try {
                        ConflictResolvedAction.perform(file, client);
                        continue;
                    }
                    catch (SVNClientException ex) {
                        this.annotate(ex);
                    }
                }
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    public static void perform(final File file) throws SVNClientException {
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            protected void perform() {
                try {
                    SvnClient client = Subversion.getInstance().getClient(file);
                    if (client != null) {
                        ConflictResolvedAction.perform(file, client);
                    }
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                }
            }
        };
        SVNUrl url = SvnUtils.getRepositoryRootUrl(file);
        support.start(Subversion.getInstance().getRequestProcessor(url), url, NbBundle.getMessage(ConflictResolvedAction.class, (String)"LBL_ResolvingConflicts"));
    }

    private static void perform(File file, SvnClient client) throws SVNClientException {
        FileObject folder;
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        client.resolved(file);
        cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        File parent = file.getParentFile();
        if (parent != null && (folder = FileUtil.toFileObject((File)parent)) != null) {
            folder.refresh();
        }
    }
}

