/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.openide.util.Exceptions;

public class ParameterImpl
implements Parameter {
    private final String name;
    private final String defaultValue;
    private final String declaredType;
    private final String phpdocType;
    private final List<QualifiedName> types;
    private final OffsetRange range;
    private final boolean isRawType;
    private final boolean isReference;
    private final boolean isVariadic;
    private final boolean isUnionType;
    private final boolean isIntersectionType;
    private final int modifier;

    public ParameterImpl(String name, String defaultValue, List<QualifiedName> types, boolean isRawType, OffsetRange range, boolean isReference, boolean isVariadic, boolean isUnionType, int modifier, boolean isIntersectionType, String declaredType, String phpdocType) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.declaredType = declaredType;
        this.phpdocType = phpdocType;
        this.types = types == null ? Collections.emptyList() : types;
        this.range = range;
        this.isRawType = isRawType;
        this.isReference = isReference;
        this.isVariadic = isVariadic;
        this.isUnionType = isUnionType;
        this.modifier = modifier;
        this.isIntersectionType = isIntersectionType;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @CheckForNull
    public String getDeclaredType() {
        return this.declaredType;
    }

    @Override
    @CheckForNull
    public String getPhpdocType() {
        return this.phpdocType;
    }

    @Override
    public boolean isMandatory() {
        return this.defaultValue == null;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public boolean isVariadic() {
        return this.isVariadic;
    }

    @Override
    public boolean isUnionType() {
        return this.isUnionType;
    }

    @Override
    public boolean isIntersectionType() {
        return this.isIntersectionType;
    }

    @Override
    public int getModifier() {
        return this.modifier;
    }

    @Override
    public List<QualifiedName> getTypes() {
        return new ArrayList<QualifiedName>(this.types);
    }

    @Override
    public OffsetRange getOffsetRange() {
        return this.range;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":");
        List<QualifiedName> qNames = this.getTypes();
        for (int idx = 0; idx < qNames.size(); ++idx) {
            if (idx > 0) {
                sb.append(Type.getTypeSeparator(this.isIntersectionType));
            }
            QualifiedName qualifiedName = qNames.get(idx);
            sb.append(qualifiedName.toString());
        }
        sb.append(":");
        sb.append(this.isRawType ? 1 : 0);
        sb.append(":");
        String defValue = this.getDefaultValue();
        sb.append(ParameterImpl.encode(defValue));
        sb.append(":");
        sb.append(this.isReference ? 1 : 0);
        sb.append(":");
        sb.append(this.isVariadic ? 1 : 0);
        sb.append(":");
        sb.append(this.isUnionType ? 1 : 0);
        sb.append(":");
        sb.append(this.modifier);
        sb.append(":");
        sb.append(this.isIntersectionType ? 1 : 0);
        sb.append(":");
        sb.append(this.declaredType);
        sb.append(":");
        sb.append(this.phpdocType);
        return sb.toString();
    }

    public static List<Parameter> toParameters(String args) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (args != null && args.length() > 0) {
            String[] pams;
            for (String par : pams = args.split("\\,")) {
                String[] parts = par.split("\\:");
                if (parts.length <= 0) continue;
                String paramName = parts[0];
                ArrayList<QualifiedName> qualifiedNames = new ArrayList<QualifiedName>();
                if (parts.length > 1) {
                    String[] splittedTypes;
                    String typenames = parts[1];
                    for (String type : splittedTypes = typenames.length() > 0 ? typenames.split("\\|") : new String[]{}) {
                        qualifiedNames.add(QualifiedName.create(type));
                    }
                }
                boolean isRawType = Integer.parseInt(parts[2]) > 0;
                String defValue = parts.length > 3 ? parts[3] : "";
                boolean isReference = Integer.parseInt(parts[4]) > 0;
                boolean isVariadic = Integer.parseInt(parts[5]) > 0;
                boolean isUnionType = Integer.parseInt(parts[6]) > 0;
                int modifier = Integer.parseInt(parts[7]);
                boolean isIntersectionType = Integer.parseInt(parts[8]) > 0;
                String declType = parts.length > 9 ? parts[9] : null;
                String docType = parts.length > 10 ? parts[10] : null;
                parameters.add(new ParameterImpl(paramName, defValue.length() != 0 ? ParameterImpl.decode(defValue) : null, qualifiedNames, isRawType, OffsetRange.NONE, isReference, isVariadic, isUnionType, modifier, isIntersectionType, declType, docType));
            }
        }
        return parameters;
    }

    private static String encode(String inStr) {
        StringBuilder outStr = new StringBuilder(6 * inStr.length());
        for (int i = 0; i < inStr.length(); ++i) {
            if (inStr.charAt(i) == ':' || inStr.charAt(i) == '|' || inStr.charAt(i) == ';' || inStr.charAt(i) == ',' || ParameterImpl.isEncodedChar(i, inStr)) {
                outStr.append(ParameterImpl.encodeChar(inStr.charAt(i)));
                continue;
            }
            outStr.append(inStr.charAt(i));
        }
        return outStr.toString();
    }

    private static String encodeChar(char ch) {
        String encChar = Integer.toString(ch, 16);
        return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
    }

    private static String decode(String inStr) {
        StringBuilder outStr = new StringBuilder(inStr.length());
        try {
            for (int i = 0; i < inStr.length(); ++i) {
                if (ParameterImpl.isEncodedChar(i, inStr)) {
                    String decChar = inStr.substring(i + 2, i + 6);
                    outStr.append((char)Integer.parseInt(decChar, 16));
                    i += 5;
                    continue;
                }
                outStr.append(inStr.charAt(i));
            }
        }
        catch (NumberFormatException e) {
            Exceptions.printStackTrace((Throwable)e);
            return inStr;
        }
        return outStr.toString();
    }

    private static boolean isEncodedChar(int currentPosition, String inStr) {
        boolean isEncodedChar;
        boolean bl = isEncodedChar = currentPosition + 5 < inStr.length();
        if (isEncodedChar) {
            char c;
            isEncodedChar &= inStr.charAt(currentPosition) == '\\' && inStr.charAt(currentPosition + 1) == 'u';
            for (int i = currentPosition + 2; isEncodedChar && i < currentPosition + 6; isEncodedChar &= Character.digit(c = inStr.charAt(i), 16) != -1, ++i) {
            }
        }
        return isEncodedChar;
    }

    @Override
    public boolean hasRawType() {
        return this.isRawType;
    }
}

