/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners.stats;

import java.util.Arrays;
import oracle.ucp.tuners.stats.HistogramInsertionException;
import oracle.ucp.util.Pair;

public class Histogram {
    private final long min;
    private final long max;
    private final long step;
    private final long[] hist;

    public Histogram(long min, long max, long step) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.hist = new long[(int)Math.ceil((max - min) / step)];
        Arrays.fill(this.hist, 0L);
        if (max <= min || step > max - min) {
            throw new IllegalArgumentException();
        }
    }

    public void insert(long data) throws HistogramInsertionException {
        if (data < this.min || data > this.max) {
            throw new HistogramInsertionException("data out of range");
        }
        int n = (int)((data - this.min) / this.step);
        this.hist[n] = this.hist[n] + 1L;
    }

    public Histogram add(Histogram anotherHist) {
        int len = this.hist.length;
        if (len != anotherHist.hist.length) {
            throw new IllegalArgumentException("incompatible histograms");
        }
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.hist[n] = this.hist[n] + anotherHist.hist[i];
        }
        return this;
    }

    public Pair<Long, Long> computeEffectiveRange() {
        long maxValue = 0L;
        int indexMax = 0;
        for (int i = 0; i < this.hist.length; ++i) {
            if (this.hist[i] <= maxValue) continue;
            maxValue = this.hist[i] * (((long)i + this.min) * this.step);
            indexMax = i;
        }
        int leftBound = indexMax;
        for (int i = indexMax; i >= 0; --i) {
            if (this.hist[i] * (((long)i + this.min) * this.step) > maxValue / 2L) continue;
            leftBound = i;
            break;
        }
        int rightBound = indexMax;
        for (int i = indexMax; i < this.hist.length; ++i) {
            if (this.hist[i] * (((long)i + this.min) * this.step) > maxValue / 2L) continue;
            rightBound = i;
            break;
        }
        return new Pair<Long, Long>(this.min + (long)leftBound * this.step, this.min + (long)rightBound * this.step);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (long i = this.min; i < this.max; i += this.step) {
            sb.append(i).append(':').append(this.hist[(int)((i - this.min) / this.step)]);
            if (i >= this.max - this.step) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

