/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;

public class GetPublicKeyFromPrivateKeyInput {
    public ECDHCurveSpec _eccCurve;
    public ECCPrivateKey _privateKey;
    private static final TypeDescriptor<GetPublicKeyFromPrivateKeyInput> _TYPE = TypeDescriptor.referenceWithInitializer(GetPublicKeyFromPrivateKeyInput.class, () -> GetPublicKeyFromPrivateKeyInput.Default());
    private static final GetPublicKeyFromPrivateKeyInput theDefault = GetPublicKeyFromPrivateKeyInput.create(ECDHCurveSpec.Default(), ECCPrivateKey.Default());

    public GetPublicKeyFromPrivateKeyInput(ECDHCurveSpec eccCurve, ECCPrivateKey privateKey) {
        this._eccCurve = eccCurve;
        this._privateKey = privateKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GetPublicKeyFromPrivateKeyInput o = (GetPublicKeyFromPrivateKeyInput)other;
        return Objects.equals(this._eccCurve, o._eccCurve) && Objects.equals(this._privateKey, o._privateKey);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._eccCurve);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._privateKey);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.GetPublicKeyFromPrivateKeyInput.GetPublicKeyFromPrivateKeyInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._eccCurve));
        s.append(", ");
        s.append(Helpers.toString((Object)this._privateKey));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<GetPublicKeyFromPrivateKeyInput> _typeDescriptor() {
        return _TYPE;
    }

    public static GetPublicKeyFromPrivateKeyInput Default() {
        return theDefault;
    }

    public static GetPublicKeyFromPrivateKeyInput create(ECDHCurveSpec eccCurve, ECCPrivateKey privateKey) {
        return new GetPublicKeyFromPrivateKeyInput(eccCurve, privateKey);
    }

    public static GetPublicKeyFromPrivateKeyInput create_GetPublicKeyFromPrivateKeyInput(ECDHCurveSpec eccCurve, ECCPrivateKey privateKey) {
        return GetPublicKeyFromPrivateKeyInput.create(eccCurve, privateKey);
    }

    public boolean is_GetPublicKeyFromPrivateKeyInput() {
        return true;
    }

    public ECDHCurveSpec dtor_eccCurve() {
        return this._eccCurve;
    }

    public ECCPrivateKey dtor_privateKey() {
        return this._privateKey;
    }
}

