/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.AttributesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityTypeKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u00000\b\"\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\t\u0010\nB=\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000b\u0012\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u00000\b\"\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\t\u0010\fBG\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\"\u0010\u0007\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u00000\b\"\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\t\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0005H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rhizomedb/Mixin;", "E", "Lcom/jetbrains/rhizomedb/Entity;", "Lcom/jetbrains/rhizomedb/Attributes;", "ident", "", "module", "mixins", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;[Lcom/jetbrains/rhizomedb/Mixin;)V", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;[Lcom/jetbrains/rhizomedb/Mixin;)V", "version", "", "(Lkotlin/reflect/KClass;Ljava/lang/Integer;[Lcom/jetbrains/rhizomedb/Mixin;)V", "toString", "fleet.rhizomedb"})
public abstract class Mixin<E extends Entity>
extends Attributes<E> {
    public Mixin(@NotNull String ident, @NotNull String module, Mixin<? super E> ... mixins) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(mixins, (String)"mixins");
        super(ident, module, AttributesKt.merge(ArraysKt.toList((Object[])mixins)), null);
    }

    public Mixin(@NotNull KClass<? extends Entity> ident, Mixin<? super E> ... mixins) {
        Intrinsics.checkNotNullParameter(ident, (String)"ident");
        Intrinsics.checkNotNullParameter(mixins, (String)"mixins");
        String string2 = ident.getQualifiedName();
        if (string2 == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        this(string2, EntityTypeKt.entityModule(ident), Arrays.copyOf(mixins, mixins.length));
    }

    public Mixin(@NotNull KClass<? extends Entity> ident, @Nullable Integer version, Mixin<? super E> ... mixins) {
        Intrinsics.checkNotNullParameter(ident, (String)"ident");
        Intrinsics.checkNotNullParameter(mixins, (String)"mixins");
        String string2 = ident.getQualifiedName();
        Intrinsics.checkNotNull((Object)string2);
        Integer n = version;
        this(string2 + (String)(n != null ? ":" + n : ""), EntityTypeKt.entityModule(ident), Arrays.copyOf(mixins, mixins.length));
    }

    @NotNull
    public String toString() {
        return "Mixin(" + this.getNamespace() + ")";
    }
}

