\name{ScalarChanAndVeseDenseLevelSetImageFilter}
\alias{ScalarChanAndVeseDenseLevelSetImageFilter}
\title{ScalarChanAndVeseDenseLevelSetImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Dense implementation of the Chan and Vese multiphase level set image
filter.
ScalarChanAndVeseDenseLevelSetImageFilter}
\details{
This code was adapted from the paper: "An active contour model
without edges" T. Chan and L. Vese. In Scale-Space Theories in
Computer Vision, pages 141-151, 1999.
Mosaliganti K., Smith B., Gelas A., Gouaillard A., Megason S.
 This code was taken from the Insight Journal paper: "Cell Tracking
using Coupled Active Surfaces for Nuclei and Membranes" https://www.insight-journal.org/browse/publication/642 https://hdl.handle.net/10380/3055 That is based on the papers: "Level Set Segmentation: Active
Contours without edge" https://www.insight-journal.org/browse/publication/322 https://hdl.handle.net/1926/1532
and
"Level set segmentation using coupled active surfaces" https://www.insight-journal.org/browse/publication/323 https://hdl.handle.net/1926/1533
See:
ScalarChanAndVeseDenseLevelSet for the procedural interface
itk::ScalarChanAndVeseDenseLevelSetImageFilter for the Doxygen on the original ITK class.
ScalarChanAndVeseDenseLevelSetImageFilter}
%C++ includes: sitkScalarChanAndVeseDenseLevelSetImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &initialImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetAreaWeight() const:}{}
\item{double GetCurvatureWeight() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetEpsilon() const:}{}
\item{HeavisideStepFunctionType GetHeavisideStepFunction() const:}{}
\item{double GetLambda1() const:}{}
\item{double GetLambda2() const:}{}
\item{double GetMaximumRMSError() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetReinitializationSmoothingWeight() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{bool GetUseImageSpacing() const:}{
Use the image spacing information in calculations. Use this option if
you want derivatives in physical space. Default is UseImageSpacingOn.
}
\item{double GetVolume() const:}{}
\item{double GetVolumeMatchingWeight() const:}{}
\item{ ScalarChanAndVeseDenseLevelSetImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetAreaWeight(double AreaWeight):}{}
\item{Self SetCurvatureWeight(double CurvatureWeight):}{}
\item{Self SetEpsilon(double Epsilon):}{}
\item{Self SetHeavisideStepFunction(HeavisideStepFunctionType HeavisideStepFunction):}{}
\item{Self SetLambda1(double Lambda1):}{}
\item{Self SetLambda2(double Lambda2):}{}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetReinitializationSmoothingWeight(double ReinitializationSmoothingWeight):}{}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Use the image spacing information in calculations. Use this option if
you want derivatives in physical space. Default is UseImageSpacingOn.
}
\item{Self SetVolume(double Volume):}{}
\item{Self SetVolumeMatchingWeight(double VolumeMatchingWeight):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~ScalarChanAndVeseDenseLevelSetImageFilter():}{
Destructor
}
}
}
