/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AdvancedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static AdvancedProperties convertArrayToProperties(String[] items) {
        return AdvancedProperties.convertArrayToProperties(new AdvancedProperties(), items);
    }

    public static AdvancedProperties convertArrayToProperties(AdvancedProperties properties, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            String key = items[i];
            if (i + 1 == items.length || items[i + 1].startsWith("-")) {
                properties.put(key, TRUE);
                continue;
            }
            String value = items[++i];
            if (key.startsWith("--")) {
                key = key.substring(2);
            } else if (key.startsWith("-")) {
                key = key.substring(1);
            }
            properties.put(key, value);
        }
        return properties;
    }

    public AdvancedProperties() {
    }

    public AdvancedProperties(File fileLocation) throws IOException {
        this(fileLocation, null);
    }

    public AdvancedProperties(File fileLocation, Properties prop) throws IOException {
        super(prop);
        String path = fileLocation.getPath();
        if (path.contains("..") || fileLocation.isAbsolute()) {
            throw new SecurityException("Potential path traversal detected: " + path);
        }
        File canonicalFile = fileLocation.getCanonicalFile();
        try (FileInputStream fs = new FileInputStream(canonicalFile);){
            this.load(fs);
        }
    }

    public AdvancedProperties(Properties prop) {
        super(prop);
    }

    public int asInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public int asInt(String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(key, Integer.toString(defaultValue)));
    }

    public int asInt(String key, String defaultValue) {
        return Integer.parseInt(this.getProperty(key, defaultValue));
    }

    public long asLong(String key) {
        return Long.parseLong(this.getProperty(key));
    }

    public long asLong(String key, long defaultValue) {
        return Long.parseLong(this.getProperty(key, Long.toString(defaultValue)));
    }

    public long asLong(String key, String defaultValue) {
        return Long.parseLong(this.getProperty(key, defaultValue));
    }

    public String asString(String key) {
        return this.getProperty(key);
    }

    public String asString(String key, String defaultValue) {
        return this.getProperty(key, defaultValue);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String prop = super.getProperty(key, defaultValue);
        return prop == null ? null : prop.trim();
    }

    @Override
    public String getProperty(String key) {
        String prop = super.getProperty(key);
        return prop == null ? null : prop.trim();
    }

    public boolean asBool(String key) {
        String value = this.getProperty(key);
        return value.equals("1") || value.equalsIgnoreCase(TRUE);
    }

    public boolean asBool(String key, String defaultValue) {
        String value = this.getProperty(key, defaultValue);
        return value.equals("1") || value.equalsIgnoreCase(TRUE);
    }

    public boolean asBool(String key, boolean defaultValue) {
        return this.asBool(key, Boolean.toString(defaultValue));
    }

    public double asDouble(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            if (!first) {
                sb.append('\n');
            } else {
                first = false;
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    public void importProperties(Properties source) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public void setParent(Properties p) {
        this.defaults = p;
    }
}

