/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.util.stream.IntStream;
import org.firebirdsql.gds.BatchParameterBuffer;

public interface FbBatchConfig {
    public static final boolean CONTINUE_ON_ERROR = true;
    public static final boolean HALT_AT_FIRST_ERROR = false;
    public static final boolean UPDATE_COUNTS = true;
    public static final boolean NO_UPDATE_COUNTS = false;
    public static final int SERVER_DEFAULT_DETAILED_ERRORS = -1;
    public static final int SERVER_MAXIMUM_BUFFER_SIZE = 0;
    public static final int SERVER_DEFAULT_BUFFER_SIZE = -1;

    public boolean multiError();

    public boolean updateCounts();

    public int detailedErrors();

    public int batchBufferSize();

    default public FbBatchConfig immutable() {
        return new Immutable(this);
    }

    public static FbBatchConfig of(boolean multiError, boolean updateCounts, int detailedErrors, int batchBufferSize) {
        return new Immutable(multiError, updateCounts, detailedErrors, batchBufferSize);
    }

    default public void populateBatchParameterBuffer(BatchParameterBuffer batchPb) {
        IntStream.of(1, 2, 5, 3, 4).forEach(batchPb::removeArgument);
        if (this.multiError()) {
            batchPb.addArgument(1, 1);
        }
        if (this.updateCounts()) {
            batchPb.addArgument(2, 1);
        }
        if (this.detailedErrors() >= 0) {
            batchPb.addArgument(5, this.detailedErrors());
        }
        if (this.batchBufferSize() >= 0) {
            batchPb.addArgument(3, this.batchBufferSize());
        }
        batchPb.addArgument(4, 2);
    }

    public static final class Immutable
    implements FbBatchConfig {
        private final boolean multiError;
        private final boolean updateCounts;
        private final int detailedErrors;
        private final int batchBufferSize;

        private Immutable(FbBatchConfig config) {
            this(config.multiError(), config.updateCounts(), config.detailedErrors(), config.batchBufferSize());
        }

        private Immutable(boolean multiError, boolean updateCounts, int detailedErrors, int batchBufferSize) {
            this.multiError = multiError;
            this.updateCounts = updateCounts;
            this.detailedErrors = detailedErrors;
            this.batchBufferSize = batchBufferSize;
        }

        @Override
        public boolean multiError() {
            return this.multiError;
        }

        @Override
        public boolean updateCounts() {
            return this.updateCounts;
        }

        @Override
        public int detailedErrors() {
            return this.detailedErrors;
        }

        @Override
        public int batchBufferSize() {
            return this.batchBufferSize;
        }

        @Override
        public FbBatchConfig immutable() {
            return this;
        }
    }
}

