
#ifndef PLASMAACTIVITIESSTATS_EXPORT_H
#define PLASMAACTIVITIESSTATS_EXPORT_H

#ifdef PLASMAACTIVITIESSTATS_STATIC_DEFINE
#  define PLASMAACTIVITIESSTATS_EXPORT
#  define PLASMAACTIVITIESSTATS_NO_EXPORT
#else
#  ifndef PLASMAACTIVITIESSTATS_EXPORT
#    ifdef PlasmaActivitiesStats_EXPORTS
        /* We are building this library */
#      define PLASMAACTIVITIESSTATS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PLASMAACTIVITIESSTATS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PLASMAACTIVITIESSTATS_NO_EXPORT
#    define PLASMAACTIVITIESSTATS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PLASMAACTIVITIESSTATS_DECL_DEPRECATED
#  define PLASMAACTIVITIESSTATS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PLASMAACTIVITIESSTATS_DECL_DEPRECATED_EXPORT
#  define PLASMAACTIVITIESSTATS_DECL_DEPRECATED_EXPORT PLASMAACTIVITIESSTATS_EXPORT PLASMAACTIVITIESSTATS_DECL_DEPRECATED
#endif

#ifndef PLASMAACTIVITIESSTATS_DECL_DEPRECATED_NO_EXPORT
#  define PLASMAACTIVITIESSTATS_DECL_DEPRECATED_NO_EXPORT PLASMAACTIVITIESSTATS_NO_EXPORT PLASMAACTIVITIESSTATS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PLASMAACTIVITIESSTATS_NO_DEPRECATED
#    define PLASMAACTIVITIESSTATS_NO_DEPRECATED
#  endif
#endif
#include <plasmaactivitiesstats_version.h>

#define PLASMAACTIVITIESSTATS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(PLASMAACTIVITIESSTATS_NO_DEPRECATED)
#  undef PLASMAACTIVITIESSTATS_DEPRECATED
#  define PLASMAACTIVITIESSTATS_DEPRECATED_EXPORT PLASMAACTIVITIESSTATS_EXPORT
#  define PLASMAACTIVITIESSTATS_DEPRECATED_NO_EXPORT PLASMAACTIVITIESSTATS_NO_EXPORT
#elif defined(PLASMAACTIVITIESSTATS_NO_DEPRECATED_WARNINGS)
#  define PLASMAACTIVITIESSTATS_DEPRECATED
#  define PLASMAACTIVITIESSTATS_DEPRECATED_EXPORT PLASMAACTIVITIESSTATS_EXPORT
#  define PLASMAACTIVITIESSTATS_DEPRECATED_NO_EXPORT PLASMAACTIVITIESSTATS_NO_EXPORT
#else
#  define PLASMAACTIVITIESSTATS_DEPRECATED PLASMAACTIVITIESSTATS_DECL_DEPRECATED
#  define PLASMAACTIVITIESSTATS_DEPRECATED_EXPORT PLASMAACTIVITIESSTATS_DECL_DEPRECATED_EXPORT
#  define PLASMAACTIVITIESSTATS_DEPRECATED_NO_EXPORT PLASMAACTIVITIESSTATS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PLASMAACTIVITIESSTATS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PLASMAACTIVITIESSTATS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PLASMAACTIVITIESSTATS_NO_DEPRECATED
#  define PLASMAACTIVITIESSTATS_DISABLE_DEPRECATED_BEFORE_AND_AT PLASMAACTIVITIESSTATS_VERSION
#endif
#ifdef PLASMAACTIVITIESSTATS_NO_DEPRECATED_WARNINGS
#  define PLASMAACTIVITIESSTATS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PLASMAACTIVITIESSTATS_DEPRECATED_WARNINGS_SINCE
#  ifdef PLASMAACTIVITIESSTATS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PLASMAACTIVITIESSTATS_DEPRECATED_WARNINGS_SINCE PLASMAACTIVITIESSTATS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PLASMAACTIVITIESSTATS_DEPRECATED_WARNINGS_SINCE PLASMAACTIVITIESSTATS_VERSION
#  endif
#endif

#ifndef PLASMAACTIVITIESSTATS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PLASMAACTIVITIESSTATS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PLASMAACTIVITIESSTATS_DEPRECATED
#  define PLASMAACTIVITIESSTATS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > PLASMAACTIVITIESSTATS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PLASMAACTIVITIESSTATS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* PLASMAACTIVITIESSTATS_EXPORT_H */
