# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class BackupKeyResult(_Model):
    """The backup key result, containing the backup blob.

    :ivar value: The backup blob containing the backed up key.
    :vartype value: bytes
    """

    value: Optional[bytes] = rest_field(visibility=["read"], format="base64url")
    """The backup blob containing the backed up key."""


class DeletedKeyBundle(_Model):
    """A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info.

    :ivar key: The Json web key.
    :vartype key: ~azure.keyvault.keys._generated.models.JsonWebKey
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~azure.keyvault.keys._generated.models.KeyReleasePolicy
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     key.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the key was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    key: Optional["_models.JsonWebKey"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Json web key."""
    attributes: Optional["_models.KeyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The key management attributes."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    managed: Optional[bool] = rest_field(visibility=["read"])
    """True if the key's lifetime is managed by key vault. If this is a key backing a certificate,
     then managed will be true."""
    release_policy: Optional["_models.KeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy rules under which the key can be exported."""
    recovery_id: Optional[str] = rest_field(
        name="recoveryId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The url of the recovery object, used to identify and recover the deleted key."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the key is scheduled to be purged, in UTC."""
    deleted_date: Optional[datetime.datetime] = rest_field(
        name="deletedDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the key was deleted, in UTC."""

    @overload
    def __init__(
        self,
        *,
        key: Optional["_models.JsonWebKey"] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
        recovery_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeletedKeyItem(_Model):
    """The deleted key item containing the deleted key metadata and information about deletion.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     key.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the key was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    kid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key identifier."""
    attributes: Optional["_models.KeyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The key management attributes."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    managed: Optional[bool] = rest_field(visibility=["read"])
    """True if the key's lifetime is managed by key vault. If this is a key backing a certificate,
     then managed will be true."""
    recovery_id: Optional[str] = rest_field(
        name="recoveryId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The url of the recovery object, used to identify and recover the deleted key."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the key is scheduled to be purged, in UTC."""
    deleted_date: Optional[datetime.datetime] = rest_field(
        name="deletedDate", visibility=["read"], format="unix-timestamp"
    )
    """The time when the key was deleted, in UTC."""

    @overload
    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetRandomBytesRequest(_Model):
    """The get random bytes request object.

    :ivar count: The requested number of random bytes. Required.
    :vartype count: int
    """

    count: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The requested number of random bytes. Required."""

    @overload
    def __init__(
        self,
        *,
        count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JsonWebKey(_Model):
    """As of `http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
    <http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18>`_.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar kty: JsonWebKey Key Type (kty), as defined in
     `https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40
     <https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40>`_. Known values are: "EC",
     "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
    :vartype kty: str or ~azure.keyvault.keys._generated.models.JsonWebKeyType
    :ivar key_ops: Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation.
    :vartype key_ops: list[str]
    :ivar n: RSA modulus.
    :vartype n: bytes
    :ivar e: RSA public exponent.
    :vartype e: bytes
    :ivar d: RSA private exponent, or the D component of an EC private key.
    :vartype d: bytes
    :ivar dp: RSA private key parameter.
    :vartype dp: bytes
    :ivar dq: RSA private key parameter.
    :vartype dq: bytes
    :ivar qi: RSA private key parameter.
    :vartype qi: bytes
    :ivar p: RSA secret prime.
    :vartype p: bytes
    :ivar q: RSA secret prime, with p < q.
    :vartype q: bytes
    :ivar k: Symmetric key.
    :vartype k: bytes
    :ivar t: Protected Key, used with 'Bring Your Own Key'.
    :vartype t: bytes
    :ivar crv: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype crv: str or ~azure.keyvault.keys._generated.models.JsonWebKeyCurveName
    :ivar x: X component of an EC public key.
    :vartype x: bytes
    :ivar y: Y component of an EC public key.
    :vartype y: bytes
    """

    kid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key identifier."""
    kty: Optional[Union[str, "_models.JsonWebKeyType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """JsonWebKey Key Type (kty), as defined in
     `https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40
     <https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40>`_. Known values are:
     \"EC\", \"EC-HSM\", \"RSA\", \"RSA-HSM\", \"oct\", and \"oct-HSM\"."""
    key_ops: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation."""
    n: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA modulus."""
    e: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA public exponent."""
    d: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA private exponent, or the D component of an EC private key."""
    dp: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA private key parameter."""
    dq: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA private key parameter."""
    qi: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA private key parameter."""
    p: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA secret prime."""
    q: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """RSA secret prime, with p < q."""
    k: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Symmetric key."""
    t: Optional[bytes] = rest_field(
        name="key_hsm", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """Protected Key, used with 'Bring Your Own Key'."""
    crv: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are: \"P-256\",
     \"P-384\", \"P-521\", and \"P-256K\"."""
    x: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """X component of an EC public key."""
    y: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Y component of an EC public key."""

    @overload
    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        kty: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_ops: Optional[List[str]] = None,
        n: Optional[bytes] = None,
        e: Optional[bytes] = None,
        d: Optional[bytes] = None,
        dp: Optional[bytes] = None,
        dq: Optional[bytes] = None,
        qi: Optional[bytes] = None,
        p: Optional[bytes] = None,
        q: Optional[bytes] = None,
        k: Optional[bytes] = None,
        t: Optional[bytes] = None,
        crv: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        x: Optional[bytes] = None,
        y: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyAttestation(_Model):
    """The key attestation information.

    :ivar certificate_pem_file: A base64url-encoded string containing certificates in PEM format,
     used for attestation validation.
    :vartype certificate_pem_file: bytes
    :ivar private_key_attestation: The attestation blob bytes encoded as base64url string
     corresponding to a private key.
    :vartype private_key_attestation: bytes
    :ivar public_key_attestation: The attestation blob bytes encoded as base64url string
     corresponding to a public key in case of asymmetric key.
    :vartype public_key_attestation: bytes
    :ivar version: The version of the attestation.
    :vartype version: str
    """

    certificate_pem_file: Optional[bytes] = rest_field(
        name="certificatePemFile", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """A base64url-encoded string containing certificates in PEM format, used for attestation
     validation."""
    private_key_attestation: Optional[bytes] = rest_field(
        name="privateKeyAttestation", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """The attestation blob bytes encoded as base64url string corresponding to a private key."""
    public_key_attestation: Optional[bytes] = rest_field(
        name="publicKeyAttestation", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """The attestation blob bytes encoded as base64url string corresponding to a public key in case of
     asymmetric key."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the attestation."""

    @overload
    def __init__(
        self,
        *,
        certificate_pem_file: Optional[bytes] = None,
        private_key_attestation: Optional[bytes] = None,
        public_key_attestation: Optional[bytes] = None,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyAttributes(_Model):
    """The attributes of a key managed by the key vault service.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recoverable_days: softDelete data retention days. Value should be >=7 and <=90 when
     softDelete enabled, otherwise 0.
    :vartype recoverable_days: int
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for keys in the
     current vault. If it contains 'Purgeable' the key can be permanently deleted by a privileged
     user; otherwise, only the system can purge the key, at the end of the retention interval. Known
     values are: "Purgeable", "Recoverable+Purgeable", "Recoverable",
     "Recoverable+ProtectedSubscription", "CustomizedRecoverable+Purgeable",
     "CustomizedRecoverable", and "CustomizedRecoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.keyvault.keys._generated.models.DeletionRecoveryLevel
    :ivar exportable: Indicates if the private key can be exported. Release policy must be provided
     when creating the first version of an exportable key.
    :vartype exportable: bool
    :ivar hsm_platform: The underlying HSM Platform.
    :vartype hsm_platform: str
    :ivar attestation: The key or key version attestation information.
    :vartype attestation: ~azure.keyvault.keys._generated.models.KeyAttestation
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Determines whether the object is enabled."""
    not_before: Optional[datetime.datetime] = rest_field(
        name="nbf", visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """Not before date in UTC."""
    expires: Optional[datetime.datetime] = rest_field(
        name="exp", visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """Expiry date in UTC."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Creation time in UTC."""
    updated: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """Last updated time in UTC."""
    recoverable_days: Optional[int] = rest_field(name="recoverableDays", visibility=["read"])
    """softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise
     0."""
    recovery_level: Optional[Union[str, "_models.DeletionRecoveryLevel"]] = rest_field(
        name="recoveryLevel", visibility=["read"]
    )
    """Reflects the deletion recovery level currently in effect for keys in the current vault. If it
     contains 'Purgeable' the key can be permanently deleted by a privileged user; otherwise, only
     the system can purge the key, at the end of the retention interval. Known values are:
     \"Purgeable\", \"Recoverable+Purgeable\", \"Recoverable\",
     \"Recoverable+ProtectedSubscription\", \"CustomizedRecoverable+Purgeable\",
     \"CustomizedRecoverable\", and \"CustomizedRecoverable+ProtectedSubscription\"."""
    exportable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates if the private key can be exported. Release policy must be provided when creating the
     first version of an exportable key."""
    hsm_platform: Optional[str] = rest_field(name="hsmPlatform", visibility=["read"])
    """The underlying HSM Platform."""
    attestation: Optional["_models.KeyAttestation"] = rest_field(visibility=["read"])
    """The key or key version attestation information."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        exportable: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyBundle(_Model):
    """A KeyBundle consisting of a WebKey plus its attributes.

    :ivar key: The Json web key.
    :vartype key: ~azure.keyvault.keys._generated.models.JsonWebKey
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~azure.keyvault.keys._generated.models.KeyReleasePolicy
    """

    key: Optional["_models.JsonWebKey"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Json web key."""
    attributes: Optional["_models.KeyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The key management attributes."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    managed: Optional[bool] = rest_field(visibility=["read"])
    """True if the key's lifetime is managed by key vault. If this is a key backing a certificate,
     then managed will be true."""
    release_policy: Optional["_models.KeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy rules under which the key can be exported."""

    @overload
    def __init__(
        self,
        *,
        key: Optional["_models.JsonWebKey"] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyCreateParameters(_Model):
    """The key create parameters.

    :ivar kty: The type of key to create. For valid values, see JsonWebKeyType. Required. Known
     values are: "EC", "EC-HSM", "RSA", "RSA-HSM", "oct", and "oct-HSM".
    :vartype kty: str or ~azure.keyvault.keys._generated.models.JsonWebKeyType
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar public_exponent: The public exponent for a RSA key.
    :vartype public_exponent: int
    :ivar key_ops: Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation.
    :vartype key_ops: list[str or ~azure.keyvault.keys._generated.models.JsonWebKeyOperation]
    :ivar key_attributes: The attributes of a key managed by the key vault service.
    :vartype key_attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve: str or ~azure.keyvault.keys._generated.models.JsonWebKeyCurveName
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~azure.keyvault.keys._generated.models.KeyReleasePolicy
    """

    kty: Union[str, "_models.JsonWebKeyType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of key to create. For valid values, see JsonWebKeyType. Required. Known values are:
     \"EC\", \"EC-HSM\", \"RSA\", \"RSA-HSM\", \"oct\", and \"oct-HSM\"."""
    key_size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key size in bits. For example: 2048, 3072, or 4096 for RSA."""
    public_exponent: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The public exponent for a RSA key."""
    key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation."""
    key_attributes: Optional["_models.KeyAttributes"] = rest_field(
        name="attributes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of a key managed by the key vault service."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = rest_field(
        name="crv", visibility=["read", "create", "update", "delete", "query"]
    )
    """Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are: \"P-256\",
     \"P-384\", \"P-521\", and \"P-256K\"."""
    release_policy: Optional["_models.KeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy rules under which the key can be exported."""

    @overload
    def __init__(
        self,
        *,
        kty: Union[str, "_models.JsonWebKeyType"],
        key_size: Optional[int] = None,
        public_exponent: Optional[int] = None,
        key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyImportParameters(_Model):
    """The key import parameters.

    :ivar hsm: Whether to import as a hardware key (HSM) or software key.
    :vartype hsm: bool
    :ivar key: The Json web key. Required.
    :vartype key: ~azure.keyvault.keys._generated.models.JsonWebKey
    :ivar key_attributes: The key management attributes.
    :vartype key_attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~azure.keyvault.keys._generated.models.KeyReleasePolicy
    """

    hsm: Optional[bool] = rest_field(name="Hsm", visibility=["read", "create", "update", "delete", "query"])
    """Whether to import as a hardware key (HSM) or software key."""
    key: "_models.JsonWebKey" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Json web key. Required."""
    key_attributes: Optional["_models.KeyAttributes"] = rest_field(
        name="attributes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The key management attributes."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    release_policy: Optional["_models.KeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy rules under which the key can be exported."""

    @overload
    def __init__(
        self,
        *,
        key: "_models.JsonWebKey",
        hsm: Optional[bool] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyItem(_Model):
    """The key item containing key metadata.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar attributes: The key management attributes.
    :vartype attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this is a key backing a
     certificate, then managed will be true.
    :vartype managed: bool
    """

    kid: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Key identifier."""
    attributes: Optional["_models.KeyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The key management attributes."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    managed: Optional[bool] = rest_field(visibility=["read"])
    """True if the key's lifetime is managed by key vault. If this is a key backing a certificate,
     then managed will be true."""

    @overload
    def __init__(
        self,
        *,
        kid: Optional[str] = None,
        attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyOperationResult(_Model):
    """The key operation result.

    :ivar kid: Key identifier.
    :vartype kid: str
    :ivar result: The result of the operation.
    :vartype result: bytes
    :ivar iv: Cryptographically random, non-repeating initialization vector for symmetric
     algorithms.
    :vartype iv: bytes
    :ivar authentication_tag: The tag to authenticate when performing decryption with an
     authenticated algorithm.
    :vartype authentication_tag: bytes
    :ivar additional_authenticated_data: Additional data to authenticate but not encrypt/decrypt
     when using authenticated crypto algorithms.
    :vartype additional_authenticated_data: bytes
    """

    kid: Optional[str] = rest_field(visibility=["read"])
    """Key identifier."""
    result: Optional[bytes] = rest_field(name="value", visibility=["read"], format="base64url")
    """The result of the operation."""
    iv: Optional[bytes] = rest_field(visibility=["read"], format="base64url")
    """Cryptographically random, non-repeating initialization vector for symmetric algorithms."""
    authentication_tag: Optional[bytes] = rest_field(name="tag", visibility=["read"], format="base64url")
    """The tag to authenticate when performing decryption with an authenticated algorithm."""
    additional_authenticated_data: Optional[bytes] = rest_field(name="aad", visibility=["read"], format="base64url")
    """Additional data to authenticate but not encrypt/decrypt when using authenticated crypto
     algorithms."""


class KeyOperationsParameters(_Model):
    """The key operations parameters.

    :ivar algorithm: algorithm identifier. Required. Known values are: "RSA-OAEP", "RSA-OAEP-256",
     "RSA1_5", "A128GCM", "A192GCM", "A256GCM", "A128KW", "A192KW", "A256KW", "A128CBC", "A192CBC",
     "A256CBC", "A128CBCPAD", "A192CBCPAD", "A256CBCPAD", "CKM_AES_KEY_WRAP", and
     "CKM_AES_KEY_WRAP_PAD".
    :vartype algorithm: str or ~azure.keyvault.keys._generated.models.JsonWebKeyEncryptionAlgorithm
    :ivar value: The value to operate on. Required.
    :vartype value: bytes
    :ivar iv: Cryptographically random, non-repeating initialization vector for symmetric
     algorithms.
    :vartype iv: bytes
    :ivar aad: Additional data to authenticate but not encrypt/decrypt when using authenticated
     crypto algorithms.
    :vartype aad: bytes
    :ivar tag: The tag to authenticate when performing decryption with an authenticated algorithm.
    :vartype tag: bytes
    """

    algorithm: Union[str, "_models.JsonWebKeyEncryptionAlgorithm"] = rest_field(
        name="alg", visibility=["read", "create", "update", "delete", "query"]
    )
    """algorithm identifier. Required. Known values are: \"RSA-OAEP\", \"RSA-OAEP-256\", \"RSA1_5\",
     \"A128GCM\", \"A192GCM\", \"A256GCM\", \"A128KW\", \"A192KW\", \"A256KW\", \"A128CBC\",
     \"A192CBC\", \"A256CBC\", \"A128CBCPAD\", \"A192CBCPAD\", \"A256CBCPAD\", \"CKM_AES_KEY_WRAP\",
     and \"CKM_AES_KEY_WRAP_PAD\"."""
    value: bytes = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """The value to operate on. Required."""
    iv: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Cryptographically random, non-repeating initialization vector for symmetric algorithms."""
    aad: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """Additional data to authenticate but not encrypt/decrypt when using authenticated crypto
     algorithms."""
    tag: Optional[bytes] = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """The tag to authenticate when performing decryption with an authenticated algorithm."""

    @overload
    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.JsonWebKeyEncryptionAlgorithm"],
        value: bytes,
        iv: Optional[bytes] = None,
        aad: Optional[bytes] = None,
        tag: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyReleaseParameters(_Model):
    """The release key parameters.

    :ivar target_attestation_token: The attestation assertion for the target of the key release.
     Required.
    :vartype target_attestation_token: str
    :ivar nonce: A client provided nonce for freshness.
    :vartype nonce: str
    :ivar enc: The encryption algorithm to use to protected the exported key material. Known values
     are: "CKM_RSA_AES_KEY_WRAP", "RSA_AES_KEY_WRAP_256", and "RSA_AES_KEY_WRAP_384".
    :vartype enc: str or ~azure.keyvault.keys._generated.models.KeyEncryptionAlgorithm
    """

    target_attestation_token: str = rest_field(
        name="target", visibility=["read", "create", "update", "delete", "query"]
    )
    """The attestation assertion for the target of the key release. Required."""
    nonce: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A client provided nonce for freshness."""
    enc: Optional[Union[str, "_models.KeyEncryptionAlgorithm"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption algorithm to use to protected the exported key material. Known values are:
     \"CKM_RSA_AES_KEY_WRAP\", \"RSA_AES_KEY_WRAP_256\", and \"RSA_AES_KEY_WRAP_384\"."""

    @overload
    def __init__(
        self,
        *,
        target_attestation_token: str,
        nonce: Optional[str] = None,
        enc: Optional[Union[str, "_models.KeyEncryptionAlgorithm"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyReleasePolicy(_Model):
    """The policy rules under which the key can be exported.

    :ivar content_type: Content type and version of key release policy.
    :vartype content_type: str
    :ivar immutable: Defines the mutability state of the policy. Once marked immutable, this flag
     cannot be reset and the policy cannot be changed under any circumstances.
    :vartype immutable: bool
    :ivar encoded_policy: Blob encoding the policy rules under which the key can be released. Blob
     must be base64 URL encoded.
    :vartype encoded_policy: bytes
    """

    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Content type and version of key release policy."""
    immutable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Defines the mutability state of the policy. Once marked immutable, this flag cannot be reset
     and the policy cannot be changed under any circumstances."""
    encoded_policy: Optional[bytes] = rest_field(
        name="data", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """Blob encoding the policy rules under which the key can be released. Blob must be base64 URL
     encoded."""

    @overload
    def __init__(
        self,
        *,
        content_type: Optional[str] = None,
        immutable: Optional[bool] = None,
        encoded_policy: Optional[bytes] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyReleaseResult(_Model):
    """The release result, containing the released key.

    :ivar value: A signed object containing the released key.
    :vartype value: str
    """

    value: Optional[str] = rest_field(visibility=["read"])
    """A signed object containing the released key."""


class KeyRestoreParameters(_Model):
    """The key restore parameters.

    :ivar key_bundle_backup: The backup blob associated with a key bundle. Required.
    :vartype key_bundle_backup: bytes
    """

    key_bundle_backup: bytes = rest_field(
        name="value", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """The backup blob associated with a key bundle. Required."""

    @overload
    def __init__(
        self,
        *,
        key_bundle_backup: bytes,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyRotationPolicy(_Model):
    """Management policy for a key.

    :ivar id: The key policy id.
    :vartype id: str
    :ivar lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a key.
     For preview, lifetimeActions can only have two items at maximum: one for rotate, one for
     notify. Notification time would be default to 30 days before expiry and it is not configurable.
    :vartype lifetime_actions: list[~azure.keyvault.keys._generated.models.LifetimeActions]
    :ivar attributes: The key rotation policy attributes.
    :vartype attributes: ~azure.keyvault.keys._generated.models.KeyRotationPolicyAttributes
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The key policy id."""
    lifetime_actions: Optional[List["_models.LifetimeActions"]] = rest_field(
        name="lifetimeActions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actions that will be performed by Key Vault over the lifetime of a key. For preview,
     lifetimeActions can only have two items at maximum: one for rotate, one for notify.
     Notification time would be default to 30 days before expiry and it is not configurable."""
    attributes: Optional["_models.KeyRotationPolicyAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The key rotation policy attributes."""

    @overload
    def __init__(
        self,
        *,
        lifetime_actions: Optional[List["_models.LifetimeActions"]] = None,
        attributes: Optional["_models.KeyRotationPolicyAttributes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyRotationPolicyAttributes(_Model):
    """The key rotation policy attributes.

    :ivar expiry_time: The expiryTime will be applied on the new key version. It should be at least
     28 days. It will be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours:
     PT48H, 1 year and 10 days: P1Y10D.
    :vartype expiry_time: str
    :ivar created: The key rotation policy created time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: The key rotation policy's last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    expiry_time: Optional[str] = rest_field(
        name="expiryTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The expiryTime will be applied on the new key version. It should be at least 28 days. It will
     be in ISO 8601 Format. Examples: 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1 year and 10
     days: P1Y10D."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """The key rotation policy created time in UTC."""
    updated: Optional[datetime.datetime] = rest_field(visibility=["read"], format="unix-timestamp")
    """The key rotation policy's last updated time in UTC."""

    @overload
    def __init__(
        self,
        *,
        expiry_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeySignParameters(_Model):
    """The key operations parameters.

    :ivar algorithm: The signing/verification algorithm identifier. For more information on
     possible algorithm types, see JsonWebKeySignatureAlgorithm. Required. Known values are:
     "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "HS256", "HS384", "HS512", "RSNULL",
     "ES256", "ES384", "ES512", and "ES256K".
    :vartype algorithm: str or ~azure.keyvault.keys._generated.models.JsonWebKeySignatureAlgorithm
    :ivar value: The value to operate on. Required.
    :vartype value: bytes
    """

    algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"] = rest_field(
        name="alg", visibility=["read", "create", "update", "delete", "query"]
    )
    """The signing/verification algorithm identifier. For more information on possible algorithm
     types, see JsonWebKeySignatureAlgorithm. Required. Known values are: \"PS256\", \"PS384\",
     \"PS512\", \"RS256\", \"RS384\", \"RS512\", \"HS256\", \"HS384\", \"HS512\", \"RSNULL\",
     \"ES256\", \"ES384\", \"ES512\", and \"ES256K\"."""
    value: bytes = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """The value to operate on. Required."""

    @overload
    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"],
        value: bytes,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyUpdateParameters(_Model):
    """The key update parameters.

    :ivar key_ops: Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation.
    :vartype key_ops: list[str or ~azure.keyvault.keys._generated.models.JsonWebKeyOperation]
    :ivar key_attributes: The attributes of a key managed by the key vault service.
    :vartype key_attributes: ~azure.keyvault.keys._generated.models.KeyAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar release_policy: The policy rules under which the key can be exported.
    :vartype release_policy: ~azure.keyvault.keys._generated.models.KeyReleasePolicy
    """

    key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Json web key operations. For more information on possible key operations, see
     JsonWebKeyOperation."""
    key_attributes: Optional["_models.KeyAttributes"] = rest_field(
        name="attributes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The attributes of a key managed by the key vault service."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application specific metadata in the form of key-value pairs."""
    release_policy: Optional["_models.KeyReleasePolicy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy rules under which the key can be exported."""

    @overload
    def __init__(
        self,
        *,
        key_ops: Optional[List[Union[str, "_models.JsonWebKeyOperation"]]] = None,
        key_attributes: Optional["_models.KeyAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        release_policy: Optional["_models.KeyReleasePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultError(_Model):
    """The key vault error exception.

    :ivar error: The key vault server error.
    :vartype error: ~azure.keyvault.keys._generated.models.KeyVaultErrorError
    """

    error: Optional["_models.KeyVaultErrorError"] = rest_field(visibility=["read"])
    """The key vault server error."""


class KeyVaultErrorError(_Model):
    """KeyVaultErrorError.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~azure.keyvault.keys._generated.models.KeyVaultErrorError
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    inner_error: Optional["_models.KeyVaultErrorError"] = rest_field(name="innererror", visibility=["read"])
    """The key vault server error."""


class KeyVerifyParameters(_Model):
    """The key verify parameters.

    :ivar algorithm: The signing/verification algorithm. For more information on possible algorithm
     types, see JsonWebKeySignatureAlgorithm. Required. Known values are: "PS256", "PS384", "PS512",
     "RS256", "RS384", "RS512", "HS256", "HS384", "HS512", "RSNULL", "ES256", "ES384", "ES512", and
     "ES256K".
    :vartype algorithm: str or ~azure.keyvault.keys._generated.models.JsonWebKeySignatureAlgorithm
    :ivar digest: The digest used for signing. Required.
    :vartype digest: bytes
    :ivar signature: The signature to be verified. Required.
    :vartype signature: bytes
    """

    algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"] = rest_field(
        name="alg", visibility=["read", "create", "update", "delete", "query"]
    )
    """The signing/verification algorithm. For more information on possible algorithm types, see
     JsonWebKeySignatureAlgorithm. Required. Known values are: \"PS256\", \"PS384\", \"PS512\",
     \"RS256\", \"RS384\", \"RS512\", \"HS256\", \"HS384\", \"HS512\", \"RSNULL\", \"ES256\",
     \"ES384\", \"ES512\", and \"ES256K\"."""
    digest: bytes = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """The digest used for signing. Required."""
    signature: bytes = rest_field(
        name="value", visibility=["read", "create", "update", "delete", "query"], format="base64url"
    )
    """The signature to be verified. Required."""

    @overload
    def __init__(
        self,
        *,
        algorithm: Union[str, "_models.JsonWebKeySignatureAlgorithm"],
        digest: bytes,
        signature: bytes,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVerifyResult(_Model):
    """The key verify result.

    :ivar value: True if the signature is verified, otherwise false.
    :vartype value: bool
    """

    value: Optional[bool] = rest_field(visibility=["read"])
    """True if the signature is verified, otherwise false."""


class LifetimeActions(_Model):
    """Action and its trigger that will be performed by Key Vault over the lifetime of a key.

    :ivar trigger: The condition that will execute the action.
    :vartype trigger: ~azure.keyvault.keys._generated.models.LifetimeActionsTrigger
    :ivar action: The action that will be executed.
    :vartype action: ~azure.keyvault.keys._generated.models.LifetimeActionsType
    """

    trigger: Optional["_models.LifetimeActionsTrigger"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The condition that will execute the action."""
    action: Optional["_models.LifetimeActionsType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The action that will be executed."""

    @overload
    def __init__(
        self,
        *,
        trigger: Optional["_models.LifetimeActionsTrigger"] = None,
        action: Optional["_models.LifetimeActionsType"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LifetimeActionsTrigger(_Model):
    """A condition to be satisfied for an action to be executed.

    :ivar time_after_create: Time after creation to attempt to rotate. It only applies to rotate.
     It will be in ISO 8601 duration format. Example: 90 days : "P90D".
    :vartype time_after_create: str
    :ivar time_before_expiry: Time before expiry to attempt to rotate or notify. It will be in ISO
     8601 duration format. Example: 90 days : "P90D".
    :vartype time_before_expiry: str
    """

    time_after_create: Optional[str] = rest_field(
        name="timeAfterCreate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Time after creation to attempt to rotate. It only applies to rotate. It will be in ISO 8601
     duration format. Example: 90 days : \"P90D\"."""
    time_before_expiry: Optional[str] = rest_field(
        name="timeBeforeExpiry", visibility=["read", "create", "update", "delete", "query"]
    )
    """Time before expiry to attempt to rotate or notify. It will be in ISO 8601 duration format.
     Example: 90 days : \"P90D\"."""

    @overload
    def __init__(
        self,
        *,
        time_after_create: Optional[str] = None,
        time_before_expiry: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LifetimeActionsType(_Model):
    """The action that will be executed.

    :ivar type: The type of the action. The value should be compared case-insensitively. Known
     values are: "Rotate" and "Notify".
    :vartype type: str or ~azure.keyvault.keys._generated.models.KeyRotationPolicyAction
    """

    type: Optional[Union[str, "_models.KeyRotationPolicyAction"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the action. The value should be compared case-insensitively. Known values are:
     \"Rotate\" and \"Notify\"."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.KeyRotationPolicyAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RandomBytes(_Model):
    """The get random bytes response object containing the bytes.

    :ivar value: The bytes encoded as a base64url string. Required.
    :vartype value: bytes
    """

    value: bytes = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64url")
    """The bytes encoded as a base64url string. Required."""

    @overload
    def __init__(
        self,
        *,
        value: bytes,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
