import fs from 'node:fs';
import type { RetryifyAsyncCallOptions, RetryifySyncCallOptions } from 'stubborn-utils';
declare const FS: {
    attempt: {
        chmod: {
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
            (path: fs.PathLike, mode: fs.Mode): Promise<void> | undefined;
        };
        chown: {
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
            (path: fs.PathLike, uid: number, gid: number): Promise<void> | undefined;
        };
        close: {
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
        };
        fsync: {
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
            (fd: number): Promise<void> | undefined;
        };
        mkdir: {
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): Promise<string | undefined> | undefined;
            (path: fs.PathLike, options?: fs.Mode | (fs.MakeDirectoryOptions & {
                recursive?: false | undefined;
            }) | null | undefined): Promise<void> | undefined;
            (path: fs.PathLike, options?: fs.Mode | fs.MakeDirectoryOptions | null | undefined): Promise<string | undefined> | undefined;
        };
        realpath: {
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string> | undefined;
            (path: fs.PathLike, options: fs.BufferEncodingOption): Promise<Buffer> | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): Promise<string | Buffer> | undefined;
        };
        stat: {
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options?: (fs.StatOptions & {
                bigint?: false | undefined;
            }) | undefined): Promise<fs.Stats> | undefined;
            (path: fs.PathLike, options: fs.StatOptions & {
                bigint: true;
            }): Promise<fs.BigIntStats> | undefined;
            (path: fs.PathLike, options?: fs.StatOptions | undefined): Promise<fs.Stats | fs.BigIntStats> | undefined;
        };
        unlink: {
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
            (path: fs.PathLike): Promise<void> | undefined;
        };
        chmodSync: {
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
            (path: fs.PathLike, mode: fs.Mode): void | undefined;
        };
        chownSync: {
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
            (path: fs.PathLike, uid: number, gid: number): void | undefined;
        };
        closeSync: {
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
            (fd: number): void | undefined;
        };
        existsSync: {
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
            (path: fs.PathLike): boolean | undefined;
        };
        fsyncSync: {
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
            (fd: number, callback: fs.NoParamCallback): void | undefined;
        };
        mkdirSync: {
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options: fs.MakeDirectoryOptions & {
                recursive: true;
            }): (string | undefined) | undefined;
            (path: fs.PathLike, options?: fs.Mode | (fs.MakeDirectoryOptions & {
                recursive?: false | undefined;
            }) | null | undefined): void | undefined;
            (path: fs.PathLike, options?: fs.Mode | fs.MakeDirectoryOptions | null | undefined): (string | undefined) | undefined;
        };
        realpathSync: {
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): string | undefined;
            (path: fs.PathLike, options: fs.BufferEncodingOption): Buffer | undefined;
            (path: fs.PathLike, options?: fs.EncodingOption): (string | Buffer) | undefined;
        };
        statSync: {
            (path: fs.PathLike, options?: undefined): fs.Stats | undefined;
            (path: fs.PathLike, options?: undefined): fs.Stats | undefined;
            (path: fs.PathLike, options?: undefined): fs.Stats | undefined;
            (path: fs.PathLike, options?: (fs.StatSyncOptions & {
                bigint?: false | undefined;
                throwIfNoEntry: false;
            }) | undefined): (fs.Stats | undefined) | undefined;
            (path: fs.PathLike, options: fs.StatSyncOptions & {
                bigint: true;
                throwIfNoEntry: false;
            }): (fs.BigIntStats | undefined) | undefined;
            (path: fs.PathLike, options?: (fs.StatSyncOptions & {
                bigint?: false | undefined;
            }) | undefined): fs.Stats | undefined;
            (path: fs.PathLike, options: fs.StatSyncOptions & {
                bigint: true;
            }): fs.BigIntStats | undefined;
            (path: fs.PathLike, options: fs.StatSyncOptions & {
                bigint: boolean;
                throwIfNoEntry?: false | undefined;
            }): (fs.Stats | fs.BigIntStats) | undefined;
            (path: fs.PathLike, options?: fs.StatSyncOptions | undefined): (fs.Stats | fs.BigIntStats | undefined) | undefined;
        };
        unlinkSync: {
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
            (path: fs.PathLike): void | undefined;
        };
    };
    retry: {
        close: (options: RetryifyAsyncCallOptions) => typeof fs.close.__promisify__;
        fsync: (options: RetryifyAsyncCallOptions) => typeof fs.fsync.__promisify__;
        open: (options: RetryifyAsyncCallOptions) => typeof fs.open.__promisify__;
        readFile: (options: RetryifyAsyncCallOptions) => typeof fs.readFile.__promisify__;
        rename: (options: RetryifyAsyncCallOptions) => typeof fs.rename.__promisify__;
        stat: (options: RetryifyAsyncCallOptions) => typeof fs.stat.__promisify__;
        write: (options: RetryifyAsyncCallOptions) => typeof fs.write.__promisify__;
        writeFile: (options: RetryifyAsyncCallOptions) => typeof fs.writeFile.__promisify__;
        closeSync: (options: RetryifySyncCallOptions) => typeof fs.closeSync;
        fsyncSync: (options: RetryifySyncCallOptions) => typeof fs.fsyncSync;
        openSync: (options: RetryifySyncCallOptions) => typeof fs.openSync;
        readFileSync: (options: RetryifySyncCallOptions) => typeof fs.readFileSync;
        renameSync: (options: RetryifySyncCallOptions) => typeof fs.renameSync;
        statSync: (options: RetryifySyncCallOptions) => fs.StatSyncFn;
        writeSync: (options: RetryifySyncCallOptions) => typeof fs.writeSync;
        writeFileSync: (options: RetryifySyncCallOptions) => typeof fs.writeFileSync;
    };
};
export default FS;
export type { RetryifyAsyncCallOptions, RetryifySyncCallOptions };
