/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.BaseMirror;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.ContextKey;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineDispatcher;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineId;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineJob;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineName;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.JavaLangObjectToString;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MethodDelegate;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MethodEvaluator;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfJob;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J9\u0010\u0016\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001dJ3\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CoroutineContext;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/BaseMirror;", "Lcom/sun/jdi/ObjectReference;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfCoroutineContext;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "coroutineNameRef", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CoroutineName;", "coroutineIdRef", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CoroutineId;", "dispatcherRef", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CoroutineDispatcher;", "jobRef", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CoroutineJob;", "getContextElement", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "getGetContextElement", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "getContextElement$delegate", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodDelegate;", "fetchMirror", "value", "coroutineName", "", "coroutineId", "", "dispatcher", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfCoroutineContext;", "getElementValue", "T", "keyProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/ContextKey;", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/ContextKey;)Ljava/lang/Object;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineContext
extends BaseMirror<ObjectReference, MirrorOfCoroutineContext> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final CoroutineName coroutineNameRef;
    @NotNull
    private final CoroutineId coroutineIdRef;
    @NotNull
    private final CoroutineDispatcher dispatcherRef;
    @NotNull
    private final CoroutineJob jobRef;
    @NotNull
    private final MethodDelegate getContextElement$delegate;

    public CoroutineContext(@NotNull DefaultExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("kotlin.coroutines.CombinedContext", context);
        this.coroutineNameRef = new CoroutineName(context);
        this.coroutineIdRef = new CoroutineId(context);
        this.dispatcherRef = new CoroutineDispatcher(context);
        this.jobRef = new CoroutineJob(context);
        this.getContextElement$delegate = new MethodDelegate("get", null, 2, null);
    }

    private final MethodEvaluator<ObjectReference> getGetContextElement() {
        return this.getContextElement$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    protected MirrorOfCoroutineContext fetchMirror(@NotNull ObjectReference value, @NotNull DefaultExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String coroutineName = (String)this.getElementValue(value, context, this.coroutineNameRef);
        Long coroutineId = (Long)this.getElementValue(value, context, this.coroutineIdRef);
        String dispatcher = (String)this.getElementValue(value, context, this.dispatcherRef);
        MirrorOfJob job = (MirrorOfJob)this.getElementValue(value, context, this.jobRef);
        String summary = (String)new JavaLangObjectToString(context).mirror(value, context);
        return new MirrorOfCoroutineContext(coroutineName, coroutineId, dispatcher, job, summary);
    }

    @NotNull
    public final MirrorOfCoroutineContext fetchMirror(@Nullable String coroutineName, @Nullable Long coroutineId, @Nullable String dispatcher, @NotNull ObjectReference value, @NotNull DefaultExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MirrorOfJob job = (MirrorOfJob)this.getElementValue(value, context, this.jobRef);
        String summary = (String)new JavaLangObjectToString(context).mirror(value, context);
        return new MirrorOfCoroutineContext(coroutineName, coroutineId, dispatcher, job, summary);
    }

    private final <T> T getElementValue(ObjectReference value, DefaultExecutionContext context, ContextKey<T> keyProvider) {
        ObjectReference objectReference = keyProvider.key();
        if (objectReference == null) {
            return null;
        }
        ObjectReference key = objectReference;
        Value[] valueArray = new Value[]{key};
        ObjectReference elementValue = this.getGetContextElement().value(value, context, valueArray);
        return (T)keyProvider.mirror(elementValue, context);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CoroutineContext.class, "getContextElement", "getGetContextElement()Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

