/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Reader;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ArchetypeArtifactManager.class)
public class DefaultArchetypeArtifactManager
extends AbstractLogEnabled
implements ArchetypeArtifactManager {
    @Requirement
    private Downloader downloader;
    @Requirement
    private PomManager pomManager;
    private Map<String, File> archetypeCache = new TreeMap<String, File>();

    @Override
    public File getArchetypeFile(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories, ProjectBuildingRequest buildingRequest) throws UnknownArchetype {
        try {
            File archetype = this.getArchetype(groupId, artifactId, version);
            if (archetype == null) {
                archetype = this.downloader.download(groupId, artifactId, version, archetypeRepository, localRepository, repositories, buildingRequest);
                this.setArchetype(groupId, artifactId, version, archetype);
            }
            return archetype;
        }
        catch (DownloadNotFoundException ex) {
            throw new UnknownArchetype(ex);
        }
        catch (DownloadException ex) {
            throw new UnknownArchetype(ex);
        }
    }

    @Override
    public ClassLoader getArchetypeJarLoader(File archetypeFile) throws UnknownArchetype {
        try {
            URL[] urls = new URL[]{archetypeFile.toURI().toURL()};
            return new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            throw new UnknownArchetype(e);
        }
    }

    @Override
    public Model getArchetypePom(File jar) throws XmlPullParserException, UnknownArchetype, IOException {
        try (ZipFile zipFile = this.getArchetypeZipFile(jar);){
            Model model;
            ZipEntry el;
            String pomFileName = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                el = enumeration.nextElement();
                String entry = el.getName();
                if (!entry.startsWith("META-INF") || !entry.endsWith("pom.xml")) continue;
                pomFileName = entry;
            }
            if (pomFileName == null) {
                el = null;
                return el;
            }
            ZipEntry pom = zipFile.getEntry(pomFileName);
            if (pom == null) {
                model = null;
                return model;
            }
            model = this.pomManager.readPom(zipFile.getInputStream(pom));
            return model;
        }
    }

    @Override
    public ZipFile getArchetypeZipFile(File archetypeFile) throws UnknownArchetype {
        try {
            return new ZipFile(archetypeFile);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileSetArchetype(File archetypeFile) {
        this.getLogger().debug("checking fileset archetype status on " + archetypeFile);
        try (ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);){
            boolean bl = this.isFileSetArchetype(zipFile);
            return bl;
        }
        catch (IOException | UnknownArchetype e) {
            this.getLogger().debug(e.toString());
            return false;
        }
    }

    @Override
    public boolean isFileSetArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories, ProjectBuildingRequest buildingRequest) {
        try {
            File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories, buildingRequest);
            return this.isFileSetArchetype(archetypeFile);
        }
        catch (UnknownArchetype e) {
            this.getLogger().debug(e.toString());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOldArchetype(File archetypeFile) {
        this.getLogger().debug("checking old archetype status on " + archetypeFile);
        try (ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);){
            boolean bl = this.isOldArchetype(zipFile);
            return bl;
        }
        catch (IOException | UnknownArchetype e) {
            this.getLogger().debug(e.toString());
            return false;
        }
    }

    @Override
    public boolean isOldArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories, ProjectBuildingRequest buildingRequest) {
        try {
            File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories, buildingRequest);
            return this.isOldArchetype(archetypeFile);
        }
        catch (UnknownArchetype e) {
            this.getLogger().debug(e.toString());
            return false;
        }
    }

    @Override
    public boolean exists(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ProjectBuildingRequest buildingRequest) {
        try {
            File archetype = this.getArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion);
            if (archetype == null) {
                archetype = this.downloader.download(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetypeRepository, localRepository, remoteRepositories, buildingRequest);
                this.setArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetype);
            }
            return archetype.exists();
        }
        catch (DownloadException e) {
            this.getLogger().debug("Archetype " + archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion + " doesn't exist", (Throwable)e);
            return false;
        }
        catch (DownloadNotFoundException e) {
            this.getLogger().debug("Archetype " + archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion + " doesn't exist", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPostGenerationScript(File archetypeFile) throws UnknownArchetype {
        try (ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);){
            Reader reader = this.getDescriptorReader(zipFile, "META-INF/archetype-post-generate.groovy");
            String string = reader == null ? null : IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        try (ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);){
            org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = this.loadFileSetArchetypeDescriptor(zipFile);
            return archetypeDescriptor;
        }
        catch (IOException | XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
    }

    @Override
    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories, ProjectBuildingRequest buildingRequest) throws UnknownArchetype {
        File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories, buildingRequest);
        return this.getFileSetArchetypeDescriptor(archetypeFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getFilesetArchetypeResources(File archetypeFile) throws UnknownArchetype {
        this.getLogger().debug("getFilesetArchetypeResources( \"" + archetypeFile.getAbsolutePath() + "\" )");
        ArrayList<String> archetypeResources = new ArrayList<String>();
        try (ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.getName().startsWith("archetype-resources")) {
                    String resource = entry.getName().substring("archetype-resources".length() + 1);
                    this.getLogger().debug("  - found resource (archetype-resources/)" + resource);
                    archetypeResources.add(resource);
                    continue;
                }
                this.getLogger().debug("  - ignored resource " + entry.getName());
            }
            ArrayList<String> arrayList = archetypeResources;
            return arrayList;
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArchetypeDescriptor getOldArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        try (ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);){
            ArchetypeDescriptor archetypeDescriptor = this.loadOldArchetypeDescriptor(zipFile);
            return archetypeDescriptor;
        }
        catch (IOException | XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
    }

    @Override
    public ArchetypeDescriptor getOldArchetypeDescriptor(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories, ProjectBuildingRequest buildingRequest) throws UnknownArchetype {
        File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories, buildingRequest);
        return this.getOldArchetypeDescriptor(archetypeFile);
    }

    private File getArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        if (this.archetypeCache.containsKey(key)) {
            this.getLogger().debug("Found archetype " + key + " in cache: " + this.archetypeCache.get(key));
            return this.archetypeCache.get(key);
        }
        this.getLogger().debug("Not found archetype " + key + " in cache");
        return null;
    }

    private void setArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, File archetype) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        this.archetypeCache.put(key, archetype);
    }

    private boolean isFileSetArchetype(ZipFile zipFile) throws IOException {
        try (Reader reader = this.getArchetypeDescriptorReader(zipFile);){
            boolean bl = reader != null;
            return bl;
        }
    }

    private boolean isOldArchetype(ZipFile zipFile) throws IOException {
        try (Reader reader = this.getOldArchetypeDescriptorReader(zipFile);){
            boolean bl = reader != null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private org.apache.maven.archetype.metadata.ArchetypeDescriptor loadFileSetArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        try (Reader reader = this.getArchetypeDescriptorReader(zipFile);){
            if (reader == null) {
                org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = null;
                return archetypeDescriptor;
            }
            ArchetypeDescriptorXpp3Reader archetypeReader = new ArchetypeDescriptorXpp3Reader();
            org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = archetypeReader.read(reader, false);
            return archetypeDescriptor;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArchetypeDescriptor loadOldArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        try (Reader reader = this.getOldArchetypeDescriptorReader(zipFile);){
            if (reader == null) {
                ArchetypeDescriptor archetypeDescriptor = null;
                return archetypeDescriptor;
            }
            ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
            ArchetypeDescriptor archetypeDescriptor = builder.build(reader);
            return archetypeDescriptor;
        }
    }

    private Reader getArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        return this.getDescriptorReader(zipFile, "META-INF/maven/archetype-metadata.xml");
    }

    private Reader getOldArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        Reader reader = this.getDescriptorReader(zipFile, "META-INF/maven/archetype.xml");
        if (reader == null) {
            reader = this.getDescriptorReader(zipFile, "META-INF/archetype.xml");
        }
        return reader;
    }

    private Reader getDescriptorReader(ZipFile zipFile, String descriptor) throws IOException {
        ZipEntry entry = this.searchEntry(zipFile, descriptor);
        if (entry == null) {
            return null;
        }
        InputStream is = zipFile.getInputStream(entry);
        if (is == null) {
            throw new IOException("The " + descriptor + " descriptor cannot be read in " + zipFile.getName() + ".");
        }
        return ReaderFactory.newReader((InputStream)is, (String)"UTF-8");
    }

    private ZipEntry searchEntry(ZipFile zipFile, String searchString) {
        this.getLogger().debug("Searching for " + searchString + " inside " + zipFile.getName());
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entryfound = enu.nextElement();
            this.getLogger().debug("  - " + entryfound.getName());
            if (!searchString.equals(entryfound.getName())) continue;
            this.getLogger().debug("Entry found");
            return entryfound;
        }
        return null;
    }
}

