/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class CatalogArchetypeDataSource
extends AbstractLogEnabled
implements ArchetypeDataSource {
    public static final String ARCHETYPE_CATALOG_PROPERTY = "file";

    protected void writeLocalCatalog(ArchetypeCatalog catalog, File catalogFile) throws ArchetypeDataSourceException {
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)catalogFile);){
            ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();
            catalogWriter.write((Writer)writer, catalog);
        }
        catch (IOException e) {
            throw new ArchetypeDataSourceException("Error writing archetype catalog.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArchetypeCatalog readCatalog(Reader reader) throws ArchetypeDataSourceException {
        try (Reader catReader = reader;){
            ArchetypeCatalogXpp3Reader catalogReader = new ArchetypeCatalogXpp3Reader();
            ArchetypeCatalog archetypeCatalog = catalogReader.read(catReader);
            return archetypeCatalog;
        }
        catch (IOException e) {
            throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
        }
        catch (XmlPullParserException e) {
            throw new ArchetypeDataSourceException("Error parsing archetype catalog.", e);
        }
    }
}

