/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;

class SharedFlowTransformer
implements ClassFileTransformer {
    SharedFlowTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (!"kotlinx/coroutines/flow/internal/FlowValueWrapperInternalKt".equals(className)) {
            return classfileBuffer;
        }
        ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 0, loader);
        final boolean[] isLatestStableIjFork = new boolean[]{false};
        byte[] bytes = transformer.accept(new ClassVisitor(589824, transformer.writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                switch (name) {
                    case "debuggerCapture": {
                        isLatestStableIjFork[0] = true;
                        break;
                    }
                    case "wrapInternal": {
                        return new WrapMethodTransformer(mv);
                    }
                    case "unwrapInternal": {
                        return new UnwrapMethodTransformer(mv);
                    }
                }
                return mv;
            }
        }, 0, false);
        if (!isLatestStableIjFork[0]) {
            return classfileBuffer;
        }
        CaptureAgent.storeClassForDebug(className, bytes);
        return bytes;
    }

    private static class UnwrapMethodTransformer
    extends MethodVisitor {
        public UnwrapMethodTransformer(MethodVisitor mv) {
            super(589824, mv);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "kotlinx/coroutines/flow/internal/FlowValueWrapperInternalKt", "unwrapInternalDebuggerCapture", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            this.mv.visitInsn(176);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitMaxs(1, 1);
            this.mv.visitEnd();
        }
    }

    private static class WrapMethodTransformer
    extends MethodVisitor {
        public WrapMethodTransformer(MethodVisitor mv) {
            super(589824, mv);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "kotlinx/coroutines/flow/internal/FlowValueWrapperInternalKt", "wrapInternalDebuggerCapture", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            this.mv.visitInsn(176);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitMaxs(1, 1);
            this.mv.visitEnd();
        }
    }
}

