/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u000fH\u0014J!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "elementName", "", "referrerCall", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClass;Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "removeRedundantSamConstructor", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddFunModifierFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFunModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n213#2:85\n213#2:87\n1#3:86\n*S KotlinDebug\n*F\n+ 1 AddFunModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix\n*L\n48#1:85\n49#1:87\n*E\n"})
public final class AddFunModifierFix
extends AddModifierFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private final SmartPsiElementPointer<KtCallExpression> referrerCall;

    public AddFunModifierFix(@NotNull KtClass element, @NotNull String elementName, @NotNull SmartPsiElementPointer<KtCallExpression> referrerCall) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        Intrinsics.checkNotNullParameter(referrerCall, (String)"referrerCall");
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)element;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FUN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"FUN_KEYWORD");
        super(ktModifierListOwner, ktModifierKeywordToken);
        this.elementName = elementName;
        this.referrerCall = referrerCall;
    }

    @Override
    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtModifierListOwner element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{this.elementName};
        Presentation presentation = Presentation.of((String)KotlinBundle.message((String)"add.fun.modifier.to.0", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @Override
    protected void invoke(@NotNull ActionContext context, @NotNull KtModifierListOwner element, @NotNull ModPsiUpdater updater2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtCallExpression writableReferrerCall = (KtCallExpression)updater2.getWritable(this.referrerCall.getElement());
            super.invoke(context, element, updater2);
            KtCallExpression ktCallExpression = writableReferrerCall;
            if (ktCallExpression == null) break block0;
            this.removeRedundantSamConstructor(ktCallExpression);
        }
    }

    private final void removeRedundantSamConstructor(KtCallExpression $this$removeRedundantSamConstructor) {
        Object object;
        block7: {
            block6: {
                List list2 = $this$removeRedundantSamConstructor.getLambdaArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
                if (CollectionsKt.singleOrNull((List)list2) == null) {
                    return;
                }
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$removeRedundantSamConstructor;
                boolean $i$f$getStrictParentOfType = false;
                object = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtValueArgument.class, (boolean)true);
                if (object == null) break block6;
                KtValueArgument it = $i$f$getStrictParentOfType = object;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getArgumentExpression(), (Object)$this$removeRedundantSamConstructor) ? $i$f$getStrictParentOfType : null;
                if (object != null) break block7;
            }
            return;
        }
        KtValueArgument argument2 = object;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)argument2;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression parentCall = ktCallExpression;
        KotlinPsiModificationUtils.replaceSamConstructorCall($this$removeRedundantSamConstructor);
        if (PsiModificationUtilsKt.canMoveLambdaOutsideParentheses$default(parentCall, false, 1, null)) {
            ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)parentCall, () -> AddFunModifierFix.removeRedundantSamConstructor$lambda$1(parentCall));
        }
    }

    private static final Unit removeRedundantSamConstructor$lambda$1(KtCallExpression $parentCall) {
        KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses$default($parentCall, null, 1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isSamInterface", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters3 casted = (DiagnosticWithParameters3)Errors.RESOLUTION_TO_CLASSIFIER.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement = casted.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
            KtReferenceExpression referrer = (KtReferenceExpression)psiElement;
            if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)referrer).getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_1_4) < 0) {
                return null;
            }
            PsiElement psiElement2 = referrer.getParent();
            KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression referrerCall = ktCallExpression;
            List list2 = referrerCall.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
            if (!(CollectionsKt.singleOrNull((List)list2) instanceof KtLambdaArgument)) {
                return null;
            }
            Object object = casted.getA();
            ClassDescriptor classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor referenceClassDescriptor = classDescriptor;
            if (referenceClassDescriptor.isFun() || !this.isSamInterface(referenceClassDescriptor)) {
                return null;
            }
            SourceElement sourceElement = referenceClassDescriptor.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
            PsiElement psiElement3 = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
            KtClass ktClass = psiElement3 instanceof KtClass ? (KtClass)psiElement3 : null;
            if (ktClass == null) {
                return null;
            }
            KtClass referenceClass = ktClass;
            String string = referenceClass.getName();
            if (string == null) {
                return null;
            }
            String referenceClassName = string;
            return new AddFunModifierFix(referenceClass, referenceClassName, (SmartPsiElementPointer<KtCallExpression>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)referrerCall))).asIntention();
        }

        private final boolean isSamInterface(ClassDescriptor $this$isSamInterface) {
            if ($this$isSamInterface.getKind() != ClassKind.INTERFACE) {
                return false;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((List)SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)$this$isSamInterface));
            if (callableMemberDescriptor == null) {
                return false;
            }
            CallableMemberDescriptor singleAbstractMember = callableMemberDescriptor;
            return singleAbstractMember instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)singleAbstractMember).getTypeParameters().isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

