/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.applet.BasicAppletContext;
import org.assertj.swing.applet.BasicAppletStub;
import org.assertj.swing.applet.StatusDisplay;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;

public class AppletViewer
extends JFrame
implements StatusDisplay {
    private static final long serialVersionUID = 5187805904213837898L;
    private static final Dimension DEFAULT_SIZE = new Dimension(100, 100);
    private final JLabel statusLabel = new JLabel();
    private final Applet applet;
    private transient AppletStub stub;
    private boolean loaded;

    @Nonnull
    @RunsInEDT
    public static AppletViewer newViewer(@Nonnull Applet applet) {
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(new BasicAppletStub(viewer, new BasicAppletContext(viewer)));
        return viewer;
    }

    @Nonnull
    @RunsInEDT
    public static AppletViewer newViewer(@Nonnull Applet applet, @Nonnull Map<String, String> parameters) {
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(new BasicAppletStub(viewer, new BasicAppletContext(viewer), parameters));
        return viewer;
    }

    @RunsInEDT
    public static AppletViewer newViewer(@Nonnull Applet applet, @Nonnull AppletStub stub) {
        Preconditions.checkNotNull((Object)applet);
        AppletViewer viewer = AppletViewer.createInEDT(applet);
        viewer.appletStub(stub);
        return viewer;
    }

    @RunsInEDT
    private static AppletViewer createInEDT(@Nonnull Applet applet) {
        return GuiActionRunner.execute(() -> new AppletViewer(applet));
    }

    private AppletViewer(@Nonnull Applet applet) {
        this.applet = (Applet)Preconditions.checkNotNull((Object)applet);
        this.setUpFrame();
        this.addContent();
    }

    private void setUpFrame() {
        this.setTitle(Strings.concat((Object[])new Object[]{"Applet Viewer: ", this.applet.getClass().getName()}));
        this.setSize(DEFAULT_SIZE);
        this.setLayout(new BorderLayout());
    }

    private void addContent() {
        this.add((Component)this.applet, "Center");
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.statusLabel.setName("status");
        this.add((Component)this.statusLabel, "South");
    }

    private void appletStub(@Nonnull AppletStub newAppletStub) {
        Preconditions.checkNotNull((Object)newAppletStub);
        this.stub = newAppletStub;
        this.applet.setStub(this.stub);
        this.setUpApplet();
    }

    private void setUpApplet() {
        this.loadApplet();
        this.showStatus("Applet loaded");
    }

    public void reloadApplet() {
        if (this.loaded) {
            this.unloadApplet();
        }
        this.loadApplet();
    }

    private void loadApplet() {
        this.applet.init();
        this.applet.start();
        this.loaded = true;
    }

    public void unloadApplet() {
        this.applet.stop();
        this.applet.destroy();
        this.loaded = false;
    }

    public boolean appletLoaded() {
        return this.loaded;
    }

    @Override
    @RunsInEDT
    public void showStatus(final @Nonnull String status) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setStatus(status);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppletViewer.this.setStatus(status);
            }
        });
    }

    @RunsInCurrentThread
    private void setStatus(@Nonnull String status) {
        this.statusLabel.setText(status);
    }

    @Nonnull
    public Applet getApplet() {
        return this.applet;
    }

    @Nonnull
    public AppletStub getAppletStub() {
        return this.stub;
    }
}

