/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSupport;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011J \u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J(\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010#\u001a\u00020\"*\u00020\u0014H\u0002J<\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u00142\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010*\u001a\u00020+H\u0002J6\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u00142\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u00102\u001a\u00020\u0013H\u0002J*\u00103\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010.\u001a\u0004\u0018\u00010/2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u000304H\u0002J\u001e\u00105\u001a\u00020\u0019\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011J.\u00106\u001a\n 7*\u0004\u0018\u00010\u00130\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u00108\u001a\u00020\u00132\b\u00109\u001a\u0004\u0018\u00010\u0013H\u0002JJ\u0010:\u001a\u00020\u0019\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010;\u001a\u00020<2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010=\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\b\u0010>\u001a\u0004\u0018\u00010\u0013H\u0002J@\u0010?\u001a\u00020\u0019\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010@\u001a\u00020A2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010=\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0002J:\u0010B\u001a\u0004\u0018\u00010\u0013\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u00102\u001a\u00020\u0013H\u0002J:\u0010C\u001a\u0004\u0018\u00010\u0013\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010@\u001a\u00020A2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010D\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "builderInferenceSupport", "Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "inferTypeArguments", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "typeInSystem", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "type", "addExpectedTypeForExplicitCast", "", "builder", "addValidityConstraintsForConstituentTypes", "addValidityConstraintsForTypeArgument", "substitutedArgument", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "boundsSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "compositeSubstitutor", "addConstraintForValueArgument", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "substitutor", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/util/ResolveArgumentsMode;", "addConstraintForNestedCall", "", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constraintPosition", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "effectiveExpectedType", "updateResultTypeForSmartCasts", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "completeTypeInferenceDependentOnFunctionArgumentsForCall", "estimateLiteralReturnType", "kotlin.jvm.PlatformType", "literalExpectedType", "ownerReturnType", "addConstraintForFunctionLiteralArgument", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "constraintSystem", "argumentOwnerReturnType", "addConstraintForCallableReference", "callableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "getExpectedTypeForCallableReference", "getResolvedTypeForCallableReference", "expectedType", "frontend"})
@SourceDebugExtension(value={"SMAP\nGenericCandidateResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericCandidateResolver.kt\norg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,534:1\n1878#2,3:535\n1761#2,3:538\n1617#2,9:541\n1869#2:550\n1870#2:552\n1626#2:553\n1#3:551\n*S KotlinDebug\n*F\n+ 1 GenericCandidateResolver.kt\norg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver\n*L\n159#1:535,3\n259#1:538,3\n264#1:541,9\n264#1:550\n264#1:552\n264#1:553\n264#1:551\n*E\n"})
public final class GenericCandidateResolver {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final BuilderInferenceSupport builderInferenceSupport;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public GenericCandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull BuilderInferenceSupport builderInferenceSupport, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(builderInferenceSupport, "builderInferenceSupport");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        this.argumentTypeResolver = argumentTypeResolver;
        this.builderInferenceSupport = builderInferenceSupport;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(@NotNull CallCandidateResolutionContext<D> context) {
        Intrinsics.checkNotNullParameter(context, "context");
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkNotNullExpressionValue(mutableResolvedCall, "candidateCall");
        MutableResolvedCall candidateCall = mutableResolvedCall;
        Object d = candidateCall.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, "getCandidateDescriptor(...)");
        Object candidate2 = d;
        ConstraintSystemBuilderImpl builder = new ConstraintSystemBuilderImpl(null, 1, null);
        ConstraintSystem.Builder builder2 = builder;
        Call call2 = candidateCall.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        CallHandle callHandle = TypeVariableKt.toHandle(call2);
        List<TypeParameterDescriptor> list = candidate2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        ConstraintSystem.Builder.registerTypeVariables$default(builder2, callHandle, list, false, 4, null);
        List<TypeParameterDescriptor> list2 = candidate2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        Collection collection = list2;
        SimpleType simpleType = TypeUtils.DONT_CARE;
        Intrinsics.checkNotNullExpressionValue(simpleType, "DONT_CARE");
        TypeSubstitutor substituteDontCare = GenericCandidateResolverKt.makeConstantSubstitutor(collection, simpleType);
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = candidateCall.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, "getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor candidateParameter = entry.getKey();
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidate2.getValueParameters().get(candidateParameter.getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                Intrinsics.checkNotNull(valueArgument);
                Intrinsics.checkNotNull(valueParameterDescriptor);
                this.addConstraintForValueArgument(valueArgument, valueParameterDescriptor, substituteDontCare, builder, context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            }
        }
        if (candidate2 instanceof TypeAliasConstructorDescriptor) {
            KotlinType kotlinType = this.compositeSubstitutor(builder).safeSubstitute(((TypeAliasConstructorDescriptor)candidate2).getReturnType(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue(kotlinType, "safeSubstitute(...)");
            KotlinType substitutedReturnType = kotlinType;
            this.addValidityConstraintsForConstituentTypes(builder, substitutedReturnType);
        }
        ReceiverValue receiverArgument = candidateCall.getExtensionReceiver();
        ReceiverParameterDescriptor receiverParameter = candidate2.getExtensionReceiverParameter();
        if (receiverArgument != null && receiverParameter != null) {
            KotlinType receiverType;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            KotlinType receiverArgumentType = kotlinType;
            Call call3 = context.candidateCall.getCall();
            Intrinsics.checkNotNullExpressionValue(call3, "getCall(...)");
            KotlinType kotlinType2 = receiverType = CallUtilKt.isSafeCall(call3) ? TypeUtils.makeNotNullable(receiverArgumentType) : receiverArgumentType;
            if (receiverArgument instanceof ExpressionReceiver) {
                receiverType = this.updateResultTypeForSmartCasts(receiverType, ((ExpressionReceiver)receiverArgument).getExpression(), (ResolutionContext)context);
            }
            builder.addSubtypeConstraint(receiverType, this.compositeSubstitutor(builder).substitute(receiverParameter.getType(), Variance.INVARIANT), ConstraintPositionKind.RECEIVER_POSITION.position());
        }
        ConstraintSystem constraintSystem = builder.build();
        candidateCall.setConstraintSystem(constraintSystem);
        boolean hasContradiction = constraintSystem.getStatus().hasContradiction();
        if (!hasContradiction) {
            this.addExpectedTypeForExplicitCast(context, builder);
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        return ResolutionStatus.OTHER_ERROR;
    }

    private final KotlinType typeInSystem(ConstraintSystem.Builder $this$typeInSystem, Call call2, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            TypeSubstitutor typeSubstitutor2 = $this$typeInSystem.getTypeVariableSubstitutors().get(TypeVariableKt.toHandle(call2));
            kotlinType = typeSubstitutor2 != null ? typeSubstitutor2.substitute(it, Variance.INVARIANT) : null;
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    private final void addExpectedTypeForExplicitCast(CallCandidateResolutionContext<?> context, ConstraintSystem.Builder builder) {
        KotlinType expectedType;
        IElementType iElementType;
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ExpectedTypeFromCast)) {
            return;
        }
        if (context.candidateCall instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object d = context.candidateCall.getCandidateDescriptor();
        FunctionDescriptor functionDescriptor = d instanceof FunctionDescriptor ? (FunctionDescriptor)d : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor candidateDescriptor = functionDescriptor;
        KtExpression ktExpression = context.call.getCalleeExpression();
        if (ktExpression == null || (ktExpression = KtPsiUtilKt.getBinaryWithTypeParent(ktExpression)) == null) {
            return;
        }
        KtExpression binaryParent = ktExpression;
        IElementType it = iElementType = ((KtBinaryExpressionWithTypeRHS)binaryParent).getOperationReference().getReferencedNameElementType();
        boolean bl = false;
        IElementType iElementType2 = Intrinsics.areEqual(it, KtTokens.AS_KEYWORD) || Intrinsics.areEqual(it, KtTokens.AS_SAFE) ? iElementType : null;
        if (iElementType2 == null) {
            return;
        }
        IElementType operationType = iElementType2;
        KtTypeReference ktTypeReference = ((KtBinaryExpressionWithTypeRHS)binaryParent).getRight();
        if (ktTypeReference == null) {
            return;
        }
        KotlinType kotlinType = (KotlinType)context.trace.get(BindingContext.TYPE, ktTypeReference);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        KotlinType kotlinType2 = expectedType = Intrinsics.areEqual(operationType, KtTokens.AS_SAFE) ? TypeUtilsKt.makeNullable(leftType) : leftType;
        if (context.candidateCall.getCall().getTypeArgumentList() != null || !KtDescriptorUtilKt.isFunctionForExpectTypeFromCastFeature(candidateDescriptor)) {
            return;
        }
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        KotlinType kotlinType3 = candidateDescriptor.getReturnType();
        if (kotlinType3 == null) {
            return;
        }
        KotlinType kotlinType4 = this.typeInSystem(builder, call2, kotlinType3);
        if (kotlinType4 == null) {
            return;
        }
        KotlinType typeInSystem = kotlinType4;
        context.trace.record(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, binaryParent);
        builder.addSubtypeConstraint(typeInSystem, expectedType, ConstraintPositionKind.SPECIAL.position());
    }

    /*
     * WARNING - void declaration
     */
    private final void addValidityConstraintsForConstituentTypes(ConstraintSystem.Builder builder, KotlinType type2) {
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (typeConstructor2.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return;
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        TypeSubstitutor boundsSubstitutor = typeSubstitutor2;
        Iterable $this$forEachIndexed$iv = type2.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeProjection;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv;
            int i = n;
            boolean bl = false;
            if (typeProjection.isStarProjection()) continue;
            TypeParameterDescriptor typeParameter = typeConstructor2.getParameters().get(i);
            Intrinsics.checkNotNull(typeParameter);
            this.addValidityConstraintsForTypeArgument(builder, (TypeProjection)typeProjection, typeParameter, boundsSubstitutor);
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            this.addValidityConstraintsForConstituentTypes(builder, kotlinType);
        }
    }

    private final void addValidityConstraintsForTypeArgument(ConstraintSystem.Builder builder, TypeProjection substitutedArgument, TypeParameterDescriptor typeParameter, TypeSubstitutor boundsSubstitutor) {
        KotlinType kotlinType = substitutedArgument.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType substitutedType = kotlinType;
        for (KotlinType upperBound : typeParameter.getUpperBounds()) {
            KotlinType kotlinType2 = boundsSubstitutor.safeSubstitute(upperBound, Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "safeSubstitute(...)");
            SimpleType substitutedUpperBound = FlexibleTypesKt.upperIfFlexible(kotlinType2);
            ValidityConstraintForConstituentType constraintPosition = new ValidityConstraintForConstituentType(substitutedType, typeParameter, substitutedUpperBound);
            if (KotlinBuiltIns.isNullableAny(substitutedUpperBound)) continue;
            builder.addSubtypeConstraint(substitutedType, substitutedUpperBound, constraintPosition);
        }
    }

    private final TypeSubstitutor compositeSubstitutor(ConstraintSystem.Builder $this$compositeSubstitutor) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeSubstitution($this$compositeSubstitutor){
            final /* synthetic */ ConstraintSystem.Builder $this_compositeSubstitutor;
            {
                this.$this_compositeSubstitutor = $receiver;
            }

            public TypeProjection get(KotlinType key) {
                Intrinsics.checkNotNullParameter(key, "key");
                return SequencesKt.firstOrNull(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)CollectionsKt.reversed((Iterable)this.$this_compositeSubstitutor.getTypeVariableSubstitutors().values())), arg_0 -> compositeSubstitutor.1.get$lambda$0(key, arg_0)));
            }

            private static final TypeProjection get$lambda$0(KotlinType $key, TypeSubstitutor it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getSubstitution().get($key);
            }
        });
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        return typeSubstitutor2;
    }

    private final void addConstraintForValueArgument(ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, TypeSubstitutor substitutor2, ConstraintSystem.Builder builder, CallCandidateResolutionContext<?> context, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context);
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        KotlinType expectedType = substitutor2.substitute(effectiveExpectedType, Variance.INVARIANT);
        DataFlowInfo dataFlowInfo = context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "getInfo(...)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        Object Context2 = ((CallCandidateResolutionContext)context.replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceDataFlowInfo(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        KotlinType kotlinType = expectedType;
        KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies, kotlinType != null ? FunctionTypesKt.isSuspendFunctionType(kotlinType) : false);
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getArgumentTypeInfo(...)");
        KotlinTypeInfo typeInfoForCall = kotlinTypeInfo;
        context.candidateCall.getDataFlowInfoForArguments().updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        ConstraintPosition constraintPosition = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (this.addConstraintForNestedCall(argumentExpression, constraintPosition, builder, newContext, effectiveExpectedType)) {
            return;
        }
        KotlinType kotlinType2 = typeInfoForCall.getType();
        Object Context3 = context.replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkNotNullExpressionValue(Context3, "replaceDataFlowInfo(...)");
        KotlinType type2 = this.updateResultTypeForSmartCasts(kotlinType2, argumentExpression, (ResolutionContext<?>)Context3);
        if (argumentExpression instanceof KtCallableReferenceExpression && type2 == null) {
            return;
        }
        builder.addSubtypeConstraint(type2, this.compositeSubstitutor(builder).substitute(effectiveExpectedType, Variance.INVARIANT), constraintPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addConstraintForNestedCall(KtExpression argumentExpression, ConstraintPosition constraintPosition, ConstraintSystem.Builder builder, CallCandidateResolutionContext<?> context, KotlinType effectiveExpectedType) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        KotlinType returnType;
        Object candidateDescriptor;
        ResolvedCall nestedCall;
        block9: {
            OverloadResolutionResultsImpl<?> resolutionResults;
            ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(argumentExpression, (ResolutionContext)context);
            OverloadResolutionResultsImpl<Object> overloadResolutionResultsImpl = resolutionResults = cachedData != null ? cachedData.getResolutionResults() : null;
            if (resolutionResults == null || !resolutionResults.isSingleResult()) {
                return false;
            }
            ResolvedCall resolvedCall2 = resolutionResults.getResultingCall();
            Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getResultingCall(...)");
            nestedCall = resolvedCall2;
            if (nestedCall.isCompleted()) {
                return false;
            }
            ConstraintSystem constraintSystem = nestedCall.getConstraintSystem();
            if (constraintSystem == null) {
                return false;
            }
            ConstraintSystem nestedConstraintSystem = constraintSystem;
            Object d = nestedCall.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue(d, "getCandidateDescriptor(...)");
            candidateDescriptor = d;
            KotlinType kotlinType = candidateDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            returnType = kotlinType;
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(nestedConstraintSystem, returnType);
            Iterable $this$any$iv = nestedTypeVariables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !nestedConstraintSystem.getTypeBounds(it).getBounds().isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidateDescriptor);
        List<TypeParameterDescriptor> list = candidateDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        Iterable iterable = list;
        List<TypeParameterDescriptor> list2 = candidateWithFreshVariables.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        Map conversion = MapsKt.toMap(CollectionsKt.zip(iterable, (Iterable)list2));
        Iterable $this$mapNotNull$iv = ConstraintSystemUtilsKt.getNestedTypeParameters(returnType);
        boolean $i$f$mapNotNull = false;
        Iterable bl2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl5 = false;
            if ((TypeParameterDescriptor)conversion.get(it) == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List freshVariables = (List)destination$iv$iv;
        Call call2 = nestedCall.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        builder.registerTypeVariables(TypeVariableKt.toHandle(call2), freshVariables, true);
        KotlinType argumentExpressionType = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(nestedCall, candidateWithFreshVariables.getReturnType(), (CallResolutionContext)context);
        builder.addSubtypeConstraint(argumentExpressionType, this.compositeSubstitutor(builder).substitute(effectiveExpectedType, Variance.INVARIANT), constraintPosition);
        return true;
    }

    private final KotlinType updateResultTypeForSmartCasts(KotlinType type2, KtExpression argumentExpression, ResolutionContext<?> context) {
        KtExpression deparenthesizedArgument = KtPsiUtil.getLastElementDeparenthesized(argumentExpression, context.statementFilter);
        if (deparenthesizedArgument == null || type2 == null) {
            return type2;
        }
        DataFlowValue dataFlowValue = this.dataFlowValueFactory.createDataFlowValue(deparenthesizedArgument, type2, context);
        if (!dataFlowValue.isStable()) {
            return type2;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        Set<KotlinType> possibleTypes = dataFlowInfo.getCollectedTypes(dataFlowValue, languageVersionSettings);
        if (possibleTypes.isEmpty()) {
            return type2;
        }
        return TypeIntersector.intersectTypes((Collection<KotlinType>)SetsKt.plus(possibleTypes, type2));
    }

    public final <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionArgumentsForCall(@NotNull CallCandidateResolutionContext<D> context) {
        Intrinsics.checkNotNullParameter(context, "context");
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkNotNullExpressionValue(mutableResolvedCall, "candidateCall");
        MutableResolvedCall resolvedCall2 = mutableResolvedCall;
        Object object = resolvedCall2.getConstraintSystem();
        if (object == null || (object = ConstraintSystem.toBuilder$default((ConstraintSystem)object, null, 1, null)) == null) {
            return;
        }
        Object constraintSystem = object;
        CallCandidateResolutionContext newContext = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? CallCandidateResolutionContext.create(resolvedCall2, context, context.trace, context.tracing, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall().getCall(), context.candidateResolveMode) : context;
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, "getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor valueParameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtCallableReferenceExpression callableReference;
                CallCandidateResolutionContext temporaryContextForCall;
                CallCandidateResolutionContext callCandidateResolutionContext;
                KtExpression argumentExpression;
                if (valueArgument.getArgumentExpression() == null) continue;
                boolean bl = false;
                if (ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(argumentExpression, newContext) != null) {
                    KtFunction functionLiteral;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(valueArgument);
                    Intrinsics.checkNotNull(valueParameterDescriptor);
                    Intrinsics.checkNotNull(newContext);
                    this.addConstraintForFunctionLiteralArgument(functionLiteral, valueArgument, valueParameterDescriptor, (ConstraintSystem.Builder)constraintSystem, newContext, resolvedCall2.getCandidateDescriptor().getReturnType());
                }
                if (GenericCandidateResolverKt.getSPECIAL_FUNCTION_NAMES().contains(((Named)resolvedCall2.getCandidateDescriptor()).getName())) {
                    callCandidateResolutionContext = newContext;
                } else {
                    TemporaryBindingTrace temporaryBindingTrace;
                    Intrinsics.checkNotNullExpressionValue(TemporaryBindingTrace.create(newContext.trace, "Trace to complete argument for call that might be not resulting call"), "create(...)");
                    callCandidateResolutionContext = temporaryContextForCall = (CallCandidateResolutionContext)newContext.replaceBindingTrace(temporaryBindingTrace);
                }
                if (ArgumentTypeResolver.getCallableReferenceExpressionIfAny(argumentExpression, newContext) == null) continue;
                boolean bl3 = false;
                Intrinsics.checkNotNull(valueArgument);
                Intrinsics.checkNotNull(valueParameterDescriptor);
                Intrinsics.checkNotNull(temporaryContextForCall);
                this.addConstraintForCallableReference(callableReference, valueArgument, valueParameterDescriptor, (ConstraintSystem.Builder)constraintSystem, temporaryContextForCall);
            }
        }
        ConstraintSystem resultingSystem = constraintSystem.build();
        resolvedCall2.setConstraintSystem(resultingSystem);
        boolean isNewInferenceEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        TypeSubstitutor typeSubstitutor2 = isNewInferenceEnabled ? resultingSystem.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : resultingSystem.getResultingSubstitutor();
        Intrinsics.checkNotNull(typeSubstitutor2);
        TypeSubstitutor resultingSubstitutor = typeSubstitutor2;
        resolvedCall2.setSubstitutor(resultingSubstitutor);
    }

    private final KotlinType estimateLiteralReturnType(CallCandidateResolutionContext<?> context, KotlinType literalExpectedType, KotlinType ownerReturnType) {
        return !TypeUtils.noExpectedType(context.expectedType) && ownerReturnType != null && TypeUtils.isTypeParameter(ownerReturnType) && FunctionTypesKt.isFunctionTypeOrSubtype(literalExpectedType) && Intrinsics.areEqual(CallResolverUtilKt.getReturnTypeForCallable(literalExpectedType), ownerReturnType) ? context.expectedType : (KotlinType)TypeUtils.DONT_CARE;
    }

    private final <D extends CallableDescriptor> void addConstraintForFunctionLiteralArgument(KtFunction functionLiteral, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context, KotlinType argumentOwnerReturnType) {
        TypeSubstitutor currentSubstitutor;
        TypeSubstitution typeSubstitution;
        DelegatedTypeSubstitution newSubstitution2;
        KotlinType expectedType;
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context);
        if (BuilderInferenceUtilKt.isBuilderInferenceCall(valueParameterDescriptor, valueArgument, this.languageVersionSettings)) {
            this.builderInferenceSupport.analyzeBuilderInferenceCall(functionLiteral, valueArgument, constraintSystem, context, effectiveExpectedType);
        }
        if ((expectedType = (newSubstitution2 = new DelegatedTypeSubstitution(typeSubstitution = (currentSubstitutor = constraintSystem.build().getCurrentSubstitutor()).getSubstitution()){
            {
                Intrinsics.checkNotNull($super_call_param$1);
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        }).buildSubstitutor().substitute(effectiveExpectedType, Variance.IN_VARIANCE)) == null || TypeUtils.isDontCarePlaceholder(expectedType)) {
            KotlinType kotlinType = expectedType;
            expectedType = this.argumentTypeResolver.getShapeTypeOfFunctionLiteral(functionLiteral, context.scope, context.trace, false, kotlinType != null ? FunctionTypesKt.isSuspendFunctionType(kotlinType) : false);
        }
        if (expectedType == null || !FunctionTypesKt.isBuiltinFunctionalType(expectedType) || CallResolverUtilKt.hasUnknownFunctionParameter(expectedType)) {
            return;
        }
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context.candidateCall.getDataFlowInfoForArguments();
        Intrinsics.checkNotNullExpressionValue(mutableDataFlowInfoForArguments, "getDataFlowInfoForArguments(...)");
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = mutableDataFlowInfoForArguments;
        DataFlowInfo dataFlowInfo = dataFlowInfoForArguments.getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "getInfo(...)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
        KotlinType effectiveExpectedTypeInSystem = typeSubstitutor2 != null ? typeSubstitutor2.substitute(effectiveExpectedType, Variance.INVARIANT) : null;
        boolean hasExpectedReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType);
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (hasExpectedReturnType) {
            TemporaryTraceAndCache temporaryToResolveFunctionLiteral = TemporaryTraceAndCache.create(context, "trace to resolve function literal with expected return type", argumentExpression);
            KtExpression ktExpression2 = KtPsiUtil.getExpressionOrLastStatementInBlock(functionLiteral.getBodyExpression());
            if (ktExpression2 == null) {
                return;
            }
            KtExpression statementExpression = ktExpression2;
            boolean[] mismatch = new boolean[1];
            ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryToResolveFunctionLiteral.trace, statementExpression, mismatch);
            Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceBindingTrace(errorInterceptingTrace)).replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceResolutionResultsCache(temporaryToResolveFunctionLiteral.cache)).replaceContextDependency(ContextDependency.INDEPENDENT);
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceContextDependency(...)");
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
            KotlinType type2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, FunctionTypesKt.isSuspendFunctionType(expectedType)).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type2, effectiveExpectedTypeInSystem, position);
                temporaryToResolveFunctionLiteral.commit();
                return;
            }
        }
        KotlinType estimatedReturnType = this.estimateLiteralReturnType(context, effectiveExpectedType, argumentOwnerReturnType);
        Intrinsics.checkNotNull(estimatedReturnType);
        KotlinType expectedTypeWithEstimatedReturnType = CallResolverUtilKt.replaceReturnTypeForCallable(expectedType, estimatedReturnType);
        Object Context3 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedTypeWithEstimatedReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context3, "replaceContextDependency(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context3;
        KotlinType type3 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, FunctionTypesKt.isSuspendFunctionType(expectedType)).getType();
        constraintSystem.addSubtypeConstraint(type3, effectiveExpectedTypeInSystem, position);
    }

    private final <D extends CallableDescriptor> void addConstraintForCallableReference(KtCallableReferenceExpression callableReference, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context);
        KotlinType kotlinType = this.getExpectedTypeForCallableReference(callableReference, constraintSystem, context, effectiveExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType expectedType = kotlinType;
        if (!GenericCandidateResolverKt.access$isApplicableExpectedTypeForCallableReference(expectedType)) {
            return;
        }
        KotlinType kotlinType2 = this.getResolvedTypeForCallableReference(callableReference, context, expectedType, valueArgument);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType resolvedType = kotlinType2;
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
        constraintSystem.addSubtypeConstraint(resolvedType, typeSubstitutor2 != null ? typeSubstitutor2.substitute(effectiveExpectedType, Variance.INVARIANT) : null, position);
    }

    private final <D extends CallableDescriptor> KotlinType getExpectedTypeForCallableReference(KtCallableReferenceExpression callableReference, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context, KotlinType effectiveExpectedType) {
        KotlinType substitutedType = constraintSystem.build().getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (substitutedType != null && !TypeUtils.isDontCarePlaceholder(substitutedType)) {
            return substitutedType;
        }
        KotlinType shapeType = this.argumentTypeResolver.getShapeTypeOfCallableReference(callableReference, (CallResolutionContext)context, false);
        if (shapeType != null && FunctionTypesKt.isFunctionTypeOrSubtype(shapeType) && !CallResolverUtilKt.hasUnknownFunctionParameter(shapeType)) {
            return shapeType;
        }
        return null;
    }

    private final <D extends CallableDescriptor> KotlinType getResolvedTypeForCallableReference(KtCallableReferenceExpression callableReference, CallCandidateResolutionContext<D> context, KotlinType expectedType, ValueArgument valueArgument) {
        DataFlowInfo dataFlowInfo = context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "getInfo(...)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        KotlinType expectedTypeWithoutReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType) ? CallResolverUtilKt.replaceReturnTypeByUnknown(expectedType) : expectedType;
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceContextDependency(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        return this.argumentTypeResolver.getCallableReferenceTypeInfo(callableReference, callableReference, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
    }
}

