/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public class LogRecord
implements Serializable {
    private static final AtomicLong globalSequenceNumber = new AtomicLong(0L);
    private static final int MIN_SEQUENTIAL_THREAD_ID = 0x3FFFFFFF;
    private static final AtomicInteger nextThreadId = new AtomicInteger(0x3FFFFFFF);
    private static final ThreadLocal<Integer> threadIds = new ThreadLocal();
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient boolean needToInferCaller;
    private transient Object[] parameters;
    private transient ResourceBundle resourceBundle;
    private static final long serialVersionUID = 5372048053134512534L;

    private int defaultThreadID() {
        long l = Thread.currentThread().getId();
        if (l < 0x3FFFFFFFL) {
            return (int)l;
        }
        Integer n = threadIds.get();
        if (n == null) {
            n = nextThreadId.getAndIncrement();
            threadIds.set(n);
        }
        return n;
    }

    public LogRecord(Level level, String string) {
        level.getClass();
        this.level = level;
        this.message = string;
        this.sequenceNumber = globalSequenceNumber.getAndIncrement();
        this.threadID = this.defaultThreadID();
        this.millis = System.currentTimeMillis();
        this.needToInferCaller = true;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        this.level = level;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    public void setSourceClassName(String string) {
        this.sourceClassName = string;
        this.needToInferCaller = false;
    }

    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
        this.needToInferCaller = false;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(1);
        objectOutputStream.writeByte(0);
        if (this.parameters == null) {
            objectOutputStream.writeInt(-1);
            return;
        }
        objectOutputStream.writeInt(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i] == null) {
                objectOutputStream.writeObject(null);
                continue;
            }
            objectOutputStream.writeObject(this.parameters[i].toString());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        if (by != 1) {
            throw new IOException("LogRecord: bad version: " + by + "." + by2);
        }
        int n = objectInputStream.readInt();
        if (n < -1) {
            throw new NegativeArraySizeException();
        }
        if (n == -1) {
            this.parameters = null;
        } else if (n < 255) {
            this.parameters = new Object[n];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = objectInputStream.readObject();
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(Math.min(n, 1024));
            for (int i = 0; i < n; ++i) {
                arrayList.add(objectInputStream.readObject());
            }
            this.parameters = arrayList.toArray(new Object[arrayList.size()]);
        }
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle resourceBundle;
                this.resourceBundle = resourceBundle = ResourceBundle.getBundle(this.resourceBundleName, Locale.getDefault(), ClassLoader.getSystemClassLoader());
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        this.needToInferCaller = false;
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        Throwable throwable = new Throwable();
        int n = javaLangAccess.getStackTraceDepth(throwable);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = javaLangAccess.getStackTraceElement(throwable, i);
            String string = stackTraceElement.getClassName();
            boolean bl2 = this.isLoggerImplFrame(string);
            if (bl) {
                if (!bl2) continue;
                bl = false;
                continue;
            }
            if (bl2 || string.startsWith("java.lang.reflect.") || string.startsWith("sun.reflect.")) continue;
            this.setSourceClassName(string);
            this.setSourceMethodName(stackTraceElement.getMethodName());
            return;
        }
    }

    private boolean isLoggerImplFrame(String string) {
        return string.equals("java.util.logging.Logger") || string.startsWith("java.util.logging.LoggingProxyImpl") || string.startsWith("sun.util.logging.");
    }
}

