/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeNormalizer;
import edu.stanford.nlp.util.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ATBTreeUtils {
    private static final Filter<Tree> emptyFilter = new ArabicTreeNormalizer.ArabicEmptyFilter();
    private static final TreeFactory tf = new LabeledScoredTreeFactory();
    public static String segMarker = "-";
    public static final String morphBoundary = "+";
    public static final String puncTag = "PUNC";
    private static final String reservedWordList = "-PLUS- -LRB- -RRB-";
    public static final Set<String> reservedWords = new HashSet<String>();

    private ATBTreeUtils() {
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\(", "-LRB-");
        s = s.replaceAll("\\)", "-RRB-");
        s = s.replaceAll("\\+", "-PLUS-");
        return s;
    }

    public static String unEscape(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("-LRB-", "(");
        s = s.replaceAll("-RRB-", ")");
        s = s.replaceAll("-PLUS-", morphBoundary);
        return s;
    }

    public static String flattenTree(Tree t) {
        t = t.prune(emptyFilter, tf);
        String flatString = Sentence.listToString(t.yield());
        return flatString;
    }

    public static String taggedStringFromTree(Tree t, boolean removeEscaping, String separator) {
        t = t.prune(emptyFilter, tf);
        ArrayList<TaggedWord> taggedSentence = t.taggedYield();
        for (TaggedWord token : taggedSentence) {
            token.setWord(removeEscaping ? ATBTreeUtils.unEscape(token.word()) : token.word());
        }
        return Sentence.listToString(taggedSentence, false, separator);
    }

    public static void main(String[] args) {
        String debug = "( the big lion ) + (the small rabbit)";
        String escaped = ATBTreeUtils.escape(debug);
        System.out.println(escaped);
    }

    static {
        reservedWords.addAll(Arrays.asList(reservedWordList.split("\\s+")));
    }
}

