/* Copyright 2017-2020, NVIDIA CORPORATION. All rights reserved. */

/* This files is pre-included whenever pgc++ is invoked with --nvcchost, even
 * if --no_preincludes is used.  _cplus_preinclude.h behaves differently,
 * namely defining __builtin_va_list in terms of __pgi_tag instead of
 * __va_list_tag, when --nvcchost is used, because it has to emit preprocessed
 * code that is compatible with the nvcc C++ parser.  When code that was
 * preprocessed by pgc++ is then given back to pgc++ to compile, the code needs
 * to be converted back to something that is compatible with the pgc++ front
 * end.  That's what this file is for.  It defines __va_list_tag, and uses a
 * #define of __pgi_tag so that the typedef of __builtin_va_list that follows
 * will be in terms of __va_list_tag instead of __pgi_tag. */

#if !defined(__PREPROCESS_ONLY__) && !defined(__PGI_CPLUS_PREINCLUDE__)

#define __pgi_tag __va_list_tag

#endif
