/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.agent;

import com.google.common.annotations.VisibleForTesting;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.agent.LLMSpec;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.input.remote.RemoteInferenceMLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.memory.Memory;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.common.utils.MLTaskUtils;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.algorithms.agent.AgentUtils;
import org.opensearch.ml.engine.algorithms.agent.MLAgentRunner;
import org.opensearch.ml.engine.algorithms.agent.MLChatAgentRunner;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.memory.ConversationIndexMemory;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.client.Client;

public class MLPlanExecuteAndReflectAgentRunner
implements MLAgentRunner {
    @Generated
    private static final Logger log = LogManager.getLogger(MLPlanExecuteAndReflectAgentRunner.class);
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, Tool.Factory> toolFactories;
    private final Map<String, Memory.Factory> memoryFactoryMap;
    private SdkClient sdkClient;
    private Encryptor encryptor;
    private boolean taskUpdated = false;
    private final Map<String, Object> taskUpdates = new HashMap<String, Object>();
    private String plannerPrompt;
    private String plannerPromptTemplate;
    private String reflectPrompt;
    private String reflectPromptTemplate;
    private String plannerWithHistoryPromptTemplate;
    @VisibleForTesting
    static final String DEFAULT_PLANNER_SYSTEM_PROMPT = "You are a thoughtful and analytical planner agent in a plan-execute-reflect framework. Your job is to design a clear, step-by-step plan for a given objective.\n\nInstructions:\n- Break the objective into an ordered list of atomic, self-contained Steps that, if executed, will lead to the final result or complete the objective.\n- Each Step must state what to do, where, and which tool/parameters would be used. You do not execute tools, only reference them for planning.\n- Use only the provided tools; do not invent or assume tools. If no suitable tool applies, use reasoning or observations instead.\n- Base your plan only on the data and information explicitly provided; do not rely on unstated knowledge or external facts.\n- If there is insufficient information to create a complete plan, summarize what is known so far and clearly state what additional information is required to proceed.\n- Stop and summarize if the task is complete or further progress is unlikely.\n- Avoid vague instructions; be specific about data sources, indexes, or parameters.\n- Never make assumptions or rely on implicit knowledge.\n- Respond only in JSON format.\n\nStep examples:\nGood example: \"Use Tool to sample documents from index: 'my-index'\"\nBad example: \"Use Tool to sample documents from each index\"\nBad example: \"Use Tool to sample documents from all indices\"\nResponse Instructions: \nOnly respond in JSON format. Always follow the given response instructions. Do not return any content that does not follow the response instructions. Do not add anything before or after the expected JSON. \nAlways respond with a valid JSON object that strictly follows the below schema:\n{\n\t\"steps\": array[string], \n\t\"result\": string \n}\nUse \"steps\" to return an array of strings where each string is a step to complete the objective, leave it empty if you know the final result. Please wrap each step in quotes and escape any special characters within the string. \nUse \"result\" return the final response when you have enough information, leave it empty if you want to execute more steps. Please escape any special characters within the result. \nHere are examples of valid responses following the required JSON schema:\n\nExample 1 - When you need to execute steps:\n{\n\t\"steps\": [\"This is an example step\", \"this is another example step\"],\n\t\"result\": \"\"\n}\n\nExample 2 - When you have the final result:\n{\n\t\"steps\": [],\n\t\"result\": \"This is an example result\\n with escaped special characters\"\n}\nImportant rules for the response:\n1. Do not use commas within individual steps \n2. Do not add any content before or after the JSON \n3. Only respond with a pure JSON object \n\n    When you deliver your final result, include a comprehensive report. This report must:\n    1. List every analysis or step you performed.\n    2. Summarize the inputs, methods, tools, and data used at each step.\n    3. Include key findings from all intermediate steps \u2014 do NOT omit them.\n    4. Clearly explain how the steps led to your final conclusion. Only mention the completed steps.\n    5. Return the full analysis and conclusion in the 'result' field, even if some of this was mentioned earlier. Ensure that special characters are escaped in the 'result' field.\n    6. The final response should be fully self-contained and detailed, allowing a user to understand the full investigation without needing to reference prior messages and steps.\n";
    @VisibleForTesting
    static final String DEFAULT_EXECUTOR_SYSTEM_PROMPT = "You are a precise and reliable executor agent in a plan-execute-reflect framework. Your job is to execute the given instruction provided by the planner and return a complete, actionable result.\n\nInstructions:\n- Fully execute the given Step using the most relevant tools or reasoning.\n- Include all relevant raw tool outputs (e.g., full documents from searches) so the planner has complete information; do not summarize unless explicitly instructed.\n- Base your execution and conclusions only on the data and tool outputs available; do not rely on unstated knowledge or external facts.\n- If the available data is insufficient to complete the Step, summarize what was obtained so far and clearly state the additional information or access required to proceed (do not guess).\n- If unable to complete the Step, clearly explain what went wrong and what is needed to proceed.\n- Avoid making assumptions and relying on implicit knowledge.\n- Your response must be self-contained and ready for the planner to use without modification. Never end with a question.\n- Break complex searches into simpler queries when appropriate.";
    private static final String DEFAULT_NO_ESCAPE_PARAMS = "tool_configs,_tools";
    private static final String DEFAULT_MAX_STEPS_EXECUTED = "20";
    private static final String DEFAULT_REACT_MAX_ITERATIONS = "20";
    public static final String PROMPT_FIELD = "prompt";
    public static final String USER_PROMPT_FIELD = "user_prompt";
    public static final String EXECUTOR_SYSTEM_PROMPT_FIELD = "executor_system_prompt";
    public static final String STEPS_FIELD = "steps";
    public static final String COMPLETED_STEPS_FIELD = "completed_steps";
    public static final String PLANNER_PROMPT_FIELD = "planner_prompt";
    public static final String REFLECT_PROMPT_FIELD = "reflect_prompt";
    public static final String PLAN_EXECUTE_REFLECT_RESPONSE_FORMAT_FIELD = "plan_execute_reflect_response_format";
    public static final String PROMPT_TEMPLATE_FIELD = "prompt_template";
    public static final String SYSTEM_PROMPT_FIELD = "system_prompt";
    public static final String QUESTION_FIELD = "question";
    public static final String MEMORY_ID_FIELD = "memory_id";
    public static final String PARENT_INTERACTION_ID_FIELD = "parent_interaction_id";
    public static final String TENANT_ID_FIELD = "tenant_id";
    public static final String RESULT_FIELD = "result";
    public static final String RESPONSE_FIELD = "response";
    public static final String STEP_RESULT_FIELD = "step_result";
    public static final String EXECUTOR_AGENT_ID_FIELD = "executor_agent_id";
    public static final String EXECUTOR_AGENT_MEMORY_ID_FIELD = "executor_agent_memory_id";
    public static final String EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD = "executor_agent_parent_interaction_id";
    public static final String NO_ESCAPE_PARAMS_FIELD = "no_escape_params";
    public static final String DEFAULT_PROMPT_TOOLS_FIELD = "tools_prompt";
    public static final String MAX_STEPS_EXECUTED_FIELD = "max_steps";
    public static final String PLANNER_PROMPT_TEMPLATE_FIELD = "planner_prompt_template";
    public static final String REFLECT_PROMPT_TEMPLATE_FIELD = "reflect_prompt_template";
    public static final String PLANNER_WITH_HISTORY_TEMPLATE_FIELD = "planner_with_history_template";
    public static final String EXECUTOR_MAX_ITERATIONS_FIELD = "executor_max_iterations";
    public static final String PLANNER_MESSAGE_HISTORY_LIMIT = "message_history_limit";
    private static final String DEFAULT_MESSAGE_HISTORY_LIMIT = "10";
    public static final String EXECUTOR_MESSAGE_HISTORY_LIMIT = "executor_message_history_limit";
    private static final String DEFAULT_EXECUTOR_MESSAGE_HISTORY_LIMIT = "10";
    public static final String INJECT_DATETIME_FIELD = "inject_datetime";
    public static final String DATETIME_FORMAT_FIELD = "datetime_format";

    public MLPlanExecuteAndReflectAgentRunner(Client client, Settings settings, ClusterService clusterService, NamedXContentRegistry registry, Map<String, Tool.Factory> toolFactories, Map<String, Memory.Factory> memoryFactoryMap, SdkClient sdkClient, Encryptor encryptor) {
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = registry;
        this.toolFactories = toolFactories;
        this.memoryFactoryMap = memoryFactoryMap;
        this.sdkClient = sdkClient;
        this.encryptor = encryptor;
        this.plannerPrompt = "For the given objective, generate a step-by-step plan composed of simple, self-contained steps. The final step should directly yield the final answer. Avoid unnecessary steps.";
        this.plannerPromptTemplate = "${parameters.tools_prompt} \n${parameters.planner_prompt} \nObjective: ${parameters.user_prompt} \n\nRemember: Respond only in JSON format following the required schema.";
        this.reflectPrompt = "Update your plan based on the latest step results. If the task is complete, return the final answer. Otherwise, include only the remaining steps. Do not repeat previously completed steps.";
        this.reflectPromptTemplate = "${parameters.tools_prompt} \n${parameters.planner_prompt} \n\nObjective: ```${parameters.user_prompt}```\n\nOriginal plan:\n[${parameters.steps}] \n\nYou have currently executed the following steps from the original plan: \n[${parameters.completed_steps}] \n\n${parameters.reflect_prompt} \n\n.Remember: Respond only in JSON format following the required schema.";
        this.plannerWithHistoryPromptTemplate = "${parameters.tools_prompt} \n${parameters.planner_prompt} \nObjective: ```${parameters.user_prompt}``` \n\nYou have currently executed the following steps: \n[${parameters.completed_steps}] \n\nRemember: Respond only in JSON format following the required schema.";
    }

    @VisibleForTesting
    void setupPromptParameters(Map<String, String> params) {
        params.remove(PROMPT_FIELD);
        String userPrompt = params.get(QUESTION_FIELD);
        params.put(USER_PROMPT_FIELD, userPrompt);
        boolean injectDate = Boolean.parseBoolean(params.getOrDefault(INJECT_DATETIME_FIELD, "false"));
        String dateFormat = params.get(DATETIME_FORMAT_FIELD);
        String currentDateTime = injectDate ? AgentUtils.getCurrentDateTime(dateFormat) : "";
        String plannerSystemPrompt = params.getOrDefault(SYSTEM_PROMPT_FIELD, DEFAULT_PLANNER_SYSTEM_PROMPT);
        if (injectDate) {
            plannerSystemPrompt = String.format("%s\n\n%s", plannerSystemPrompt, currentDateTime);
        }
        params.put(SYSTEM_PROMPT_FIELD, plannerSystemPrompt);
        String executorSystemPrompt = params.getOrDefault(EXECUTOR_SYSTEM_PROMPT_FIELD, DEFAULT_EXECUTOR_SYSTEM_PROMPT);
        if (injectDate) {
            executorSystemPrompt = String.format("%s\n\n%s", executorSystemPrompt, currentDateTime);
        }
        params.put(EXECUTOR_SYSTEM_PROMPT_FIELD, executorSystemPrompt);
        if (params.get(PLANNER_PROMPT_FIELD) != null) {
            this.plannerPrompt = params.get(PLANNER_PROMPT_FIELD);
        }
        params.put(PLANNER_PROMPT_FIELD, this.plannerPrompt);
        if (params.get(PLANNER_PROMPT_TEMPLATE_FIELD) != null) {
            this.plannerPromptTemplate = params.get(PLANNER_PROMPT_TEMPLATE_FIELD);
        }
        if (params.get(REFLECT_PROMPT_FIELD) != null) {
            this.reflectPrompt = params.get(REFLECT_PROMPT_FIELD);
        }
        params.put(REFLECT_PROMPT_FIELD, this.reflectPrompt);
        if (params.get(REFLECT_PROMPT_TEMPLATE_FIELD) != null) {
            this.reflectPromptTemplate = params.get(REFLECT_PROMPT_TEMPLATE_FIELD);
        }
        if (params.get(PLANNER_WITH_HISTORY_TEMPLATE_FIELD) != null) {
            this.plannerWithHistoryPromptTemplate = params.get(PLANNER_WITH_HISTORY_TEMPLATE_FIELD);
        }
        params.put(PLAN_EXECUTE_REFLECT_RESPONSE_FORMAT_FIELD, "Response Instructions: \nOnly respond in JSON format. Always follow the given response instructions. Do not return any content that does not follow the response instructions. Do not add anything before or after the expected JSON. \nAlways respond with a valid JSON object that strictly follows the below schema:\n{\n\t\"steps\": array[string], \n\t\"result\": string \n}\nUse \"steps\" to return an array of strings where each string is a step to complete the objective, leave it empty if you know the final result. Please wrap each step in quotes and escape any special characters within the string. \nUse \"result\" return the final response when you have enough information, leave it empty if you want to execute more steps. Please escape any special characters within the result. \nHere are examples of valid responses following the required JSON schema:\n\nExample 1 - When you need to execute steps:\n{\n\t\"steps\": [\"This is an example step\", \"this is another example step\"],\n\t\"result\": \"\"\n}\n\nExample 2 - When you have the final result:\n{\n\t\"steps\": [],\n\t\"result\": \"This is an example result\\n with escaped special characters\"\n}\nImportant rules for the response:\n1. Do not use commas within individual steps \n2. Do not add any content before or after the JSON \n3. Only respond with a pure JSON object \n\n");
        params.put(NO_ESCAPE_PARAMS_FIELD, DEFAULT_NO_ESCAPE_PARAMS);
        if (params.containsKey("_llm_interface") && (!params.containsKey("llm_response_filter") || params.get("llm_response_filter").isEmpty())) {
            String llmInterface = params.get("_llm_interface");
            String llmResponseFilter = switch (llmInterface.trim().toLowerCase(Locale.ROOT)) {
                case "bedrock/converse/claude", "bedrock/converse/deepseek_r1" -> "$.output.message.content[0].text";
                case "openai/v1/chat/completions" -> "$.choices[0].message.content";
                default -> throw new MLException(String.format("Unsupported llm interface: %s", llmInterface));
            };
            params.put("llm_response_filter", llmResponseFilter);
        }
    }

    @VisibleForTesting
    void usePlannerPromptTemplate(Map<String, String> params) {
        params.put(PROMPT_TEMPLATE_FIELD, this.plannerPromptTemplate);
        this.populatePrompt(params);
    }

    @VisibleForTesting
    void useReflectPromptTemplate(Map<String, String> params) {
        params.put(PROMPT_TEMPLATE_FIELD, this.reflectPromptTemplate);
        this.populatePrompt(params);
    }

    @VisibleForTesting
    void usePlannerWithHistoryPromptTemplate(Map<String, String> params) {
        params.put(PROMPT_TEMPLATE_FIELD, this.plannerWithHistoryPromptTemplate);
        this.populatePrompt(params);
    }

    @VisibleForTesting
    void populatePrompt(Map<String, String> allParams) {
        String promptTemplate = allParams.get(PROMPT_TEMPLATE_FIELD);
        StringSubstitutor promptSubstitutor = new StringSubstitutor(allParams, "${parameters.", "}");
        String prompt = promptSubstitutor.replace(promptTemplate);
        allParams.put(PROMPT_FIELD, prompt);
    }

    @Override
    public void run(MLAgent mlAgent, Map<String, String> apiParams, ActionListener<Object> listener, TransportChannel channel) {
        HashMap<String, String> allParams = new HashMap<String, String>();
        allParams.putAll(apiParams);
        allParams.putAll(mlAgent.getParameters());
        this.setupPromptParameters(allParams);
        this.usePlannerPromptTemplate(allParams);
        String memoryId = (String)allParams.get(MEMORY_ID_FIELD);
        String memoryType = mlAgent.getMemory().getType();
        String appType = mlAgent.getAppType();
        int messageHistoryLimit = Integer.parseInt(allParams.getOrDefault(PLANNER_MESSAGE_HISTORY_LIMIT, "10"));
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = (ConversationIndexMemory.Factory)this.memoryFactoryMap.get(memoryType);
        conversationIndexMemoryFactory.create(apiParams.get(USER_PROMPT_FIELD), memoryId, appType, (ActionListener<ConversationIndexMemory>)ActionListener.wrap(memory -> memory.getMessages(ActionListener.wrap(interactions -> {
            ArrayList<String> completedSteps = new ArrayList<String>();
            for (Interaction interaction : interactions) {
                String question = interaction.getInput();
                String response = interaction.getResponse();
                if (Strings.isNullOrEmpty((String)response)) continue;
                completedSteps.add(question);
                completedSteps.add(response);
            }
            if (!completedSteps.isEmpty()) {
                this.addSteps(completedSteps, allParams, COMPLETED_STEPS_FIELD);
                this.usePlannerWithHistoryPromptTemplate(allParams);
            }
            this.setToolsAndRunAgent(mlAgent, (Map<String, String>)allParams, (List<String>)completedSteps, (Memory)memory, memory.getConversationId(), listener);
        }, e -> {
            log.error("Failed to get chat history", (Throwable)e);
            listener.onFailure(e);
        }), messageHistoryLimit), arg_0 -> listener.onFailure(arg_0)));
    }

    private void setToolsAndRunAgent(MLAgent mlAgent, Map<String, String> allParams, List<String> completedSteps, Memory memory, String conversationId, ActionListener<Object> finalListener) {
        List<MLToolSpec> toolSpecs = AgentUtils.getMlToolSpecs(mlAgent, allParams);
        Consumer<List> processTools = allToolSpecs -> {
            HashMap<String, Tool> tools = new HashMap<String, Tool>();
            HashMap<String, MLToolSpec> toolSpecMap = new HashMap<String, MLToolSpec>();
            AgentUtils.createTools(this.toolFactories, allParams, allToolSpecs, tools, toolSpecMap, mlAgent);
            this.addToolsToPrompt(tools, allParams);
            AtomicInteger traceNumber = new AtomicInteger(0);
            this.executePlanningLoop(mlAgent.getLlm(), allParams, completedSteps, memory, conversationId, 0, traceNumber, finalListener);
        };
        AgentUtils.getMcpToolSpecs(mlAgent, this.client, this.sdkClient, this.encryptor, (ActionListener<List<MLToolSpec>>)ActionListener.wrap(mcpTools -> {
            toolSpecs.addAll((Collection<MLToolSpec>)mcpTools);
            processTools.accept(toolSpecs);
        }, e -> {
            log.warn("Failed to get MCP tools, continuing with base tools only", (Throwable)e);
            processTools.accept(toolSpecs);
        }));
    }

    private void executePlanningLoop(LLMSpec llm, Map<String, String> allParams, List<String> completedSteps, Memory memory, String conversationId, int stepsExecuted, AtomicInteger traceNumber, ActionListener<Object> finalListener) {
        int maxSteps = Integer.parseInt(allParams.getOrDefault(MAX_STEPS_EXECUTED_FIELD, "20"));
        String parentInteractionId = allParams.get(PARENT_INTERACTION_ID_FIELD);
        if (stepsExecuted >= maxSteps) {
            String finalResult = String.format("Max Steps Limit Reached. Use memory_id with same task to restart. \n Last executed step: %s, \n Last executed step result: %s", completedSteps.get(completedSteps.size() - 2), completedSteps.getLast());
            this.saveAndReturnFinalResult((ConversationIndexMemory)memory, parentInteractionId, allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD), allParams.get(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD), finalResult, null, finalListener);
            return;
        }
        MLPredictionTaskRequest request = new MLPredictionTaskRequest(llm.getModelId(), RemoteInferenceMLInput.builder().algorithm(FunctionName.REMOTE).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(allParams).build()).build(), null, allParams.get(TENANT_ID_FIELD));
        StepListener planListener = new StepListener();
        planListener.whenComplete(llmOutput -> {
            ModelTensorOutput modelTensorOutput = (ModelTensorOutput)llmOutput.getOutput();
            Map<String, Object> parseLLMOutput = this.parseLLMOutput(allParams, modelTensorOutput);
            if (parseLLMOutput.get(RESULT_FIELD) != null) {
                String finalResult = (String)parseLLMOutput.get(RESULT_FIELD);
                this.saveAndReturnFinalResult((ConversationIndexMemory)memory, parentInteractionId, (String)allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD), (String)allParams.get(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD), finalResult, null, finalListener);
            } else {
                List steps = (List)parseLLMOutput.get(STEPS_FIELD);
                this.addSteps(steps, allParams, STEPS_FIELD);
                String stepToExecute = (String)steps.getFirst();
                String reActAgentId = (String)allParams.get(EXECUTOR_AGENT_ID_FIELD);
                HashMap<String, String> reactParams = new HashMap<String, String>();
                reactParams.put(QUESTION_FIELD, stepToExecute);
                if (allParams.containsKey(EXECUTOR_AGENT_MEMORY_ID_FIELD)) {
                    reactParams.put(MEMORY_ID_FIELD, (String)allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD));
                }
                reactParams.put(SYSTEM_PROMPT_FIELD, allParams.getOrDefault(EXECUTOR_SYSTEM_PROMPT_FIELD, DEFAULT_EXECUTOR_SYSTEM_PROMPT));
                reactParams.put("llm_response_filter", (String)allParams.get("llm_response_filter"));
                reactParams.put("max_iteration", allParams.getOrDefault(EXECUTOR_MAX_ITERATIONS_FIELD, "20"));
                reactParams.put(PLANNER_MESSAGE_HISTORY_LIMIT, allParams.getOrDefault(EXECUTOR_MESSAGE_HISTORY_LIMIT, "10"));
                AgentMLInput agentInput = AgentMLInput.AgentMLInputBuilder().agentId(reActAgentId).functionName(FunctionName.AGENT).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(reactParams).build()).build();
                MLExecuteTaskRequest executeRequest = new MLExecuteTaskRequest(FunctionName.AGENT, (Input)agentInput);
                this.client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)executeRequest, ActionListener.wrap(executeResponse -> {
                    String taskId;
                    String reActParentInteractionId;
                    ModelTensorOutput reactResult = (ModelTensorOutput)executeResponse.getOutput();
                    HashMap results = new HashMap();
                    reactResult.getMlModelOutputs().stream().flatMap(output -> output.getMlModelTensors().stream()).forEach(tensor -> {
                        switch (tensor.getName()) {
                            case "memory_id": {
                                results.put(MEMORY_ID_FIELD, tensor.getResult());
                                break;
                            }
                            case "parent_interaction_id": {
                                results.put(PARENT_INTERACTION_ID_FIELD, tensor.getResult());
                                break;
                            }
                            default: {
                                Map dataMap = tensor.getDataAsMap();
                                if (dataMap == null || !dataMap.containsKey(RESPONSE_FIELD)) break;
                                results.put(STEP_RESULT_FIELD, (String)dataMap.get(RESPONSE_FIELD));
                            }
                        }
                    });
                    if (!results.containsKey(STEP_RESULT_FIELD)) {
                        throw new IllegalStateException("No valid response found in ReAct agent output");
                    }
                    String reActMemoryId = (String)results.get(MEMORY_ID_FIELD);
                    if (reActMemoryId != null && !reActMemoryId.isEmpty()) {
                        allParams.put(EXECUTOR_AGENT_MEMORY_ID_FIELD, reActMemoryId);
                    }
                    if ((reActParentInteractionId = (String)results.get(PARENT_INTERACTION_ID_FIELD)) != null && !reActParentInteractionId.isEmpty()) {
                        allParams.put(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD, reActParentInteractionId);
                    }
                    HashMap memoryUpdates = new HashMap();
                    if (allParams.containsKey(EXECUTOR_AGENT_MEMORY_ID_FIELD)) {
                        memoryUpdates.put(EXECUTOR_AGENT_MEMORY_ID_FIELD, allParams.get(EXECUTOR_AGENT_MEMORY_ID_FIELD));
                    }
                    if (allParams.containsKey(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD)) {
                        memoryUpdates.put(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD, allParams.get(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD));
                    }
                    if ((taskId = (String)allParams.get("task_id")) != null && !this.taskUpdated) {
                        this.taskUpdates.put("state", MLTaskState.RUNNING);
                        this.taskUpdates.put(RESPONSE_FIELD, memoryUpdates);
                        MLTaskUtils.updateMLTaskDirectly((String)taskId, this.taskUpdates, (Client)this.client, (ActionListener)ActionListener.wrap(updateResponse -> {
                            log.info("Updated task {} with executor memory ID", (Object)taskId);
                            this.taskUpdated = true;
                        }, e -> log.error("Failed to update task {} with executor memory ID", (Object)taskId, e)));
                    }
                    completedSteps.add(String.format("\nStep %d: %s\n", stepsExecuted + 1, stepToExecute));
                    completedSteps.add(String.format("\nStep %d Result: %s\n", stepsExecuted + 1, results.get(STEP_RESULT_FIELD)));
                    MLChatAgentRunner.saveTraceData((ConversationIndexMemory)memory, memory.getType(), stepToExecute, (String)results.get(STEP_RESULT_FIELD), conversationId, false, parentInteractionId, traceNumber, "PlanExecuteReflect Agent");
                    this.addSteps(completedSteps, allParams, COMPLETED_STEPS_FIELD);
                    this.useReflectPromptTemplate(allParams);
                    this.executePlanningLoop(llm, allParams, completedSteps, memory, conversationId, stepsExecuted + 1, traceNumber, finalListener);
                }, e -> {
                    log.error("Failed to execute ReAct agent", (Throwable)e);
                    finalListener.onFailure(e);
                }));
            }
        }, e -> {
            log.error("Failed to run deep research agent", (Throwable)e);
            finalListener.onFailure(e);
        });
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)request, (ActionListener)planListener);
    }

    @VisibleForTesting
    Map<String, Object> parseLLMOutput(Map<String, String> allParams, ModelTensorOutput modelTensorOutput) {
        String result;
        String llmResponse;
        HashMap<String, Object> modelOutput = new HashMap<String, Object>();
        Map dataAsMap = ((ModelTensor)((ModelTensors)modelTensorOutput.getMlModelOutputs().getFirst()).getMlModelTensors().getFirst()).getDataAsMap();
        if (dataAsMap.size() == 1 && dataAsMap.containsKey(RESPONSE_FIELD)) {
            llmResponse = ((String)dataAsMap.get(RESPONSE_FIELD)).trim();
        } else {
            if (!allParams.containsKey("llm_response_filter") || allParams.get("llm_response_filter").isEmpty()) {
                throw new IllegalArgumentException("llm_response_filter not found. Please provide the path to the model output.");
            }
            llmResponse = ((String)JsonPath.read((Object)dataAsMap, (String)allParams.get("llm_response_filter"), (Predicate[])new Predicate[0])).trim();
        }
        String json = StringUtils.isJson((String)llmResponse) ? llmResponse : this.extractJsonFromMarkdown(llmResponse);
        Map parsedJson = StringUtils.fromJson((String)json, (String)RESPONSE_FIELD);
        if (!parsedJson.containsKey(STEPS_FIELD) && !parsedJson.containsKey(RESULT_FIELD)) {
            throw new IllegalArgumentException("Missing required fields 'steps' and 'result' in JSON response");
        }
        if (parsedJson.containsKey(STEPS_FIELD)) {
            List steps = (List)parsedJson.get(STEPS_FIELD);
            modelOutput.put(STEPS_FIELD, steps);
        }
        if (parsedJson.containsKey(RESULT_FIELD) && !(result = (String)parsedJson.get(RESULT_FIELD)).isEmpty()) {
            modelOutput.put(RESULT_FIELD, result);
        }
        return modelOutput;
    }

    @VisibleForTesting
    String extractJsonFromMarkdown(String response) {
        if ((response = response.trim()).contains("```json")) {
            if ((response = response.substring(response.indexOf("```json") + "```json".length())).contains("```")) {
                response = response.substring(0, response.lastIndexOf("```"));
            }
        } else if (response.contains("{") && response.contains("}")) {
            response = response.substring(response.indexOf("{"), response.lastIndexOf("}") + 1);
        }
        if (!StringUtils.isJson((String)(response = response.trim()))) {
            throw new IllegalStateException("Failed to parse LLM output due to invalid JSON");
        }
        return response;
    }

    @VisibleForTesting
    void addToolsToPrompt(Map<String, Tool> tools, Map<String, String> allParams) {
        StringBuilder toolsPrompt = new StringBuilder("In this environment, you have access to the tools listed below. Use these tools to create your plan, and do not reference or use any tools not listed here.\n");
        int toolNumber = 0;
        for (Map.Entry<String, Tool> entry : tools.entrySet()) {
            String toolName = entry.getKey();
            String toolDescription = entry.getValue().getDescription();
            toolsPrompt.append(String.format("Tool %d - %s: %s\n\n", ++toolNumber, toolName, toolDescription));
        }
        toolsPrompt.append("No other tools are available. Do not invent tools. Only use tools to create the plan.\n\n");
        allParams.put(DEFAULT_PROMPT_TOOLS_FIELD, toolsPrompt.toString());
        this.populatePrompt(allParams);
        AgentUtils.cleanUpResource(tools);
    }

    @VisibleForTesting
    void addSteps(List<String> steps, Map<String, String> allParams, String field) {
        allParams.put(field, String.join((CharSequence)", ", steps));
    }

    @VisibleForTesting
    void saveAndReturnFinalResult(ConversationIndexMemory memory, String parentInteractionId, String reactAgentMemoryId, String reactParentInteractionId, String finalResult, String input, ActionListener<Object> finalListener) {
        HashMap<String, Object> updateContent = new HashMap<String, Object>();
        updateContent.put(RESPONSE_FIELD, finalResult);
        if (input != null) {
            updateContent.put("input", input);
        }
        memory.getMemoryManager().updateInteraction(parentInteractionId, updateContent, (ActionListener<UpdateResponse>)ActionListener.wrap(res -> {
            List<ModelTensors> finalModelTensors = MLPlanExecuteAndReflectAgentRunner.createModelTensors(memory.getConversationId(), parentInteractionId, reactAgentMemoryId, reactParentInteractionId);
            finalModelTensors.add(ModelTensors.builder().mlModelTensors(List.of(ModelTensor.builder().name(RESPONSE_FIELD).dataAsMap(Map.of(RESPONSE_FIELD, finalResult)).build())).build());
            finalListener.onResponse((Object)ModelTensorOutput.builder().mlModelOutputs(finalModelTensors).build());
        }, e -> {
            log.error("Failed to update interaction with final result", (Throwable)e);
            finalListener.onFailure(e);
        }));
    }

    @VisibleForTesting
    static List<ModelTensors> createModelTensors(String sessionId, String parentInteractionId, String reactAgentMemoryId, String reactParentInteractionId) {
        ArrayList<ModelTensors> modelTensors = new ArrayList<ModelTensors>();
        ArrayList<ModelTensor> tensors = new ArrayList<ModelTensor>();
        tensors.add(ModelTensor.builder().name(MEMORY_ID_FIELD).result(sessionId).build());
        tensors.add(ModelTensor.builder().name(PARENT_INTERACTION_ID_FIELD).result(parentInteractionId).build());
        if (reactAgentMemoryId != null && !reactAgentMemoryId.isEmpty()) {
            tensors.add(ModelTensor.builder().name(EXECUTOR_AGENT_MEMORY_ID_FIELD).result(reactAgentMemoryId).build());
        }
        if (reactParentInteractionId != null && !reactParentInteractionId.isEmpty()) {
            tensors.add(ModelTensor.builder().name(EXECUTOR_AGENT_PARENT_INTERACTION_ID_FIELD).result(reactParentInteractionId).build());
        }
        modelTensors.add(ModelTensors.builder().mlModelTensors(tensors).build());
        return modelTensors;
    }

    @VisibleForTesting
    Map<String, Object> getTaskUpdates() {
        return this.taskUpdates;
    }
}

