/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class IOUtil {
    private static final Logger logger = Logger.getLogger(IOUtil.class.getName());
    public static final int BUFFER_SIZE = 1000000;
    private static final Pattern linefeedPattern = Pattern.compile("\\R");

    private IOUtil() {
    }

    public static List<String> getLinesFromString(String text) {
        String[] lines = linefeedPattern.split(text);
        return new ArrayList<String>(Arrays.asList(lines));
    }

    public static List<String> getLines(String path) throws IOException {
        return IOUtil.getLines(path, -1);
    }

    public static List<String> getLines(String path, Charset encoding) throws IOException {
        return IOUtil.getLines(path, -1, encoding);
    }

    public static List<String> getLines(String path, int count) throws IOException {
        return IOUtil.getLines(path, count, StandardCharsets.UTF_8);
    }

    public static List<String> getLines(String path, int count, Charset encoding) throws IOException {
        try (BufferedReader reader = IOUtil.getReader(path, encoding);){
            List<String> list = IOUtil.getLines(reader, count);
            return list;
        }
    }

    public static List<String> getLines(BufferedReader reader, int count) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
            if (count <= 0 || lines.size() != count) continue;
            return lines;
        }
        return lines;
    }

    public static BufferedReader getReader(String path) throws FileNotFoundException {
        return IOUtil.getReader(path, StandardCharsets.UTF_8);
    }

    public static BufferedReader getReader(String path, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)IOUtil.getInputStream(path), charset), 1000000);
    }

    public static BufferedReader getReader(URI uri, Charset charset) throws IOException {
        return IOUtil.getReader(uri.toURL(), charset);
    }

    public static BufferedReader getReader(URL url, Charset charset) throws IOException {
        if (IOUtil.isDisallowedProtocol(url)) {
            throw new IllegalArgumentException("Tried to read disallowed URL protocol: '" + url.toString() + "'");
        }
        return IOUtil.getReader(url.openStream(), charset);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws IOException {
        return IOUtil.getReader(new FileInputStream(path.toFile()), charset);
    }

    public static BufferedReader getReader(String filename, String charset) throws FileNotFoundException, IOException {
        return IOUtil.getReader(new File(filename), charset);
    }

    public static BufferedReader getReader(File file, String charset) throws FileNotFoundException, IOException {
        return IOUtil.getReader(new FileInputStream(file), Charset.forName(charset));
    }

    private static BufferedReader getReader(InputStream stream, Charset charset) throws IOException {
        InputStream wrappedStream = IOUtil.wrapGZIPStream(stream);
        return new BufferedReader(new InputStreamReader(wrappedStream, charset), 1000000);
    }

    public static PrintWriter getPrintWriter(String filename, boolean zipped) throws FileNotFoundException, IOException {
        return new PrintWriter(new OutputStreamWriter(IOUtil.innerGetOutputStream(filename, zipped), StandardCharsets.UTF_8));
    }

    public static ObjectOutputStream getObjectOutputStream(String filename, boolean zipped) throws FileNotFoundException, IOException {
        return new ObjectOutputStream(IOUtil.innerGetOutputStream(filename, zipped));
    }

    private static OutputStream innerGetOutputStream(String filename, boolean zipped) throws FileNotFoundException, IOException {
        if (zipped) {
            return new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 1000000));
        }
        return new BufferedOutputStream(new FileOutputStream(filename), 1000000);
    }

    public static ObjectInputStream getObjectInputStream(String filename) throws FileNotFoundException, IOException {
        return IOUtil.getObjectInputStream(new File(filename));
    }

    public static ObjectInputStream getObjectInputStream(File file) throws FileNotFoundException, IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 1000000);
        return new ObjectInputStream(IOUtil.wrapGZIPStream(stream));
    }

    public static BufferedInputStream getInputStream(String path) throws FileNotFoundException {
        InputStream in = IOUtil.class.getResourceAsStream(path);
        if (in == null) {
            File file = new File(path);
            in = new FileInputStream(file);
        }
        return new BufferedInputStream(in, 1000000);
    }

    public static BufferedInputStream getInputStream(File file) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(file);
        return new BufferedInputStream(in, 1000000);
    }

    public static String toString(String path) throws IOException {
        return IOUtil.toString(path, StandardCharsets.UTF_8);
    }

    public static String toString(String path, Charset charset) throws IOException {
        String str = IOUtil.fromResource(path, charset);
        if (str != null) {
            return str;
        }
        str = IOUtil.fromFile(path, charset);
        if (str != null) {
            return str;
        }
        throw new RuntimeException("Failed to read path " + path);
    }

    public static String fromResource(String path, Charset charset) {
        return IOUtil.fromInputStream(IOUtil.class.getResourceAsStream(path), charset);
    }

    public static String fromPath(Path path) throws FileNotFoundException {
        return IOUtil.fromFile(path.toFile(), StandardCharsets.UTF_8);
    }

    public static String fromPath(Path path, Charset charset) throws FileNotFoundException {
        return IOUtil.fromFile(path.toFile(), charset);
    }

    public static String fromFile(String path, Charset charset) throws FileNotFoundException {
        return IOUtil.fromFile(new File(path), charset);
    }

    public static String fromFile(File file, Charset charset) throws FileNotFoundException {
        if (file.length() == 0L) {
            return "";
        }
        return IOUtil.fromInputStream(new FileInputStream(file), charset);
    }

    public static String fromUri(URI uri, Charset charset) throws IOException {
        return IOUtil.fromUrl(uri.toURL(), charset);
    }

    public static String fromUrl(URL url, Charset charset) throws IOException {
        if (IOUtil.isDisallowedProtocol(url)) {
            throw new IllegalArgumentException("Tried to read disallowed URL protocol: '" + url.toString() + "'");
        }
        return IOUtil.fromInputStream(url.openStream(), charset);
    }

    private static String fromInputStream(InputStream in, Charset charset) {
        try (Scanner scanner = new Scanner((InputStream)new BufferedInputStream(in, 1000000), charset.name());){
            String string = scanner.useDelimiter("\\Z").next();
            return string;
        }
    }

    public static <T extends Serializable> void serialize(T object, String path) throws FileNotFoundException, IOException {
        IOUtil.serialize(object, path, 1000000);
    }

    public static <T extends Serializable> void serialize(T object, String path, int bufferSize) throws FileNotFoundException, IOException {
        File file = new File(path);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(path), bufferSize));){
            oos.writeObject(object);
        }
    }

    public static <T extends Serializable> Optional<T> deserialize(String path, Class<T> clazz) throws IOException, ClassNotFoundException {
        try (BufferedInputStream is = IOUtil.getInputStream(path);){
            Optional<T> optional = IOUtil.deserialize(is, clazz);
            return optional;
        }
    }

    public static <T extends Serializable> Optional<T> deserialize(File path, Class<T> clazz) throws IOException, ClassNotFoundException {
        try (BufferedInputStream is = IOUtil.getInputStream(path);){
            Optional<T> optional = IOUtil.deserialize(is, clazz);
            return optional;
        }
    }

    public static <T extends Serializable> Optional<T> deserialize(InputStream stream, Class<T> clazz) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(stream);){
            Object obj = ois.readObject();
            if (clazz.isInstance(obj)) {
                Optional<T> optional = Optional.of(clazz.cast(obj));
                return optional;
            }
            logger.warning("Invalid class found, expected " + clazz.getName() + " found " + obj.getClass().getName());
            Optional optional = Optional.empty();
            return optional;
        }
    }

    public static PrintStream getPrintStream(String path) throws FileNotFoundException {
        return IOUtil.getPrintStream(path, 1000000);
    }

    public static PrintStream getPrintStream(String path, int bufferSize) throws FileNotFoundException {
        return IOUtil.getPrintStream(new File(path), bufferSize);
    }

    public static PrintStream getPrintStream(File file, int bufferSize) throws FileNotFoundException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file), bufferSize);
        try {
            return new PrintStream((OutputStream)bos, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 isn't supported. Not sure what's wrong with the world.", e);
        }
    }

    public static OutputStream getOutputStream(String path) throws FileNotFoundException {
        return IOUtil.getOutputStream(path, 1000000);
    }

    public static OutputStream getOutputStream(String path, int bufferSize) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(path), bufferSize);
    }

    public static Iterator<Path> getPaths(Path listPath, Path rootPath) {
        try {
            List<String> lines = IOUtil.getLines(listPath.toString());
            ArrayList<Path> paths = new ArrayList<Path>();
            for (String line : lines) {
                Path path = Paths.get(rootPath.toString(), line);
                paths.add(path);
            }
            return paths.iterator();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Iterator<Path> getPaths(String path, String suffix) {
        return IOUtil.getPaths(path, new String[]{suffix});
    }

    public static Iterator<Path> getPaths(String path, String[] suffixes) {
        return IOUtil.getPaths(Paths.get(path, new String[0]), suffixes);
    }

    public static Iterator<Path> getPaths(Path path, String[] suffixes) {
        try {
            Predicate<Path> filter = suffixes != null && suffixes.length > 0 ? p -> {
                String pathName = p.toString();
                for (String suffix : suffixes) {
                    if (!pathName.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            } : p -> true;
            return Files.walk(path, new FileVisitOption[0]).filter(filter).iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterator<Path> getPaths(List<String> fileNames, Path parentPath) {
        return new NamesPathIterator(fileNames.iterator(), parentPath);
    }

    public static InputStream getInputStreamForLocation(String location) {
        URL url = IOUtil.getURLForLocation(location);
        if (url != null) {
            if (IOUtil.isDisallowedProtocol(url)) {
                logger.severe("Tried to open a disallowed URL protocol: " + url.toString());
                return null;
            }
            try {
                InputStream ret = url.openStream();
                if (ret != null) {
                    try {
                        return IOUtil.wrapGZIPStream(ret);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to check stream for GZIP bytes", e);
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.FINER, "Failed to open location " + location);
            }
        }
        return null;
    }

    private static InputStream wrapGZIPStream(InputStream input) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(input, 2);
        byte[] magic = new byte[2];
        int len = pis.read(magic);
        if (len > 0) {
            pis.unread(magic, 0, len);
            if (magic[0] == 31 && magic[1] == -117) {
                return new GZIPInputStream(pis);
            }
            return pis;
        }
        return pis;
    }

    public static URL getURLForLocation(String location) {
        URL ret = IOUtil.class.getResource(location);
        if (ret == null) {
            try {
                ret = new URL(location);
            }
            catch (MalformedURLException ex) {
                try {
                    ret = new File(location).toURI().toURL();
                }
                catch (MalformedURLException ex1) {
                    logger.warning("Cannot open location " + location);
                    return null;
                }
            }
        }
        return ret;
    }

    public static boolean isDisallowedProtocol(URL url) {
        if (url == null) {
            return true;
        }
        String protocol = url.getProtocol();
        if (protocol == null) {
            return true;
        }
        switch (protocol) {
            case "http": 
            case "https": 
            case "ftp": {
                return true;
            }
        }
        return false;
    }

    public static Iterator<String> getStringPaths(Iterator<Path> paths) {
        return new StringPathIterator(paths);
    }

    public static URI createClasspathURI(String resourcePath) throws URISyntaxException {
        return new URI("classpath:" + resourcePath);
    }

    public static String replaceBackSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static class StringPathIterator
    implements Iterator<String> {
        private final Iterator<Path> paths;

        public StringPathIterator(Iterator<Path> paths) {
            this.paths = paths;
        }

        @Override
        public boolean hasNext() {
            return this.paths.hasNext();
        }

        @Override
        public String next() {
            return this.paths.next().toString();
        }
    }

    public static class NamesPathIterator
    implements Iterator<Path> {
        private final Iterator<String> fileNames;
        private final Path parentPath;

        public NamesPathIterator(Iterator<String> fileNames, Path parentPath) {
            this.fileNames = fileNames;
            this.parentPath = parentPath;
        }

        @Override
        public boolean hasNext() {
            return this.fileNames.hasNext();
        }

        @Override
        public Path next() {
            if (this.hasNext()) {
                return Paths.get(this.parentPath.toString(), this.fileNames.next());
            }
            throw new NoSuchElementException();
        }
    }
}

