/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.credentials.oss;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClientBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.notifications.core.credentials.SesClientFactory;
import org.opensearch.notifications.core.credentials.oss.CredentialsProviderFactory;
import org.opensearch.notifications.core.utils.SecurityAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/opensearch/notifications/core/credentials/oss/SesClientFactoryImpl;", "Lorg/opensearch/notifications/core/credentials/SesClientFactory;", "()V", "createSesClient", "Lcom/amazonaws/services/simpleemail/AmazonSimpleEmailService;", "region", "", "roleArn", "opensearch-notifications-core"})
public final class SesClientFactoryImpl
implements SesClientFactory {
    @NotNull
    public static final SesClientFactoryImpl INSTANCE = new SesClientFactoryImpl();

    private SesClientFactoryImpl() {
    }

    @Override
    @NotNull
    public AmazonSimpleEmailService createSesClient(@NotNull String region, @Nullable String roleArn) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        AmazonSimpleEmailService amazonSimpleEmailService = SecurityAccess.INSTANCE.doPrivileged(() -> SesClientFactoryImpl.createSesClient$lambda$0(region, roleArn));
        Intrinsics.checkNotNullExpressionValue((Object)amazonSimpleEmailService, (String)"doPrivileged(...)");
        return amazonSimpleEmailService;
    }

    private static final AmazonSimpleEmailService createSesClient$lambda$0(String $region, String $roleArn) {
        Intrinsics.checkNotNullParameter((Object)$region, (String)"$region");
        AWSCredentialsProvider credentials = new CredentialsProviderFactory().getCredentialsProvider($region, $roleArn);
        return (AmazonSimpleEmailService)((AmazonSimpleEmailServiceClientBuilder)((AmazonSimpleEmailServiceClientBuilder)AmazonSimpleEmailServiceClientBuilder.standard().withRegion($region)).withCredentials(credentials)).build();
    }
}

