/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

final class FlatteningDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private static final long serialVersionUID = -2133095337545715498L;
    private static final Pattern IS_FLATTENED_PATTERN = Pattern.compile(".+[^\\\\]\\..+");
    private static final Pattern SPLIT_KEY_PATTERN = Pattern.compile("((?<!\\\\))\\.");
    private final BeanDescription beanDescription;
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;
    private final boolean classHasJsonFlatten;

    protected FlatteningDeserializer(BeanDescription beanDesc, JsonDeserializer<?> defaultDeserializer, ObjectMapper mapper) {
        super(beanDesc.getBeanClass());
        this.beanDescription = beanDesc;
        this.defaultDeserializer = defaultDeserializer;
        this.mapper = mapper;
        this.classHasJsonFlatten = beanDesc.getClassAnnotations().has(JsonFlatten.class);
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                boolean hasJsonFlattenOnClass = beanDesc.getClassAnnotations().has(JsonFlatten.class);
                boolean hasJsonFlattenOnProperty = beanDesc.findProperties().stream().filter(BeanPropertyDefinition::hasField).map(BeanPropertyDefinition::getField).anyMatch(field -> field.hasAnnotation(JsonFlatten.class));
                if (hasJsonFlattenOnClass || hasJsonFlattenOnProperty) {
                    return new FlatteningDeserializer(beanDesc, deserializer, mapper);
                }
                return deserializer;
            }
        });
        return module;
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext cxt, TypeDeserializer tDeserializer) throws IOException {
        JsonNode currentJsonNode = (JsonNode)this.mapper.readTree(jp);
        Class tClass = this.defaultDeserializer.handledType();
        for (Class<?> c : TypeUtil.getAllClasses(tClass)) {
            String typeIdOnWire;
            JsonNode typeIdValue;
            String typeId;
            JsonTypeInfo typeInfo = c.getAnnotation(JsonTypeInfo.class);
            if (typeInfo == null || !FlatteningDeserializer.containsDot(typeId = typeInfo.property()) || (typeIdValue = ((ObjectNode)currentJsonNode).remove(typeIdOnWire = FlatteningDeserializer.unescapeEscapedDots(typeId))) == null) continue;
            ((ObjectNode)currentJsonNode).set(typeId, typeIdValue);
        }
        return tDeserializer.deserializeTypedFromAny(FlatteningDeserializer.newJsonParserForNode(currentJsonNode), cxt);
    }

    public Object deserialize(JsonParser jp, DeserializationContext cxt) throws IOException {
        JsonNode currentJsonNode = cxt.readTree(jp);
        if (currentJsonNode.isNull()) {
            currentJsonNode = this.mapper.getNodeFactory().objectNode();
        }
        for (BeanPropertyDefinition beanPropertyDefinition : this.beanDescription.findProperties()) {
            if (!beanPropertyDefinition.hasField()) continue;
            this.handleFlatteningForField(beanPropertyDefinition.getField(), currentJsonNode);
        }
        return this.defaultDeserializer.deserialize(FlatteningDeserializer.newJsonParserForNode(currentJsonNode), cxt);
    }

    public void resolve(DeserializationContext cxt) throws JsonMappingException {
        if (this.defaultDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)this.defaultDeserializer).resolve(cxt);
        }
    }

    private void handleFlatteningForField(AnnotatedField annotatedField, JsonNode jsonNode) {
        JsonProperty jsonProperty = (JsonProperty)annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            String jsonPropValue = jsonProperty.value();
            if (jsonNode.has(jsonPropValue)) {
                String escapedJsonPropValue = jsonPropValue.replace(".", "\\.");
                ((ObjectNode)jsonNode).set(escapedJsonPropValue, jsonNode.get(jsonPropValue));
            }
            if ((this.classHasJsonFlatten || annotatedField.hasAnnotation(JsonFlatten.class)) && IS_FLATTENED_PATTERN.matcher(jsonPropValue).matches()) {
                String[] jsonNodeKeys = (String[])Arrays.stream(SPLIT_KEY_PATTERN.split(jsonPropValue)).map(FlatteningDeserializer::unescapeEscapedDots).toArray(String[]::new);
                int depth = 0;
                ArrayList<JsonNode> nodePath = new ArrayList<JsonNode>();
                nodePath.add(jsonNode);
                ++depth;
                JsonNode nodeToAdd = jsonNode;
                for (String jsonNodeKey : jsonNodeKeys) {
                    nodeToAdd = nodeToAdd.get(jsonNodeKey);
                    ++depth;
                    if (nodeToAdd == null) break;
                    nodePath.add(nodeToAdd);
                }
                if (nodePath.size() == depth - 1) {
                    ((ObjectNode)jsonNode).set(jsonPropValue, null);
                    return;
                }
                if (!((JsonNode)nodePath.get(nodePath.size() - 2)).has(jsonNodeKeys[jsonNodeKeys.length - 1])) {
                    ((ObjectNode)jsonNode).set(jsonPropValue, null);
                } else {
                    ((ObjectNode)jsonNode).set(jsonPropValue, (JsonNode)nodePath.get(nodePath.size() - 1));
                }
                for (int i = nodePath.size() - 2; i >= 0 && (i != nodePath.size() - 2 || nodePath.size() - 1 == jsonNodeKeys.length || ((JsonNode)nodePath.get(i)).get(jsonNodeKeys[i]).size() == 0); --i) {
                    ((ObjectNode)nodePath.get(i)).remove(jsonNodeKeys[i]);
                    if (((JsonNode)nodePath.get(i)).size() > 0) break;
                }
            }
        }
    }

    private static String unescapeEscapedDots(String key) {
        return key.replace("\\.", ".");
    }

    private static boolean containsDot(String str) {
        return !CoreUtils.isNullOrEmpty(str) && str.contains(".");
    }

    private static JsonParser newJsonParserForNode(JsonNode jsonNode) throws IOException {
        JsonParser parser = new JsonFactory().createParser(jsonNode.toString());
        parser.nextToken();
        return parser;
    }
}

