/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.DebugRunConfigurationCommand;
import com.jetbrains.performancePlugin.commands.RunConfigurationCommand;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugRunConfigurationCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nDebugRunConfigurationCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugRunConfigurationCommand.kt\ncom/jetbrains/performancePlugin/commands/DebugRunConfigurationCommand\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,106:1\n3829#2:107\n4344#2,2:108\n*S KotlinDebug\n*F\n+ 1 DebugRunConfigurationCommand.kt\ncom/jetbrains/performancePlugin/commands/DebugRunConfigurationCommand\n*L\n49#1:107\n49#1:108,2\n*E\n"})
public final class DebugRunConfigurationCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%debugRunConfiguration";
    @NotNull
    public static final String SPAN_NAME = "debugRunConfiguration";

    public DebugRunConfigurationCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList arguments = this.extractCommandList(PREFIX, ",");
        if (arguments.isEmpty()) {
            callback2.reject("Usage %debugStep &lt;configuration_name&gt; [&lt;timeout_in_seconds&gt;]");
            return;
        }
        String configurationNameToRun = (String)arguments.get(0);
        Ref.ObjectRef timeoutInSeconds = new Ref.ObjectRef();
        if (arguments.size() > 1) {
            Object e = arguments.get(1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            timeoutInSeconds.element = Long.parseLong((String)e);
        }
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)context.getProject()).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        XBreakpoint[] xBreakpointArray = breakpointManager.getAllBreakpoints();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointArray, (String)"getAllBreakpoints(...)");
        Object[] $this$filter$iv = xBreakpointArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            XBreakpoint it = (XBreakpoint)element$iv$iv;
            boolean bl = false;
            if (!(!breakpointManager.isDefaultBreakpoint(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonDefaultBreakpoints = (List)destination$iv$iv;
        if (nonDefaultBreakpoints.isEmpty()) {
            callback2.reject("Breakpoint for this project were not found");
            return;
        }
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(project);
        RunConfiguration configurationToRun = RunConfigurationCommand.getConfigurationByName((RunManager)runManager, configurationNameToRun);
        if (configurationToRun == null) {
            callback2.reject("Specified configuration was not found: " + configurationNameToRun);
            return;
        }
        SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME).setParent(PerformanceTestSpan.getContext());
        Ref spanRef = new Ref();
        Ref scopeRef = new Ref();
        MessageBusConnection connection = context.getProject().getMessageBus().connect();
        Ref.ObjectRef job2 = new Ref.ObjectRef();
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new XDebuggerManagerListener((Ref.ObjectRef<Long>)timeoutInSeconds, (Ref.ObjectRef<Job>)job2, callback2, configurationNameToRun, connection, (Ref<Span>)spanRef, (Ref<Scope>)scopeRef){
            final /* synthetic */ Ref.ObjectRef<Long> $timeoutInSeconds;
            final /* synthetic */ Ref.ObjectRef<Job> $job;
            final /* synthetic */ ActionCallback $callback;
            final /* synthetic */ String $configurationNameToRun;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Ref<Span> $spanRef;
            final /* synthetic */ Ref<Scope> $scopeRef;
            {
                this.$timeoutInSeconds = $timeoutInSeconds;
                this.$job = $job;
                this.$callback = $callback;
                this.$configurationNameToRun = $configurationNameToRun;
                this.$connection = $connection;
                this.$spanRef = $spanRef;
                this.$scopeRef = $scopeRef;
            }

            public void processStarted(XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                if (this.$timeoutInSeconds.element != null) {
                    this.$job.element = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$timeoutInSeconds, this.$callback, this.$configurationNameToRun, this.$connection, null){
                        int label;
                        final /* synthetic */ Ref.ObjectRef<Long> $timeoutInSeconds;
                        final /* synthetic */ ActionCallback $callback;
                        final /* synthetic */ String $configurationNameToRun;
                        final /* synthetic */ MessageBusConnection $connection;
                        {
                            this.$timeoutInSeconds = $timeoutInSeconds;
                            this.$callback = $callback;
                            this.$configurationNameToRun = $configurationNameToRun;
                            this.$connection = $connection;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (!Waiter.checkCondition(() -> execute.processStarted.1.invokeSuspend$lambda$0(this.$callback)).await(((Number)this.$timeoutInSeconds.element).longValue(), TimeUnit.SECONDS)) {
                                        this.$callback.reject("Debug run configuration " + this.$configurationNameToRun + " was started " + this.$timeoutInSeconds.element + " seconds ago but was not paused by any breakpoint yet");
                                        this.$connection.disconnect();
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final boolean invokeSuspend$lambda$0(ActionCallback $callback) {
                            return $callback.isDone() || $callback.isRejected();
                        }
                    }), (int)3, null);
                }
                debugProcess.getSession().addSessionListener(new XDebugSessionListener(this.$callback, this.$spanRef, this.$scopeRef, this.$connection, this.$job){
                    final /* synthetic */ ActionCallback $callback;
                    final /* synthetic */ Ref<Span> $spanRef;
                    final /* synthetic */ Ref<Scope> $scopeRef;
                    final /* synthetic */ MessageBusConnection $connection;
                    final /* synthetic */ Ref.ObjectRef<Job> $job;
                    {
                        this.$callback = $callback;
                        this.$spanRef = $spanRef;
                        this.$scopeRef = $scopeRef;
                        this.$connection = $connection;
                        this.$job = $job;
                    }

                    public void sessionPaused() {
                        block0: {
                            super.sessionPaused();
                            this.$callback.setDone();
                            ((Span)this.$spanRef.get()).end();
                            ((Scope)this.$scopeRef.get()).close();
                            this.$connection.disconnect();
                            Job job2 = (Job)this.$job.element;
                            if (job2 == null) break block0;
                            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                        }
                    }
                });
            }
        });
        ApplicationManager.getApplication().runWriteAction(Context.current().wrap(() -> DebugRunConfigurationCommand.execute$lambda$1(runManager, configurationToRun, spanRef, spanBuilder, scopeRef, context)));
    }

    private static final void execute$lambda$1(RunManagerImpl $runManager, RunConfiguration $configurationToRun, Ref $spanRef, SpanBuilder $spanBuilder, Ref $scopeRef, PlaybackContext $context) {
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettings = new RunnerAndConfigurationSettingsImpl($runManager, $configurationToRun, false, null, 12, null);
        $spanRef.set((Object)$spanBuilder.startSpan());
        $scopeRef.set((Object)((Span)$spanRef.get()).makeCurrent());
        Project project = $context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ExecutionManager executionManager = ExecutionManager.Companion.getInstance(project);
        Project project2 = $context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Executor executor = (Executor)new DefaultDebugExecutor();
        ExecutionTarget executionTarget = DefaultExecutionTarget.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executionTarget, (String)"INSTANCE");
        executionManager.restartRunProfile(project2, executor, executionTarget, (RunnerAndConfigurationSettings)runnerAndConfigurationSettings, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugRunConfigurationCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "SPAN_NAME", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

