/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnEditCommitMessageAction;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public class SvnEditCommitMessageFromFileHistoryAction
extends DumbAwareAction {
    public SvnEditCommitMessageFromFileHistoryAction() {
        super(SvnBundle.messagePointer("action.EditCommitMessage.text", new Object[0]), SvnBundle.messagePointer("action.EditCommitMessage.description", new Object[0]), AllIcons.Actions.Edit);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SvnEditCommitMessageFromFileHistoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SvnEditCommitMessageFromFileHistoryAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (vcsKey == null || !SvnVcs.getKey().equals((Object)vcsKey)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revision == null || revisionVirtualFile == null) {
            return;
        }
        SvnFileRevision svnFileRevision = (SvnFileRevision)revision;
        Consumer listener2 = (Consumer)e.getData(VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER);
        SvnEditCommitMessageAction.askAndEditRevision(svnFileRevision.getRevision().getNumber(), svnFileRevision.getCommitMessage(), svnFileRevision.getChangedRepositoryPath(), project, (Consumer<? super String>)((Consumer)newMessage -> {
            svnFileRevision.setCommitMessage((String)newMessage);
            if (listener2 != null) {
                listener2.consume(newMessage);
            }
            List revisions = ProjectLevelVcsManager.getInstance((Project)project).getVcsHistoryCache().getRevisions(VcsUtil.getFilePath((VirtualFile)revisionVirtualFile), vcsKey);
            for (VcsFileRevision fileRevision : revisions) {
                if (!(fileRevision instanceof SvnFileRevision) || ((SvnFileRevision)fileRevision).getRevision().getNumber() != svnFileRevision.getRevision().getNumber()) continue;
                ((SvnFileRevision)fileRevision).setCommitMessage((String)newMessage);
                break;
            }
        }), true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SvnEditCommitMessageFromFileHistoryAction.$$$reportNull$$$0(2);
        }
        VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        boolean isSvn = SvnVcs.getKey().equals((Object)vcsKey);
        e.getPresentation().setVisible(isSvn);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        e.getPresentation().setEnabled(isSvn && revision != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnEditCommitMessageFromFileHistoryAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnEditCommitMessageFromFileHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

