/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.logger;

import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.internal.statistic.eventLog.logger.EventsRateResult;
import com.intellij.internal.statistic.eventLog.logger.EventsRateResultType;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsIdentityWindowThrottle;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u0017H\u0016J\b\u0010)\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/internal/statistic/eventLog/logger/StatisticsEventLogThrottleWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "configOptionsService", "Lcom/intellij/internal/statistic/eventLog/EventLogConfigOptionsService;", "recorderId", "", "recorderVersion", "delegate", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/EventLogConfigOptionsService;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;Lkotlinx/coroutines/CoroutineScope;)V", "ourLock", "", "ourThrottle", "Lcom/intellij/internal/statistic/utils/EventsRateWindowThrottle;", "ourGroupThrottle", "Lcom/intellij/internal/statistic/utils/EventsIdentityWindowThrottle;", "getOrDefault", "", "value", "defaultValue", "log", "", "logEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "copyEvent", "eventId", "groupId", "groupVersion", "tryPass", "Lcom/intellij/internal/statistic/eventLog/logger/EventsRateResult;", "group", "now", "", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "cleanup", "rollOver", "dispose", "intellij.platform.statistics"})
public final class StatisticsEventLogThrottleWriter
implements StatisticsEventLogWriter {
    @NotNull
    private final String recorderId;
    @NotNull
    private final String recorderVersion;
    @NotNull
    private final StatisticsEventLogWriter delegate;
    @NotNull
    private final Object ourLock;
    @NotNull
    private final EventsRateWindowThrottle ourThrottle;
    @NotNull
    private final EventsIdentityWindowThrottle ourGroupThrottle;

    public StatisticsEventLogThrottleWriter(@NotNull EventLogConfigOptionsService configOptionsService, @NotNull String recorderId, @NotNull String recorderVersion, @NotNull StatisticsEventLogWriter delegate, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)configOptionsService, (String)"configOptionsService");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.recorderId = recorderId;
        this.recorderVersion = recorderVersion;
        this.delegate = delegate;
        this.ourLock = new Object();
        EventLogOptions eventLogOptions = configOptionsService.getOptions(this.recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)eventLogOptions, (String)"getOptions(...)");
        EventLogOptions configOptions = eventLogOptions;
        int threshold = this.getOrDefault(configOptions.getThreshold(), 24000);
        this.ourThrottle = new EventsRateWindowThrottle(threshold, 3600000L, System.currentTimeMillis());
        int groupThreshold = this.getOrDefault(configOptions.getGroupThreshold(), 12000);
        int groupAlertThreshold = this.getOrDefault(configOptions.getGroupAlertThreshold(), 6000);
        this.ourGroupThrottle = new EventsIdentityWindowThrottle(groupThreshold, groupAlertThreshold, 3600000L);
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(coroutineScope);
        Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        String string = this.recorderId;
        simpleMessageBusConnection.subscribe(topic, (Object)new EventLogConfigOptionsService.EventLogThresholdConfigOptionsListener(string){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onThresholdChanged(int newValue) {
                if (newValue > 0) {
                    Object object = ourLock;
                    StatisticsEventLogThrottleWriter statisticsEventLogThrottleWriter = this;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        statisticsEventLogThrottleWriter.ourThrottle.setThreshold(newValue);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupThresholdChanged(int newValue) {
                if (newValue > 0) {
                    Object object = ourLock;
                    StatisticsEventLogThrottleWriter statisticsEventLogThrottleWriter = this;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        statisticsEventLogThrottleWriter.ourGroupThrottle.setThreshold(newValue);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGroupAlertThresholdChanged(int newValue) {
                if (newValue > 0) {
                    Object object = ourLock;
                    StatisticsEventLogThrottleWriter statisticsEventLogThrottleWriter = this;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        statisticsEventLogThrottleWriter.ourGroupThrottle.setAlertThreshold(newValue);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        });
    }

    private final int getOrDefault(int value, int defaultValue) {
        return value > 0 ? value : defaultValue;
    }

    @Override
    public void log(@NotNull LogEvent logEvent) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        EventsRateResult shouldLog = this.tryPass(logEvent.getGroup().getId(), System.currentTimeMillis());
        if (shouldLog.getType() == EventsRateResultType.ALERT_GROUP) {
            LogEvent alert = this.copyEvent("validation.too_many_events.alert", logEvent.getGroup().getId(), logEvent.getGroup().getVersion(), logEvent);
            this.delegate.log(alert);
            this.delegate.log(logEvent);
            return;
        }
        if (shouldLog.getType() == EventsRateResultType.ACCEPTED) {
            this.delegate.log(logEvent);
            return;
        }
        if (shouldLog.getReport()) {
            String errorGroupId = shouldLog.getType() == EventsRateResultType.DENIED_TOTAL ? StatisticsEventLogProviderUtil.getEventLogProvider(this.recorderId).getEventLogSystemLogger$intellij_platform_statistics().getGroup().getId() : logEvent.getGroup().getId();
            String errorGroupVersion = shouldLog.getType() == EventsRateResultType.DENIED_TOTAL ? this.recorderVersion : logEvent.getGroup().getVersion();
            LogEvent event = this.copyEvent("validation.too_many_events", errorGroupId, errorGroupVersion, logEvent);
            this.delegate.log(event);
            return;
        }
    }

    private final LogEvent copyEvent(String eventId, String groupId, String groupVersion, LogEvent logEvent) {
        return new LogEvent(logEvent.getSession(), logEvent.getBuild(), logEvent.getBucket(), logEvent.getTime(), new LogEventGroup(groupId, groupVersion), logEvent.getRecorderVersion(), new LogEventAction(eventId, logEvent.getEvent().getState(), null, 0, 12, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EventsRateResult tryPass(String group, long now) {
        Object object = this.ourLock;
        synchronized (object) {
            block8: {
                EventRateThrottleResult groupResult;
                block7: {
                    block6: {
                        boolean bl = false;
                        EventRateThrottleResult result = this.ourThrottle.tryPass(now);
                        if (result.isAccept()) break block6;
                        boolean report = result == EventRateThrottleResult.DENY_AND_REPORT;
                        EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.DENIED_TOTAL, report);
                        return eventsRateResult;
                    }
                    groupResult = this.ourGroupThrottle.tryPass(group, now);
                    if (groupResult.isAccept()) break block7;
                    boolean report = groupResult == EventRateThrottleResult.DENY_AND_REPORT;
                    EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.DENIED_GROUP, report);
                    return eventsRateResult;
                }
                if (groupResult != EventRateThrottleResult.ALERT) break block8;
                EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.ALERT_GROUP, true);
                return eventsRateResult;
            }
            EventsRateResult eventsRateResult = new EventsRateResult(EventsRateResultType.ACCEPTED, false);
            return eventsRateResult;
        }
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        return this.delegate.getActiveFile();
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return this.delegate.getLogFilesProvider();
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public void rollOver() {
        this.delegate.rollOver();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.delegate);
    }
}

