/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class BufferCache<T> {
    private static final double ln2;
    private static final int BUFFERS_PER_BUCKET = 8;
    private static final int MIN_INDEX = 12;
    private final InternalStatistics stats;
    private final int[] bufferSize;
    private final SoftReference<T>[][] buckets;
    private final int[] top;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    BufferCache(int maxCachedBufferSize) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, BufferCache.class, $$$methodRef$$$4, null, maxCachedBufferSize);
            }
            int maxIndex = maxCachedBufferSize < 31 ? maxCachedBufferSize : (int)Math.ceil(Math.log(maxCachedBufferSize) / ln2);
            int numBuckets = Math.max(0, maxIndex - 12 + 1);
            this.buckets = new SoftReference[numBuckets][8];
            this.top = new int[numBuckets];
            this.bufferSize = new int[numBuckets];
            int s2 = 4096;
            for (int i2 = 0; i2 < this.bufferSize.length; ++i2) {
                this.bufferSize[i2] = s2;
                s2 <<= 1;
            }
            this.stats = new InternalStatistics(this.bufferSize);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BufferCache.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BufferCache.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BufferCache.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    T get(Class<?> clazz, int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void baseType;
            void length;
            int b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, clazz, n2);
            }
            if ((b2 = this.bufferIndex((int)length)) >= this.buckets.length) {
                this.stats.requestTooBig();
                Object object = Array.newInstance(baseType, (int)length);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, object);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, null);
                }
                return (T)object;
            }
            while (this.top[b2] > 0) {
                int n3 = b2;
                int n4 = this.top[n3] - 1;
                this.top[n3] = n4;
                SoftReference<T> ref = this.buckets[b2][n4];
                this.buckets[b2][this.top[b2]] = null;
                T buf = ref.get();
                if (buf == null) continue;
                this.stats.cacheHit(b2);
                T t2 = buf;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, t2);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, null);
                }
                return t2;
            }
            this.stats.cacheMiss(b2);
            Object object = Array.newInstance(baseType, this.bufferSize[b2]);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, object);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, null);
            }
            return (T)object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BufferCache.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void put(T t2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void buffer;
            int len;
            int b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this, t2);
            }
            if ((b2 = this.bufferIndex(len = Array.getLength(buffer))) >= this.buckets.length || len != this.bufferSize[b2]) {
                this.stats.cacheTooBig();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            if (this.top[b2] < 8) {
                this.stats.bufferCached(b2);
                int n2 = b2;
                int n3 = this.top[n2];
                this.top[n2] = n3 + 1;
                this.buckets[b2][n3] = new SoftReference<void>(buffer);
            } else {
                int i2 = this.top[b2];
                while (i2 > 0) {
                    if (this.buckets[b2][--i2].get() != null) continue;
                    this.stats.refCleared(b2);
                    this.buckets[b2][i2] = new SoftReference<void>(buffer);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this, null);
                    }
                    return;
                }
                this.stats.bucketFull(b2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BufferCache.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    OracleConnection.BufferCacheStatistics getStatistics() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BufferCache.class, $$$methodRef$$$2, this, new Object[0]);
            }
            InternalStatistics internalStatistics = this.stats;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BufferCache.class, $$$methodRef$$$2, this, internalStatistics);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BufferCache.class, $$$methodRef$$$2, this, null);
            }
            return internalStatistics;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BufferCache.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int bufferIndex(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BufferCache.class, $$$methodRef$$$3, this, n2);
            }
            for (int i2 = 0; i2 < this.bufferSize.length; ++i2) {
                void n3;
                if (n3 > this.bufferSize[i2]) continue;
                int n4 = i2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BufferCache.class, $$$methodRef$$$3, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BufferCache.class, $$$methodRef$$$3, this, null);
                }
                return n4;
            }
            int n5 = Integer.MAX_VALUE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BufferCache.class, $$$methodRef$$$3, this, n5);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BufferCache.class, $$$methodRef$$$3, this, null);
            }
            return Integer.MAX_VALUE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BufferCache.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = BufferCache.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BufferCache.class.getDeclaredMethod("bufferIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BufferCache.class.getDeclaredMethod("getStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BufferCache.class.getDeclaredMethod("put", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BufferCache.class.getDeclaredMethod("get", Class.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        ln2 = Math.log(2.0);
    }

    private static final class InternalStatistics
    implements OracleConnection.BufferCacheStatistics {
        private static int CACHE_COUNT;
        private final int cacheId = ++CACHE_COUNT;
        private final int[] sizes;
        private final int[] nCacheHit;
        private final int[] nCacheMiss;
        private int nRequestTooBig;
        private final int[] nBufferCached;
        private final int[] nBucketFull;
        private final int[] nRefCleared;
        private int nCacheTooBig;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;

        InternalStatistics(int[] sizes) {
            this.sizes = sizes;
            int n2 = sizes.length;
            this.nCacheHit = new int[n2];
            this.nCacheMiss = new int[n2];
            this.nRequestTooBig = 0;
            this.nBufferCached = new int[n2];
            this.nBucketFull = new int[n2];
            this.nRefCleared = new int[n2];
            this.nCacheTooBig = 0;
        }

        void cacheHit(int b2) {
            int n2 = b2;
            this.nCacheHit[n2] = this.nCacheHit[n2] + 1;
        }

        void cacheMiss(int b2) {
            int n2 = b2;
            this.nCacheMiss[n2] = this.nCacheMiss[n2] + 1;
        }

        void requestTooBig() {
            ++this.nRequestTooBig;
        }

        void bufferCached(int b2) {
            int n2 = b2;
            this.nBufferCached[n2] = this.nBufferCached[n2] + 1;
        }

        void bucketFull(int b2) {
            int n2 = b2;
            this.nBucketFull[n2] = this.nBucketFull[n2] + 1;
        }

        void refCleared(int b2) {
            int n2 = b2;
            this.nRefCleared[n2] = this.nRefCleared[n2] + 1;
        }

        void cacheTooBig() {
            ++this.nCacheTooBig;
        }

        @Override
        public int getId() {
            return this.cacheId;
        }

        @Override
        public int[] getBufferSizes() {
            int[] a2 = new int[this.sizes.length];
            System.arraycopy(this.sizes, 0, a2, 0, this.sizes.length);
            return a2;
        }

        @Override
        public int getCacheHits(int n2) {
            return this.nCacheHit[n2];
        }

        @Override
        public int getCacheMisses(int n2) {
            return this.nCacheMiss[n2];
        }

        public int getRequestsTooBig() {
            return this.nRequestTooBig;
        }

        @Override
        public int getBuffersCached(int n2) {
            return this.nBufferCached[n2];
        }

        @Override
        public int getBucketsFull(int n2) {
            return this.nBucketFull[n2];
        }

        @Override
        public int getReferencesCleared(int n2) {
            return this.nRefCleared[n2];
        }

        @Override
        public int getTooBigToCache() {
            return this.nCacheTooBig;
        }

        @DisableTrace
        public String toString() {
            int totalHits = 0;
            int totalMisses = 0;
            int totalCached = 0;
            int totalDropped = 0;
            int totalCleared = 0;
            for (int i2 = 0; i2 < this.sizes.length; ++i2) {
                totalHits += this.nCacheHit[i2];
                totalMisses += this.nCacheMiss[i2];
                totalCached += this.nBufferCached[i2];
                totalDropped += this.nBucketFull[i2];
                totalCleared += this.nRefCleared[i2];
            }
            String s2 = "oracle.jdbc.driver.BufferCache<" + this.cacheId + ">\n\tTotal Hits   :\t" + totalHits + "\n\tTotal Misses :\t" + (totalMisses + this.nRequestTooBig) + "\n\tTotal Cached :\t" + totalCached + "\n\tTotal Dropped:\t" + (totalDropped + this.nCacheTooBig) + "\n\tTotal Cleared:\t" + totalCleared + "\n";
            return s2;
        }

        static {
            try {
                $$$methodRef$$$16 = InternalStatistics.class.getDeclaredConstructor(int[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = InternalStatistics.class.getDeclaredMethod("getTooBigToCache", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = InternalStatistics.class.getDeclaredMethod("getReferencesCleared", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = InternalStatistics.class.getDeclaredMethod("getBucketsFull", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = InternalStatistics.class.getDeclaredMethod("getBuffersCached", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = InternalStatistics.class.getDeclaredMethod("getRequestsTooBig", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = InternalStatistics.class.getDeclaredMethod("getCacheMisses", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = InternalStatistics.class.getDeclaredMethod("getCacheHits", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = InternalStatistics.class.getDeclaredMethod("getBufferSizes", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = InternalStatistics.class.getDeclaredMethod("getId", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = InternalStatistics.class.getDeclaredMethod("cacheTooBig", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = InternalStatistics.class.getDeclaredMethod("refCleared", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = InternalStatistics.class.getDeclaredMethod("bucketFull", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = InternalStatistics.class.getDeclaredMethod("bufferCached", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = InternalStatistics.class.getDeclaredMethod("requestTooBig", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = InternalStatistics.class.getDeclaredMethod("cacheMiss", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = InternalStatistics.class.getDeclaredMethod("cacheHit", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            CACHE_COUNT = 0;
        }
    }
}

