/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.List;

public final class BatchCompletion {
    private final int elementCount;
    private final int[] updateCounts;
    private final List<DetailedError> detailedErrors;
    private final int[] simplifiedErrors;

    public BatchCompletion(int elementCount, int[] updateCounts, List<DetailedError> detailedErrors, int[] simplifiedErrors) {
        this.elementCount = elementCount;
        this.updateCounts = updateCounts;
        this.detailedErrors = detailedErrors;
        this.simplifiedErrors = simplifiedErrors;
    }

    public int elementCount() {
        return this.elementCount;
    }

    public int[] updateCounts() {
        return this.updateCounts;
    }

    public List<DetailedError> detailedErrors() {
        return this.detailedErrors;
    }

    public int[] simplifiedErrors() {
        return this.simplifiedErrors;
    }

    public boolean hasErrors() {
        return !this.detailedErrors.isEmpty() || this.simplifiedErrors.length > 0;
    }

    public static final class DetailedError {
        private final int element;
        private final SQLException error;

        public DetailedError(int element, SQLException error) {
            this.element = element;
            this.error = error;
        }

        public int element() {
            return this.element;
        }

        public SQLException error() {
            return this.error;
        }
    }
}

